/*  alarm, ralarm

$Header: /h0/LIBS/OS9LIB/RCS/alarm.c_v 2.0 92/05/31 23:45:32 jl Exp $
$Revision: 2.0 $
$Author: jl $
$Date: 92/05/31 23:45:32 $
$Source: /h0/LIBS/OS9LIB/RCS/alarm.c_v $

*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

static int alarm_id = 0;

/*
 * a l a r m
 */

int alarm( int time )
{
	if (alarm_id != 0) {
		alm_delete(alarm_id);
		alarm_id = 0;
	}

	if (time == 0)            /* only delete alarm */
		return OK;

	if (!(time & 0x80000000)) {
		time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
		time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
	}
  
	if ((alarm_id = alm_set(SIGALRM, time)) == ERROR) {
		alarm_id = 0;
		return ERROR;
	}

	return OK;

}


/*
 * r a l a r m
 */
 
int ralarm( int time )
{
	if (alarm_id != 0) {
		alm_delete(alarm_id);
		alarm_id = 0;
	}

	if (time == 0)
		return OK;

	if (!(time & 0x80000000)) {
		time <<= 8;             /* Zeit wird in 256tel Sekunden angegeben */
		time |= 0x80000000;     /* Flag fuer 1/256 Sekunden */
	}
  
	if ((alarm_id = alm_cycle(SIGALRM, time)) == ERROR) {
		alarm_id = 0;
		return ERROR;
	}

	return OK;

}

