/*
 *	External function definitions for string handling functions
 *
 */

/*
 * Change History:
 *
 * 15/03/94 R.Wilcke, ESRF: 
 *          give argument to function strdup() the "const" qualifier (GCC
 *          compiler gives error of pointer conflict otherwise)
 * 21/03/94 R.Wilcke, ESRF:
 *          add declaration for functions strcasecmp() and strncasecmp()
 * 26/04/94 R.Wilcke, ESRF:
 *          add declaration for function strerror()
 */

#define	strchr(ptr,ch)	index(ptr,ch)
#define	strrchr(ptr,ch)	rindex(ptr,ch)

#ifndef __GNUC__

extern char
	*strcat(), *strncat(),
	*strcpy(), *strncpy(),
	*strset(), *strnset(),
	*strupr(), *strlwr(),
	*index(),  *rindex(),
	*strtok(), *strpbrk(),
	*strstr(), *strset(),
	*strnset(), *strupr(),
	*strlwr(), *strerror();
	
extern int
	strcmp(), strncmp(),
	strcasecmp(), strncasecmp(),
	strlen(), strcspn(),
	strspn();

#else

#define const

extern char
	*strcat( char *, const char * ),
	*strncat( char *, const char *, int ),
	*strcpy( char *, const char * ),
	*strncpy( char *, const char *, int ),
	*index( const char *, char ),
	*rindex( const char *, char ),
	*strtok( char *, const char * ),
	*strpbrk( char *, const char * ),
	*strstr( const char *, const char * ),
	*strdup( const char * ),
	*strset( char *, char ),
	*strnset( char *, char, int ),
	*strupr(char *),
	*strlwr(char *),
	*strerror(int);

extern int
	strcmp(const char* , const char*),
	strncmp(const char* , const char*, int),  
	strcasecmp(const char* , const char*),
	strncasecmp(const char* , const char*, int),  
	strlen(const char *),
	strspn(const char *, const char *),
	strcspn(const char *, const char *);

#endif
