/*
 * Password Definitions
 */
 
#ifndef STDIO
#include <stdio.h>
#endif

struct passwd {
  char *pw_name;
  char *pw_passwd;
  int  pw_uid;
  int  pw_gid;
  int  pw_prio;                 /* OS9: Priority of entry */
  char *pw_age;
  char *pw_comment;
  char *pw_gecos;
  char *pw_dir;
  char *pw_xdir;                /* OS9: Execution Directory */
  char *pw_shell;
  char *pw_junk;                /* everything else... */
};

#define PASSWD	"SYS/password"

#define PW_TIME     't'
#define PW_FLAG     'f'
#define PW_MOTD     'm'
#define PW_NAME     'n'
#define PW_COMMENT  'c'
#define PW_GECOS    'g'


struct gecos {
  char *fullname;
  char *organization;
  char *office_phone;
  char *home_phone;
};

#ifndef __GNUC__

extern struct gecos *getgecos();
extern struct passwd  *getpwent(), *getpwuid(), *getpwnam();
extern int            setpwent();
extern void           endpwent();
extern struct passwd  *fgetpwent();

#else

extern struct gecos
	*getgecos( char * );

extern struct passwd
	*getpwent( void ),
	*getpwuid( int ),
	*getpwnam( char * ),
	*fgetpwent( FILE *);

extern int
	setpwent( void );

extern void
	endpwent( void );

#endif
