#define MAX_MEM 20

struct group {
  char *gr_name;
  char *gr_passwd;
  int  gr_gid;
  char **gr_mem;
};

#ifndef __GNUC__

extern struct group *getgrent(), *getgrgid(), *getgrnam();
extern int          setgrent();
extern void         endgrent();
extern struct group *fgetgrent();

#else

extern struct group 	*getgrent( void ),
			*getgrgid( int ),
			*getgrnam( char * );
extern int		setgrent( void ),
			getgroups( int, int * );
extern void		endgrent( void );
extern struct group	*fgetgrent( FILE * );

#endif

#define GROUP   "SYS/group"
