/*	@(#)types.h 2.23 88/02/08 SMI; from UCB 7.1 6/4/86	*/

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef	_TYPES1_
#define	_TYPES1_

#ifndef mc68000
#define mc68000 68000
#endif

/*
 * Basic system types.
 */

#include <sys/sysmacros.h>
#include <bcopy.h>

#ifndef U_EGAL
typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
#define U_EGAL types
#endif

#ifndef HAVE_USHORT
typedef	unsigned short	ushort;		/* System V compatibility */
#define HAVE_USHORT
#endif
typedef	unsigned int	uint;		/* System V compatibility */
typedef unsigned char	uchar;
typedef unsigned long	ulong;

#ifdef mc68000
typedef struct _physadr { short r[1]; } *physadr;
typedef struct label_t {
	int val[13];
} label_t;
#endif

typedef	struct	_quad { long val[2]; } quad;
typedef	long	daddr_t;

#ifndef _TYPES2_
#define _TYPES2_
typedef	uchar 	*caddr_t;
#endif

typedef	long		ino_t;
typedef	long		swblk_t;
typedef	int			size_t;
typedef	long		dev_t;
typedef	long		off_t;
typedef	unsigned short	uid_t;
typedef	unsigned short	gid_t;
typedef	long		key_t;
typedef unsigned short mode_t;
typedef unsigned long ptrdiff_t;

#define	NBBY	8		/* number of bits in a byte */

/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */

#ifndef	FD_SETSIZE
#define	FD_SETSIZE	32
#endif

typedef	long	fd_mask;
#define	NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */

#ifndef	howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

typedef	char *	addr_t;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define	FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

#endif
