/*
 *  stat.h for OSK : 89/04/10 by A.Seyama
 *
 */

/*
 * Change History:
 *
 * 09/05/94 R.Wilcke, ESRF: 
 *	    add function prototypes for GNU C compiler.
 * 10/05/94 R.Wilcke, ESRF: 
 *	    redefine macros to agree with UNIX definitions, add S_IFNWK and
 *          S_IFSOCK:
 *
 *	    name        old value    new value  meaning
 *	    S_IFMT      0xf080       0xf080     type of file mask
 *	    S_IFCHR     0x0000       0x2000     character special
 *	    S_IFBLK     0x0400       0x6000     block special
 *	    S_IFREG     0x0100       0x8000     regular
 *	    S_IFIFO     0x0200       0x1000     pipe or FIFO
 *	    S_IFNWK       --         0x9000     network special
 *	    S_IFSOCK      --         0xc000     socket
 *
 *	    S_ISUID     0x0800       0x0800     set user id on execution
 *	    S_ISGID     0x1000       0x0400     set group id on execution
 *	    S_ISVTX     0x2000       0x0200     save swapped text even after use
 *
 *          Note: keep the OS-9 definition for S_IFDIR, as the UNIX definition 
 *		  conflicts with the one for OS-9; but change the file mask 
 *		  S_IFMT so that it includes the S_IFDIR bit.
 */

#ifndef STAT_DEF
#ifdef S_IFMT
/*
 *  All definitions in modes.h are present in this file.
 *  Furthermore, some modification is made, so that including 
 *  both stat.h and modes.h may produces an incorrect result.
 *
 */
#error Can not include both stat.h and modes.h.
#endif

#ifndef ctime
/*
 *  MicroWare's configuration of header files are not so good that
 *  including types.h does not give typedef of time_t.
 *  We must include time.h to get typedef of time_t.
 *
 */
#include <time.h>
#endif

/* file modes */
#define S_IFMT   0xf080    /* mask for type of file */
#define S_IFDIR  0x0080    /* directory (OS-9 style bit setting!) */
#define S_IFCHR  0x2000    /* character special (SCF) */
#define S_IFBLK  0x6000    /* block special */
#define S_IFREG  0x8000    /* regular means RBF type device and not directory */
#define S_IFIFO  0x1000    /* pipe or FIFO */
#define S_IFNWK  0x9000    /* network special */
#define S_IFSOCK 0xc000    /* socket */

#define S_ISUID  0x0800    /* set user id on execution */
#define S_ISGID  0x0400    /* set group id on execution */
#define S_ISVTX  0x0200    /* save swapped text even after use */

#define S_ISIZE  0x0020    /* set initial file size */

/* permissions */
#define	S_IPRM		0x007f	/* mask for permission bits */
#define	S_IREAD		0x0001	/* owner read */
#define	S_IWRITE	0x0002	/* owner write */
#define	S_IEXEC		0x0004	/* owner execute */
#define	S_IOREAD	0x0008	/* public read */
#define	S_IOWRITE	0x0010	/* public write */
#define	S_IOEXEC	0x0020	/* public execute */
#define	S_ISHARE	0x0040	/* sharable */

/* permissions (Un*x compatible) */
#define S_IRWXU 0x0007	/* owner read write execute */
#define S_IRUSR	0x0001	/* owner read */
#define S_IWUSR	0x0002	/* owner write */
#define S_IXUSR	0x0004	/* owner execute */
#define S_IRWXG 0x0038  /* public read write execute */
#define S_IRGRP	0x0008	/* public read */
#define S_IWGRP	0x0010	/* public write */
#define S_IXGRP	0x0020	/* public execute */
#define S_IRWXO 0x0038  /* public read write execute */
#define S_IROTH	0x0008	/* public read */
#define S_IWOTH	0x0010	/* public write */
#define S_IXOTH	0x0020	/* public execute */

struct stat {
  long 		st_dev;		/* sg_dvt   (RBF option area)
				   sg_tbl   (SCF option area)		*/
  long		st_ino;		/* sg_fdpsn (option area)		*/
  unsigned short st_mode;	/* sg_class (option area) in MSB
				   fd_att   (file descriptor) in LSB	*/
  short          st_nlink;	/* fd_link  (file descriptor)		*/
  unsigned int   st_rdev;	/* only defined				*/
  unsigned short st_uid;	/* fd_own   (file descriptor)		*/
  unsigned short st_gid;	/* fd_own   (file descriptor)		*/
  unsigned int   st_size;	/* fd_fsize (file descriptor)		*/
  time_t         st_atime;	/* fd_date  (file desctiptor)		*/
  time_t         st_mtime;	/* fd_date  (file desctiptor)		*/
  time_t         st_ctime;	/* fd_dcr   (file desctiptor)		*/
};

#ifndef __GNUC__
extern stat();
extern fstat();
#else
extern int stat(char *, struct stat *);
extern int fstat(int, struct stat *);
#endif /* __GNUC__ */

#define STAT_DEF
#endif
