/* Signal codes used by MGR, defined here 'cause they are missing in the
   signal.h file */
   
#define SIGNONE		0		/* Internal mgr error					*/
#ifndef SIGKILL
#define SIGKILL		0		/* kill (cannot be caught or ignored)			*/
#define SIGWAKE		1		/* wake up						*/
#define SIGQUIT		2		/* keyboard abort					*/
#define SIGINT		3		/* keyboard interrupt					*/
#define SIGHUP		4		/* modem hangup signal					*/
#endif
#define SIGTRAP		5		/* trace trap (not reset when caught)			*/
#define SIGIOT		6		/* IOT instruction					*/
#define SIGEMT		7		/* EMT instruction					*/
#define SIGFPE		8		/* floating point exception				*/
#define SIGILL		9		/* illegal instruction (not reset when caught)		*/
#define SIGBUS		10		/* bus error						*/
#define SIGSEGV		11		/* segmentation violation				*/
#define SIGSYS		12		/* bad argument to system call				*/
#define SIGPIPE		13		/* write on a pipe with no one to read it		*/
#ifndef SIGALRM
#define SIGALRM		14		/* alarm clock						*/
#endif
#define SIGTERM		15		/* software termination signal from kill		*/
#define SIGUSR1		16		/* User Signal 1 */
#define SIGUSR2		17		/* User Signal 2 */
#define SIGCLD		18		/* Death of Child */
#define SIGSTOP		20		/* sendable stop signal not from tty			*/
#define SIGTSTP		21		/* stop signal from tty					*/
#define SIGCONT		22		/* continue a stopped process				*/
#define SIGCHLD		23		/* to parent on child stop or exit			*/
#define SIGTTIN		24		/* to readers pgrp upon background tty read		*/
#define SIGTTOU		25		/* like TTIN for output if (tp->t_local&LTOSTOP)*/
#define SIGIO		26		/* input/output possible signal				*/
#define SIGXCPU		27		/* exceeded CPU time limit				*/
#define SIGXFSZ		28		/* exceeded file size limit				*/
#define SIGVTALRM	29		/* virtual time alarm					*/
#define SIGPROF		30		/* profiling time alarm					*/
#define SIGURG		31
#define SIGARB		31		/* for Kermit						*/
#define SIGWINCH	32		/* window changed					*/

#define NSIG 32

/* special addresses */

#ifndef SIG_DFL
#define        SIG_DFL 0
#define        SIG_IGN 1
#endif

/* E O F */
