/* fcntl.h header adjusted for OS-9 */

/*
 * Change History:
 *
 * 17/05/94 R.Wilcke, ESRF: 
 *	    change definition of O_TRUNC from (S_IREAD | S_IWRITE) to 0x20
 */

#ifndef _FCNTL_
#define _FCNTL

#ifndef S_IREAD
#include <stat.h>
#endif

#define  UPDATE_   UPDAT_

#define	FNDELAY		000004		/* non-blocking I/O (4.2 style) */
#define	FAPPEND		000010		/* append on each write */
#define	FASYNC		000100		/* signal pgrp when data ready */
#define	FCREAT		001000		/* create if nonexistent */
#define	FTRUNC		002000		/* truncate to zero length */
#define	FEXCL		004000		/* error if already created */
#define	FNBIO		010000		/* non-blocking I/O (S5-style) */
#define	FSYNC		020000		/* synchronous writes */

#define  F_DUPFD   0	     /* Dupliziere fildes */
#define  F_GETFD   1	     /* Get fildes flags */

#define  F_SETFD   2         /* Set fildes flags */
#define  F_GETFL   3         /* Get file flags   */
#define  F_SETFL   4         /* Set file flags   */
#define  F_SETOWN  6         /* Set Owner	 */

/* WN ---
#define open unix_open
#define creat unix_creat
*/

#ifndef O_RDONLY
#define O_RDONLY	S_IREAD
#define O_WRONLY	S_IWRITE
#define O_RDWR		(S_IREAD | S_IWRITE)
#define O_TRUNC		0x20
#define O_APPEND	4
#define O_EXCL		8
#define O_CREAT		0x10
#define	O_NDELAY	0
#endif

#define _IOFBF		0
#define _IOLBF		1
#define _IONBF		2

#endif
