/* structure for manipulating OS-9 directories in a (more)
	transportable manner.  The method and names work like
	the BSD4.2 directory calls
*/

/*
 * Change History:
 *
 * 09/06/94 R.Wilcke, ESRF: 
 *          remove include of <sys/file.h> - is not needed;
 *	    add defines for "d_ino" and "d_fileno" for UNIX compatibility.
 * 22/06/94 R.Wilcke, ESRF: 
 *          declare function unix_opendir()
 * 24/06/94 R.Wilcke, ESRF: 
 *          declare macro to replace "opendir" by "unix_opendir"
 */

#define MAXNAMLEN 32
#define DIRBLKSIZ 256

struct direct {
	long	d_addr;			/* fildes address (no inodes on OS-9) */
	short	d_reclen;		/* (not used) */
	short	d_namlen;		/* (not used) */
	char	d_name[MAXNAMLEN+1];	/* directory entry name */
};

typedef struct _dirdesc {
	int	dd_fd;			/* fd for open directory */
	long	dd_loc;			/* (not used) */
	long	dd_size;		/* (not used) */
	char	dd_buf[DIRBLKSIZ];	/* buffer for directory entry */
} DIR;

/*
 * Declarations for compatibility with UNIX
 */
#define d_ino    d_addr
#define d_fileno d_addr

#ifndef __GNUC__

extern DIR *opendir(),*unix_opendir();
extern struct direct *readdir();
extern long telldir();
extern /* void */ seekdir(),rewinddir(),closedir();

#else

extern DIR
	*opendir(char *),
	*unix_opendir(char *);

extern struct direct
	*readdir(DIR *);

extern long
	telldir(DIR *);

extern void
	seekdir(DIR *, long),
	rewinddir(DIR *),
	closedir(DIR *);

#endif

/* WN ---
#define opendir(a) unix_opendir(a)
*/

