/*
    WN: A Server for the HTTP
    File: authwn/authwn.c
    Version 1.14.0
    
    Copyright (C) 1996  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifdef DBM_AUTH
#include <dbm.h>
#endif

#include "../config.h"
#include "authwn.h"


extern char	*getenv();

static char	*mystrncpy();

static void	chop(),
		getpath();

static int	checkpw();

int		isdbm = FALSE;

main( argc, argv)
int	argc;
char	*argv[];

{
	register char	*cp;


	char	pwfile[SMALLLEN],
		pwpath[SMALLLEN],
		authdata[MIDLEN + 2*SMALLLEN],
		decoded[MIDLEN];

	int	i;


	i = 1;
	pwfile[0] = '\0';

	while ( argv[i] ) {
		if ( streq( argv[i], "-D")) { 
			i++;
			isdbm = TRUE;
			continue;
		}

		mystrncpy( pwfile, argv[i], SMALLLEN);
		i++;
	}

	if ( !*pwfile) {
		exit( AUTHERR_NUM7);

	}

	getpath( pwpath, pwfile);

	if ( fgets( authdata, SMALLLEN, stdin) == NULL) {
		exit( AUTHERR_NUM10);
	}

	chop( authdata);
	cp = authdata;
	while ( isspace( *cp))
		cp++;
	while ( *cp && !isspace( *cp))
		cp++;
	*cp++ = '\0';

	while ( isspace( *cp))
		cp++;

	strcpy( decoded, cp);

	if ( checkpw( decoded, pwpath) ) {
		exit( AUTH_GRANTED);
	}
	else {
		exit( AUTH_DENIED);
	}
}

static 
checkpw( userinfo, pwpath)
char	*userinfo,
	*pwpath;
{
	register char	*cp,
			*cp2;
	char		*user,
			*pw,
			codedpw[SMALLLEN],
			linebuf[SMALLLEN],
			info[SMALLLEN];
	FILE		*pwfp;

#ifdef DBM_AUTH
	datum		content,
			key;
#endif


	codedpw[0] = '\0';
	strcpy( info, userinfo);

	if ( (cp = strchr( info, ':')) == NULL )
		exit( AUTHERR_NUM3);

	*cp = '\0';
	user = info;
	pw = ++cp;


	if ( !isdbm) {
		if ( ( pwfp = fopen( pwpath, "r")) == (FILE *)NULL)
			exit( AUTHERR_NUM4);

		while ( fgets( linebuf, SMALLLEN, pwfp)) {
			if ( (cp = strchr( linebuf, ':')) == NULL )
				continue;
			*cp++ = '\0';
			if ( streq( linebuf, user)) {
				if ( (cp2 = strchr( cp, ':')) != NULL )
					*cp2 = '\0';
				strcpy( codedpw, cp);
				chop( codedpw);
				break;
			}
		}
	}
	else {
#ifdef DBM_AUTH
		key.dptr = user;
		key.dsize = strlen(user);

		if ( dbminit( pwpath) < 0 ) {
			exit( AUTHERR_NUM5);
		}
		content = fetch( key);
		if ( content.dptr != (char *)NULL) {
			strncpy( codedpw, content.dptr, content.dsize);
			codedpw[content.dsize] = '\0';
		}
		dbmclose( pwpath);
#else
		exit( AUTHERR_NUM8);
#endif
	}

	if ( *codedpw && strcmp( codedpw, (char *) crypt( pw, codedpw)) == 0)
		return TRUE;
	else
		return FALSE;

}



static void
chop( line)
char *line;
{
	register char	*cp;

	if ( *line == '\0')
		return;
	cp = line;
	while ( *cp )
		cp++;
	if ( *--cp == '\n') {
		*cp = '\0';
	}
}


static void
getpath( path, file)
char	*path,
	*file;
{
	char	*cp;

	if ( *file == '/') {
		mystrncpy( path, file, SMALLLEN);
		return;
	}
	if ( *file == '~' && *(file + 1) == '/') {
		strcpy( path, ROOT_DIR);
		strcat( path, ++file);
		return;
	}
	if ( (cp = getenv( "WN_DIR_PATH")) != NULL ) {
		strcpy( path, cp);
		strcat( path, "/");
		strcat( path, file);
		return;
	}
	else {
		mystrncpy( path, file, SMALLLEN);
	}
}



/*
 * mystrncpy( s1, s2, n) is an strncpy() which guarantees a null
 * terminated string in s1.  At most (n-1) chars are copied.
 */

static char *
mystrncpy( s1, s2, n)
char	*s1,
	*s2;
int	n;
{
	register char	*cp1,
			*cp2;
	cp1 = s1;
	cp2 = s2;
	n--;
	while ( *cp2 && (n > 0)) {
		n--;
		*cp1++ = *cp2++;
	}
	*cp1 = '\0';
	return s1;
}
