
#include "comdef.h"
#include "bppacket.h"
#include "handlerr.h"

#define R_Buffer	PDB->Read_Buffer

public BYTE *Handle_Send_Failure(Status, PDB)
/**
 * Function:
 *	Examine response from remote, and if necessary, send error packet
 * 	back.  Return error code to caller.
 *
 * Inputs:
 *	Status - result returned from BP_Read_Packet
 *	PDB - Parameter block for linkage to remote, etc.
 *
 * Outputs:
 *
 * Returns:
 * 	character pointer to message (if any) describing error
 **/
    WORD Status;
    Protocol_Desc_Block *PDB;
    {
    WORD I;
    static BYTE Msg[80];
    WORD PSize;
    BYTE *P;

    PSize = PDB->R_Buffer_Len;

    if (Status == Failure)
    then
	{
	if (PSize == 0)
	then
	    return ("Remote is not responding");

	if (PSize > 0)
	then				    /* have a packet in response */
	    {
	    if (R_Buffer[0] == 'F')
	    then				    /* failure packet */
		{
		if (PSize >= 2)
		then			    /* return reason for failure */
		    {
		    P = Msg;
		    if (PSize > 79)
		    then
			PSize = 79;

		    for (I = 1; I < PSize; I++)
			*P++ = R_Buffer[I];

		    *P = 0;
		    return (Msg);
		    }
		else
		    return ("Empty error packet from remote");
		}
	    else
		{
		BP_Send_Failure('E', "Unexpected packet type", PDB);
		return ("Unexpected packet type");
		}
	    }
	}
    else
	{
	BP_Send_Failure('E', "Protocol out of sequence", PDB);
	return ("Protocol out of sequence");
	}
    }
