/************************************************************************
 *									*
 *  Copyright (c) 1987							*
 *  by CompuServe Incorporated, Columbus, Ohio				*
 *									*
 *  The information in ths software is subject to change without	*
 *  notice and should not be construed as a commitment by CompuServe	*
 *  Incorporated							*
 *									*
 ************************************************************************/

/**
 * File:  BPXPORT.H
 *
 * Facility:  B protocol Transport layer facility
 *
 * Abstract:
 *	'C' header for B protocol transport layer facilit
 *
 * Environment:  None specified
 *
 * Author:  John Pampuch, January 29, 1988
 *
 * Modified by:
 *
 * 1	John Pampuch, January 29, 1988
 *	- Original
 *
 * 2	John Pampuch, February 23, 1988
 * 	- match COMDEF.H requirements
 *
 **/

#ifndef BPXPORT_H
#define BPXPORT_H

#include "comdef.h"
#include "bppacket.h"

/* pointers to linked list of queued packets. */

struct TRpacketStruct
    {
    WORD len;
    struct TRpacketStruct *next;
    BYTE data [1];
    };

typedef struct TRPDBstruct
    {
    /*
     * This part of this structure is the packet level descriptor
     * block.  Generally, the pointer to this entire structureis
     * passed on to BP_Packet, and it uses the stufft needs that
     * that is contained here.
     */
    Protocol_Desc_Block *Packet;

    /*
     * This second part is the session dependent parts of the transport
     * layer.  
     */
    
    BOOL (*Wants_to_Abort) (void);	/* must return True if user has */
					/* requested an abort */

    struct TRpacketStruct *First_Packet;
    struct TRpacketStruct *Next_Packet;
    unsigned Msg_Count;
    }
TR_PDB;

/* the public routines provided as part of the transport layer. */

public WORD BP_Transport_Init (TR_PDB *);
public void BP_Transport_Close (TR_PDB *);
public UWORD BP_Send_Data (BYTE *, UWORD, TR_PDB *);
public WORD BP_Msgs_Available (TR_PDB *);
public WORD BP_Msg_Size (TR_PDB *);
public WORD BP_Read_Data (BYTE *, WORD, TR_PDB *);

#endif
