/*  Copyright (C) 1996 N.M. Maclaren
    Copyright (C) 1996 The University of Cambridge

This includes code that really should have been part of ANSI/ISO C, but was
left out for historical reasons (despite requests to define ftty), plus
the get_lock() function. */

/* OS-9: added for prototypes */
#define _OPT_PROTOS
/* OS-9: added */
#include <unix/os9def.h>	/* for isatty() */
#include <stdio.h>			/* for fileno() */
#include <process.h>		/* for getpid() */
#define STDOUT_FILENO 1
#define STDIN_FILENO 0
int fileno(FILE *stream);
#define fileno(s) _fileno(s)

#include "header.h"

#include <sys/types.h>
/* OS-9: #include <unistd.h> */

#include <signal.h>

#define UNIX
#include "kludges.h"
#undef UNIX

#ifndef LOCKFILE
    #define LOCKFILE "/etc/msntp.pid"          /* Stores the pid */
#endif



void do_nothing (int seconds) {

/* Wait for a fixed period, possibly uninterruptibly.  This should not wait
for less than the specified period, if that can be avoided. */

    sleep(seconds+3);          /* +2 is enough for POSIX */
}



int ftty (FILE *file) {

/* Return whether the file is attached to an interactive device. */

    return isatty(fileno(file));
}



void set_lock (int lock) {

/* Check that we have enough privileges to reset the time and that no other
updating msntp process is running, but don't bother with fancy interlocking.
This function is really only to permit the daemon mode to be restarted in a
cron job and improve the diagnostics; it can be replaced by a 'return'
statement if it causes implementation difficulties.  Note that there is little
point in clearing the lock under Unix, but do so anyway. */

    FILE *file;
    long pid;

/* OS-9:	if (LOCKFILE == NULL) return; */
	if (LOCKFILE == NULL) {
		return;
	} else

    if (lock) {
        errno = 0;
        if ((file = fopen(LOCKFILE,"r")) != NULL &&
                fscanf(file,"%ld",&pid) == 1 && kill(pid,0) == 0) {
            if (verbose || isatty(STDIN_FILENO) || isatty(STDOUT_FILENO))
                fatal(0,"another msntp process is currently running",NULL);
            else
                fatal(0,NULL,NULL);
        }
        if (file != NULL) fclose(file);
        errno = 0;
        if ((file = fopen(LOCKFILE,"w")) == NULL ||
                fprintf(file,"%ld\n",(long)getpid()) <= 0 ||
                ferror(file) || fclose(file) != 0)
            fatal(1,"unable to write PID to %s",LOCKFILE);
        adjust_time(0.0,0,0.0);
    } else {
        errno = 0;
        if (remove(LOCKFILE) != 0)
            fatal(1,"unable to remove the msntp lockfile %s",LOCKFILE);
    }
}       
