/* ====================================================================
 * Copyright (c) 1998-1999 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

#ifndef APACHE_OS_H
#define APACHE_OS_H

/* #define _OPT_PROTOS */

#include "ap_config.h"

#ifndef PLATFORM
#define PLATFORM "OS-9"
#endif

#include <unix/stat.h>
#include <os9def.h>
#ifndef S_ISDIR
#define S_ISDIR(m)      ((m)&(S_IFDIR))
#endif
#ifndef S_ISREG
#define S_ISREG(m)      !((m)&(S_IFDIR))
#endif
#ifndef S_ISLNK
#define S_ISLNK(m)      (0)
#endif
#define S_ISUID			0
#define S_ISGID			0

/* User */
#ifndef S_IRUSR
#define S_IRUSR S_IREAD
#endif
#ifndef S_IWUSR
#define S_IWUSR S_IWRITE
#endif
#ifndef S_IXUSR
#define S_IXUSR S_IEXEC
#endif
/* Group */
#ifdef _OS9000
#ifndef S_IRGRP
#define S_IRGRP S_IGREAD
#endif
#ifndef S_IWGRP
#define S_IWGRP	S_IGWRITE
#endif
#ifndef S_IXGRP
#define S_IXGRP S_IGEXEC
#endif
#else
#ifndef S_IRGRP
#define S_IRGRP S_IOREAD
#endif
#ifndef S_IWGRP
#define S_IWGRP	S_IOWRITE
#endif
#ifndef S_IXGRP
#define S_IXGRP S_IOEXEC
#endif
#endif
/* Other */
#ifndef S_IROTH
#define S_IROTH S_IOREAD
#endif
#ifndef S_IWOTH
#define S_IWOTH S_IOWRITE
#endif
#ifndef S_IXOTH
#define S_IXOTH S_IOEXEC
#endif

#ifndef O_RDONLY
#define	O_RDONLY		S_IREAD		/* open for read access */
#define	O_WRONLY		S_IWRITE	/* open for write access */
#define	O_RDWR			S_IREAD|S_IWRITE	/* open for update access */
#endif
#ifndef O_CREAT
#define	O_CREAT			S_ICREAT	/* create file */
#endif
#ifndef O_APPEND
#define	O_APPEND		S_IAPPEND	/* force writes to eof (append) */
#endif

#define lstat(x, y) stat(x, y)
#define crypt(buf,salt) ((char *)buf)
typedef unsigned long off_t;
typedef unsigned short uid_t;
typedef unsigned short gid_t;
typedef int mode_t;
#define HZ CLOCKS_PER_SEC

#define WIFSIGNALED(w) (w)
#define WIFEXITED(w) (w)
#define WEXITSTATUS(status)     (int)( WIFEXITED(status) ? (status) : -1)
#define WTERMSIG(status)	(int)(status)

/*
 * This file in included in all Apache source code. It contains definitions
 * of facilities available on _this_ operating system (HAVE_* macros),
 * and prototypes of OS specific functions defined in os.c or os-inline.c
 */

/* Compiler does not support inline, so prototype the inlineable functions
 * as normal
 */
extern int ap_os_is_path_absolute(const char *file);

/* Other ap_os_ routines not used by this platform */

#define ap_os_is_filename_valid(f)          (1)
#define ap_os_kill(pid, sig)                kill(pid, sig)

/*
 *  Abstraction layer for loading
 *  Apache modules under run-time via 
 *  dynamic shared object (DSO) mechanism
 */

#ifdef HAVE_DL_H
#include <dl.h>
#endif

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#else
void *dlopen(const char *, int);
int dlclose(void *);
void *dlsym(void *, const char *);
const char *dlerror(void);
#endif

#define     ap_os_dso_handle_t  void *
void        ap_os_dso_init(void);
void *      ap_os_dso_load(const char *);
void        ap_os_dso_unload(void *);
void *      ap_os_dso_sym(void *, const char *);
const char *ap_os_dso_error(void);

#endif	/* !APACHE_OS_H */
