/*
 * This file will include OS specific functions which are not inlineable.
 * Any inlineable functions should be defined in os-inline.c instead.
 */

#include "ap_config.h"
#include "os.h"


/* some linkers complain unless there's at least one function in each
 * .o file... and extra prototype is for gcc -Wmissing-prototypes
 */
extern void ap_is_not_here(void);
void ap_is_not_here(void) {}

/*
 *  Abstraction layer for loading
 *  Apache modules under run-time via 
 *  dynamic shared object (DSO) mechanism
 */

void ap_os_dso_init(void)
{
	fprintf(stderr,"ap_os_dso_init() not supported in OS-9\n");	
    return;
}

void *ap_os_dso_load(const char *path)
{
	fprintf(stderr,"ap_os_dso_load(%s) not supported in OS-9\n",path);	
	return 0;
}

void ap_os_dso_unload(void *handle)
{
	fprintf(stderr,"ap_os_dso_unload(...) not supported in OS-9\n");	
    return;
}

void *ap_os_dso_sym(void *handle, const char *symname)
{
	fprintf(stderr,"ap_os_dso_sym(...,%s) not supported in OS-9\n",symname);	
	return 0;
}

const char dso_err[] = "Not Supported\n";
const char *ap_os_dso_error(void)
{
	fprintf(stderr,"ap_os_dso_error() not supported in OS-9\n");	
	return dso_err;
}
