/* Exec* functions. These are special Versions, which are starting the process
 * and return the Process ID
 * KeiT 03.02.00
 */

#define _OPT_PROTOS
#include <stdio.h>
#include <module.h>
#include <stdlib.h>
#include <cglob.h>
#include <process.h>

extern int os9forkc(const char*,int,const char*,short,short,int,short,short);
extern int os9fork(const char*,int,const char*,short,short,int,short);

extern int errno;

int execl (char *path, char *arg0, char *argn)
{
        register long *argp;
        register char **argv;
        register int nargs;

        argp = (long *) &argn;
        nargs = 1;
        while (*argp) {
                nargs++; argp++;
        }

        modload(path,0);        /* load module (use 'path') */

        if ((argv = (char **) malloc(sizeof(char *) * (nargs+1))) == (char **) NULL)
                exit(errno);

        argv[0] = arg0;
        argp = (long *) &argn;
        nargs = 1;
        while (*argp)
                argv[nargs++] = (char *) *argp++;

        argv[nargs] = (char *) NULL;

        return(os9exec((int (*)())os9forkc,arg0,argv,_environ,0,0,3));
}

int execle (char *path, char *arg0, char *argn)
{
        long    *argp;
        char    **argv;
        int     nargs;
        char    **env;
        
        argp = (long *) &argn;
        nargs = 1;
        while (*argp) {
                nargs++; argp++;
        }

        modload(path,0);        /* load module (use 'path') */

        if ((argv = (char **) malloc(sizeof(char *) * (nargs+1))) == (char **) NULL)
                exit(errno);

        argv[0] = arg0;
        argp = (long *) &argn;
        nargs = 1;
        while (*argp)
                argv[nargs++] = (char *) *argp++;

        argv[nargs] = (char *) NULL;
        env = (char **)*(++argp);

        return(os9exec((int (*)())os9forkc,arg0,argv,env,0,0,3));
}

int execvp(char *prog, char **argv)
{
                /* os9exec always searches PATH */
        return os9exec((int (*)())os9forkc, prog, argv, _environ, 0, 0, 3 );
}

int execlp(char *path, char *arg0, char *argn)
{
        register long *argp;
        register char **argv;
        register int nargs;

        argp = (long *) &argn;
        nargs = 1;
        while (*argp) {
                nargs++; argp++;
        }

        modload(path,0);        /* load module (use 'path') */

        if ((argv = (char **) malloc(sizeof(char *) * (nargs+1))) == (char **) NULL)
                exit(errno);

        argv[0] = arg0;
        argp = (long *) &argn;
        nargs = 1;
        while (*argp)
                argv[nargs++] = (char *) *argp++;

        argv[nargs] = (char *) NULL;

        return(os9exec((int (*)())os9forkc,arg0,argv,_environ,0,0,3));
}

int execve( char *prog, char **argv, char **env)
{
                /* os9exec always searches PATH */
        return os9exec((int (*)())os9forkc, prog, argv, env, 0, 0, 3 );
}

int execv(char *prog, char **argv)
{
    return os9exec((int (*)())os9forkc, prog, argv, _environ, 0, 0, 3);
}

int execl_chain (char *path, char *arg0, char *argn)
{
        register long *argp;
        register char **argv;
        register int nargs;

        argp = (long *) &argn;
        nargs = 1;
        while (*argp) {
                nargs++; argp++;
        }

        modload(path,0);        /* load module (use 'path') */

        if ((argv = (char **) malloc(sizeof(char *) * (nargs+1))) == (char **) NULL)
                exit(errno);

        argv[0] = arg0;
        argp = (long *) &argn;
        nargs = 1;
        while (*argp)
                argv[nargs++] = (char *) *argp++;

        argv[nargs] = (char *) NULL;

        if (!os9exec((int (*)())chainc,arg0,argv,_environ,0,0,3))
                exit(0);

        return -1;
}

int execle_chain (char *path, char *arg0, char *argn)
{
        long    *argp;
        char    **argv;
        int     nargs;
        char    **env;
        
        argp = (long *) &argn;
        nargs = 1;
        while (*argp) {
                nargs++; argp++;
        }

        modload(path,0);        /* load module (use 'path') */

        if ((argv = (char **) malloc(sizeof(char *) * (nargs+1))) == (char **) NULL)
                exit(errno);

        argv[0] = arg0;
        argp = (long *) &argn;
        nargs = 1;
        while (*argp)
                argv[nargs++] = (char *) *argp++;

        argv[nargs] = (char *) NULL;
        env = (char **)*(++argp);

        return(os9exec((int (*)())chainc,arg0,argv,env,0,0,3));
}

int execvp_chain(char *prog, char **argv)
{
                /* os9exec always searches PATH */
        return os9exec((int (*)())chainc, prog, argv, _environ, 0, 0, 3 );
}


int execve_chain( char *prog, char **argv, char **env)
{
                /* os9exec always searches PATH */
        return os9exec((int (*)())chainc, prog, argv, env, 0, 0, 3 );
}

int execv_chain(char *prog, char **argv)
{
    return os9exec((int (*)())chainc, prog, argv, _environ, 0, 0, 3);
}

	

