/*       This software is copyright (C) 1989 by Reimer Mellin        *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this package by any means so long as no fee is charged      *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*        Commerical use or incorporation into commercial software    *
*        is prohibited without the written permission of the         *
*        author.                                                     *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Reimer Mellin                                       *
*                                                                    *
*                Sulenstr.8                                          *
*                D-8000 Muenchen 71 (Federal Republic of Germany)    *
*                                                                    *
*           EMAIL:                                                   *
*                mellin@lan.informatik.tu-muenchen.dbp.de            *
*                ram@altger.UUCP                                     *
*                ram%ramsys@chiuur.sub.org (home)                    *
*                                                                    */
/*  */

/*
 * $Id: ptyman.h_v 1.3 91/06/08 01:22:56 ram Exp $
 *
 * $Log:	ptyman.h_v $
 * Revision 1.3  91/06/08  01:22:56  ram
 * Added SS_IOCONT & SS_IOSTOP, various bugfixes, ftp-release on smilodon,
 * please share and distribute !!
 * 
 * Revision 1.2.1.1  89/09/04  13:14:51  ram
 * added some comments
 * 
 * Revision 1.2  89/08/31  12:35:20  ram
 * *** empty log message ***
 * 
 *
 */

#ifndef _sysio
#include <sysio.h>
#endif

/*
 * PtyFilemanager PD definitions
 */

typedef struct ptystatic {
  sysioStatic   v_sysio;            /* kernel static storage variables */
} *Ptystatic;

struct ptybuf {
        union pathdesc *lpd;            /* pd of last active process */
        u_char         *buf;            /* buffer */
        u_char         *wptr;           /* write-ptr of buffer */
        u_char         *rptr;           /* read-ptr of buffer */
        u_long          size;           /* buffer-size */
        u_long          flags;          /* Flags ... */
        u_short         rpid;           /* pid to wake if read is pending */
        u_short         rsig;           /* signal to send */
        u_short         wpid;           /* pid to wake if write is pending */
        u_short         wsig;           /* signal to send */
};

struct pty_pvt {
        union pathdesc *pty ;        /* the server-pty .. */
        union pathdesc *tty ;        /* the tty-list */
        struct ptybuf   rbuf;        /* input-buffer */
        struct ptybuf   wbuf;        /* output-buffer */
        u_long          flags;       /* Flags ... */
        u_short         onsig;       /* for SS_DCOn */
        u_short         offsig;      /* for SS_DCOff */
        u_short         line;        /* for page-pause */
        u_char          typ;         /* pty or tty ? */
};

struct pty_opt {
	u_char		pd_dtp;			/* device type */
	u_char		pd_upc;			/* case (0=both, 1=upper only) */
	u_char		pd_bso;			/* backsp (0=bse, 1=bse,sp,bse) */
	u_char		pd_dlo;			/* delete (0=bse over line, 1=crlf) */
	u_char		pd_eko;			/* echo (0=no echo) */
	u_char		pd_alf;			/* autolf (0=no auto lf) */
	u_char		pd_nul;			/* end of line null count */
	u_char		pd_pau;			/* pause (0=no end of page pause) */
	u_char		pd_pag;			/* lines per page */
	u_char		pd_bsp;			/* backspace character */
	u_char		pd_del;			/* delete line character */
	u_char		pd_eor;			/* end of record char (read only) */
	u_char		pd_eof;			/* end of file char */
	u_char		pd_rpr;			/* reprint line char */
	u_char		pd_dup;			/* dup last line char */
	u_char		pd_psc;			/* pause char */
	u_char		pd_int;			/* kbd intr char (ctl c) */
	u_char		pd_qut;			/* kbd quit char (ctl q) */
	u_char		pd_bse;			/* backspace echo character */
	u_char		pd_ovf;			/* line overflow char (bell) */
	u_char		pd_par;			/* parity code */
	u_char		pd_bau;			/* acia baud rate (color computer) */
	short		pd_d2p;			/* dev2 output name offset */
	u_char		pd_xon;			/* x-on char */
	u_char		pd_xoff;		/* x-off char */
	u_char		pd_Tab;			/* Tab character (0=none) */
	u_char		pd_Tabs;		/* Tab field size */
	Devicetbl	pd_tbl;			/* Device table addr (copy) */
	u_short		pd_Col;			/* current column number */
	u_char		pd_err;			/* most recent I/O error status */
        u_char          dummy[96-35];           /* reserved ... */
        u_char          pd_name[28];            /* the name of the PTY */
        u_long          pd_namlen;              /* length of name */
};

#define PTYMAN	1
#define	ptypvt	path.fm_pvt.pty
#define ptyopt	path.fm_opt.pty


extern u_char  *_srqmem();
extern void     _srtmem();
extern void     iowait();
extern void     kill();
extern void     initbuf();
extern int      getctrlchar();

extern int      tsleep();
extern int      _prsnam();
extern int      strcmp();
extern void     memcpy();

extern int      dosleep();
extern int      hangup();
extern int      cpinraw();
extern int      cpin();
extern int      cpoutraw();
extern int      cpout();



