/*       This software is copyright (C) 1989 by Reimer Mellin        *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this package by any means so long as no fee is charged      *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*        Commerical use or incorporation into commercial software    *
*        is prohibited without the written permission of the         *
*        author.                                                     *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Reimer Mellin                                       *
*                                                                    *
*                Sulenstr.8                                          *
*                D-8000 Muenchen 71 (Federal Republic of Germany)    *
*                                                                    *
*           EMAIL:                                                   *
*                mellin@lan.informatik.tu-muenchen.dbp.de            *
*                ram@altger.UUCP                                     *
*                ram%ramsys@chiuur.sub.org (home)                    *
*                                                                    */

/*  */

/*
 * HauptModul des PtyManagers -- Einsprung-Routinen vom Assembler-Interface
 *
 * $Header: /h0/USR/REIMER/PTYMAN/RCS/ptyman.c_v 1.3 91/06/08 01:19:40 ram Exp $
 *
 * $Log:	ptyman.c_v $
 * Revision 1.3  91/06/08  01:19:40  ram
 * Added SS_IOCONT & SS_IOSTOP, various bugfixes, ftp-release on smilodon,
 * please share and distribute !!
 * 
 * Revision 1.2.1.2  89/09/04  13:14:23  ram
 * added some comments
 * 
 * Revision 1.2.1.1  89/08/31  12:26:06  ram
 * Copyright-message added
 * 
 * Revision 1.2  89/07/16  01:06:12  ram
 * minor changes to Sub-net Release
 * 
 * Revision 1.1.1.1  89/07/14  19:49:56  ram
 * Fixed: SS_SSig Bug. Sub-Net Beta-Release
 * 
 * Revision 1.1  89/07/13  23:22:15  ram
 * Initial revision
 * 
 */

#include <types.h>
#include <MACHINE/reg.h>
#include "Ptyman.h"
/*#include <path.h>*/
#include "path.h"
#include <sg_codes.h>
#include <procid.h>
#include <modes.h>
#include <sgstat.h>
#include <setsys.h>
#include <signal.h>
#include <errno.h>

#ifdef ST
#include <stconfuncs.h>
#endif

#ifdef SOMEPLUS
#define DUMMY 16
#else
#define DUMMY 0
#endif

#include "misc.h"

union pathdesc pd;      /* a6 points to the Path-Descriptor !!! */

/*
 * O P E N
 */
Open(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    register    u_char  *name = (u_char *) ustack->a[0];
    register    int      namcnt,i;
    register    Pathdesc ptr;
	
    if( ( namcnt = _prsnam(name)) < 0)
        return -1;

    pd.ptypvt.typ = (name[1] == 'P' || name[1] == 'p') ? PTY : TTY;

    if( (pd.path.pd_mod & (u_char) ustack->d[0]) != (u_char) ustack->d[0]) {
        errno = E_BMODE;
        return -1;
    }

    pd.path.pd_mod = (u_char) ustack->d[0];
    if( pd.ptypvt.typ == TTY || !(pd.path.pd_mod & S_IFDIR)) {
      if( name[namcnt] != '/') {
        errno = E_BPNAM;
        return -1;
      }

      name += namcnt+1;

      if( ( namcnt = _prsnam(name)) < 0 || namcnt > 28
         || name[namcnt] != '\0') {
        errno = E_BPNAM;
        return -1;
      }
    }

    for(i=0; i < namcnt;i++)
        pd.ptyopt.pd_name[i] = upchar(name[i]);

    pd.ptyopt.pd_name[namcnt-1] |= 0x80;
    
    pd.ptyopt.pd_namlen = namcnt;

    /* normal ptys have buffers and so on, dir-ptys don't ! */
    if( !(pd.path.pd_mod & S_IFDIR)) {
      if( pd.ptypvt.typ != PTY) {
          /* tty */
          /* look for correspondent pty in path-list and then look its
           * tty-list for already openend NON-SHAREABLE ttys ...
           */

          /*
           * The start of all open paths on this device
           * maintained by the kernel (IOMan)
           */
          ptr = ((Ptystatic) pd.path.pd_dev->V_stat)->v_sysio.v_paths;
          for(; ptr ; ptr = ptr->path.pd_paths)
              if( ptr->ptypvt.typ == PTY
               && strcmp( ptr->ptyopt.pd_name, pd.ptyopt.pd_name) == 0 ) {
                  pd.ptypvt.pty = ptr;

                  /*
                   * look through the connected tty-list of the pty
                   */
                  for( ptr = ptr->ptypvt.tty; ptr ; ptr = ptr->ptypvt.tty)
                    if( S_ISHARE & (pd.path.pd_mod | ptr->path.pd_mod) ) {
                      errno = E_SHARE;
                      return -1;
                    }
                  /*
                   * Ok: we found a pty with no NON-SHAREABLES ttys
                   */
                  pd.ptypvt.tty = pd.ptypvt.pty->ptypvt.tty;
                  pd.ptypvt.pty->ptypvt.tty = &pd;
                  /*
                   * send the pty on onsig, if requested
                   */
                  if( pd.ptypvt.pty->ptypvt.onsig != 0 )
                      kill((ptr->path.pd_cpr ?
                              ptr->path.pd_cpr : ptr->path.pd_lproc)
                           ,pd.ptypvt.pty->ptypvt.onsig);
                  return 0;
              }
          /*
           * not found ... linger around and wait until connected by the pty
           * any real i/o will isuue an error
           */
          return 0;
      } else {
          /* pty */
          /* if same name exists, exists with error */

          /*
           * The start of all open paths on this device
           * maintained by the kernel (IOMan)
           */
          ptr = ((Ptystatic) pd.path.pd_dev->V_stat)->v_sysio.v_paths;
          for(; ptr ; ptr = ptr->path.pd_paths)
              if( ptr->ptypvt.typ == PTY && ptr != &pd
               && strcmp( ptr->ptyopt.pd_name, pd.ptyopt.pd_name) == 0 ) {
                  errno = E_SHARE;
                  return -1;
              }
          /*
           * Ok: we are the only pty with our name
           * set buffersize and allocate them; if NOMEM exit with error
           */
          pd.ptypvt.rbuf.size = pd.ptypvt.wbuf.size = DEFBUFSIZE;
          if((pd.ptypvt.rbuf.buf =
                    (u_char *)_srqmem( (pd.ptypvt.rbuf.size + DUMMY))) == (u_char *)0 ||
             (pd.ptypvt.wbuf.buf =
                    (u_char *)_srqmem( (pd.ptypvt.wbuf.size + DUMMY))) == (u_char *)0) {
              if( pd.ptypvt.wbuf.buf )
                  (void) _srtmem(pd.ptypvt.wbuf.buf,pd.ptypvt.wbuf.size + DUMMY);
              if( pd.ptypvt.rbuf.buf )
                  (void) _srtmem(pd.ptypvt.rbuf.buf,pd.ptypvt.rbuf.size + DUMMY);
              return -1;
          }

          pd.ptypvt.rbuf.rptr = pd.ptypvt.rbuf.wptr = pd.ptypvt.rbuf.buf;
          pd.ptypvt.wbuf.rptr = pd.ptypvt.wbuf.wptr = pd.ptypvt.wbuf.buf;

          /*
           * The start of all open paths on this device
           * maintained by the kernel (IOMan)
           */
          ptr = ((Ptystatic) pd.path.pd_dev->V_stat)->v_sysio.v_paths;
          /* look for all lingering ttys and connect them */
          for(; ptr ; ptr = ptr->path.pd_paths)
              if( ptr->ptypvt.typ == TTY
               && strcmp( ptr->ptyopt.pd_name, pd.ptyopt.pd_name) == 0 ) {
                  ptr->ptypvt.pty = &pd;
                  ptr->ptypvt.tty = pd.ptypvt.tty;
                  pd.ptypvt.tty = ptr;
                  /*
                   * if they had wished on DCON-sig, give them what they want
                   */
                  if( ptr->ptypvt.onsig != 0 )
                      kill( (ptr->path.pd_cpr ?
                             ptr->path.pd_cpr : ptr->path.pd_lproc)
                           , ptr->ptypvt.onsig);
              }
      }
    } else {
      /*
       * dir-ptys have a list of ptys to output :-)
       * misuse the tty-list for that
       */
      pd.ptypvt.tty = ((Ptystatic) pd.path.pd_dev->V_stat)->v_sysio.v_paths;
    }
    return 0;
}

/*
 * C l o s e
 */
Close(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    register    struct ptybuf *bptr;

    if( !(pd.path.pd_mod & S_IFDIR)) {
      /*
       * non-dir-ptys have some cleanup to do
       */

      /* clear _ss_sign() */
      bptr = ( pd.ptypvt.typ == PTY || pd.ptypvt.pty == 0) ?
          &pd.ptypvt.rbuf :
          &((pd.ptypvt.pty)->ptypvt.wbuf);
      if( bptr->rpid == procdesc->_id )
          bptr->rpid = 0;

      /* deallocate buffer if we are the last incarnation on this pd */
      if( pd.path.pd_count == 0 )
          if( pd.ptypvt.typ == PTY ) {
              register Pathdesc ptr;
      /*
       * and send all listening ttys a HUP and mark that the connection
       * is severed
       */
              for(ptr = pd.ptypvt.tty; ptr ; ptr = ptr->ptypvt.tty) {
                      ptr->ptypvt.pty = (union pathdesc *) 0;
                      kill( (ptr->path.pd_cpr ?
                             ptr->path.pd_cpr : ptr->path.pd_lproc)
                           ,(ptr->ptypvt.offsig ? ptr->ptypvt.offsig : SIGHUP));
              }
              (void) _srtmem( pd.ptypvt.rbuf.buf, pd.ptypvt.rbuf.size + DUMMY);
              (void) _srtmem( pd.ptypvt.wbuf.buf, pd.ptypvt.wbuf.size + DUMMY);
          } else {
              if( pd.ptypvt.pty != 0 ) {
                register Pathdesc ptr;

              /*
               * tty: ok remove us from the connected-tty-list in the pty
               * data-structure
               */
                for(ptr = pd.ptypvt.pty; ptr ; ptr = ptr->ptypvt.tty)
                  if( ptr->ptypvt.tty == &pd )
                    ptr->ptypvt.tty = pd.ptypvt.tty;

              /*
               * cancel all references to us ... (for echo or whatever)
               * and send the pty an sighup if requested
               */
                if( (pd.ptypvt.pty)->ptypvt.rbuf.lpd == &pd)
                  (pd.ptypvt.pty)->ptypvt.rbuf.lpd = NULL;
                if( (pd.ptypvt.pty)->ptypvt.tty == NULL
                  && (pd.ptypvt.pty)->ptypvt.offsig != 0)
                  kill( ((pd.ptypvt.pty)->path.pd_cpr ?
                         (pd.ptypvt.pty)->path.pd_cpr :
                         (pd.ptypvt.pty)->path.pd_lproc)
                       ,(pd.ptypvt.pty)->ptypvt.offsig);
              }
              /*
               * if we had a line-editing-buffer .. free it
               */
              if( pd.path.pd_buf )
                  (void) _srtmem( pd.path.pd_buf, LINEBUFSIZ);
          }
    } else {
      pd.ptypvt.tty = 0;
    }
    return(0);
}

IoRet ( bytes , ustack )
int         bytes;
REGISTERS   *ustack;
{
    if( bytes < 0) {
        ustack->d[1] += bytes;
        return -1;
    }
    ustack->d[1] -= bytes;
    return(0);
}

ReadDir( ustack )
  REGISTERS *ustack;
{
  register int      i;
  
  while( pd.ptypvt.tty && ( pd.ptypvt.tty == &pd
                        || (pd.ptypvt.tty)->ptypvt.typ != pd.ptypvt.typ))
    pd.ptypvt.tty = (pd.ptypvt.tty)->path.pd_paths;
  if( pd.ptypvt.tty ) {
    i = MIN( 32, ustack->d[1] );
    memcpy( ustack->a[0], (pd.ptypvt.tty)->ptyopt.pd_name, i);
    ustack->d[1] = i;
  } else {
    errno = E_EOF;
    return -1;
  }
  pd.ptypvt.tty = (pd.ptypvt.tty)->path.pd_paths;
  return 0;
}

Read(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{

    if( (pd.path.pd_mod & S_IFDIR)) {
      return(ReadDir( ustack ));
    }

    /*
     * return error if no connection established
     */
    if( hangup(procdesc) )
        return -1;

    /*
     * select buffer ...
     */
    if( pd.ptypvt.typ == PTY ) {
        return( IoRet( (cpinraw( &pd.ptypvt.rbuf, &pd.ptypvt.wbuf,
            ustack, procdesc)), ustack ));
    } else {
        return( IoRet( (cpinraw( &((pd.ptypvt.pty)->ptypvt.wbuf),
            &((pd.ptypvt.pty)->ptypvt.rbuf), ustack, procdesc)), ustack));
    }
}

ReadLn(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    if( (pd.path.pd_mod & S_IFDIR)) {
      return(ReadDir( ustack ));
    }

    if( hangup(procdesc) )
        return -1;
    /*
     * the line-editing buffer
     */
    if( pd.path.pd_buf == NULL) {
        if((pd.path.pd_buf = (u_char *) _srqmem(LINEBUFSIZ)) == NULL)
            return(-1);
        else
            initbuf(pd.path.pd_buf, LINEBUFSIZ-1);  /* dont change !! */
    }

    if( ustack->d[1] > LINEBUFSIZ )
        ustack->d[1] = LINEBUFSIZ;

    /*
     * select buffer ...
     */
    if( pd.ptypvt.typ == PTY ) {
        return( IoRet( (cpin( &pd.ptypvt.rbuf, &pd.ptypvt.wbuf,
                              ustack, procdesc))
                       , ustack ));
    } else {
        return( IoRet( (cpin( &((pd.ptypvt.pty)->ptypvt.wbuf),
                              &((pd.ptypvt.pty)->ptypvt.rbuf),
                              ustack, procdesc))
                       , ustack ));
    }
}

Write(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    if( (pd.path.pd_mod & S_IFDIR)) {
      errno = E_BMODE;
      return -1;
    }

    if( hangup(procdesc) )
        return -1;

    if( pd.ptypvt.typ == PTY ) {
        return( IoRet( (cpoutraw( &pd.ptypvt.wbuf, &pd.ptypvt.rbuf,
                                  ustack, procdesc))
                       , ustack ));
    } else {
        return( IoRet( (cpoutraw( &((pd.ptypvt.pty)->ptypvt.rbuf),
                                  &((pd.ptypvt.pty)->ptypvt.wbuf),
                                  ustack, procdesc))
                       , ustack ));
    }
}

WriteLn(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    if( (pd.path.pd_mod & S_IFDIR)) {
      errno = E_BMODE;
      return -1;
    }

    if( hangup(procdesc) )
        return -1;

    if( pd.ptypvt.typ == PTY ) {
        return( IoRet( (cpout( &pd.ptypvt.wbuf, &pd.ptypvt.rbuf, 
                               ustack, procdesc))
                       , ustack ));
    } else {
        return( IoRet( (cpout( &((pd.ptypvt.pty)->ptypvt.rbuf), 
                               &((pd.ptypvt.pty)->ptypvt.wbuf),
                               ustack, procdesc))
                       , ustack));
    }
}


/*
 * G e t S t a t
 */
GetStat(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    register struct ptybuf  *ptr;
    
    switch (ustack->d[1] & 0x0ffff) {

        case SS_DevNm:
            /*
             * returns name of the [pt]ty ...
             */
            memcpy( ustack->a[0], "tty/", 4);

            if( pd.ptypvt.typ == PTY)
                    *((u_char *)ustack->a[0]) = 'p';
            memcpy( ((u_char *)ustack->a[0]) + 4, pd.ptyopt.pd_name,
                    pd.ptyopt.pd_namlen);
            *((u_char *) ustack->a[0] + pd.ptyopt.pd_namlen + 4) = '\0';
#ifdef LEV
/*
We must emulate a SCF device, so the high bit in
last character must be stripped (debug required this
hack)
*/
            *((u_char *) ustack->a[0] + pd.ptyopt.pd_namlen + 3) &= 0x7F;
#endif
            break;

        case SS_Opt:
            /*
             * copy the option-field
             */
            memcpy( ustack->a[0], &(pd.ptyopt.pd_dtp), OPTMAX);
            break;

        case SS_Size:
            /*
             * buffer size lesen ?!
             */
            ustack->d[2] = pd.path.pd_mod & S_IFDIR ? 32 : DEFBUFSIZE ;
            break;

        default:
            if( hangup(procdesc) )
                return -1;
            switch (ustack->d[1] & 0x0ffff) {

                case SS_Ready:
                    /*
                     * return TRUE if number of chars in buffer > 0 ...
                     */
                    ptr = ( pd.ptypvt.typ == PTY) ? &pd.ptypvt.rbuf :
                         &((pd.ptypvt.pty)->ptypvt.wbuf);
                    if( (ptr->flags & STOPPED)
                      || (ustack->d[1] = (ptr->wptr - ptr->rptr)) <= 0 ) {
                        errno = E_NOTRDY;
                        return -1;
                    }
                    break;

                case SS_EOF:
                    /*
                     * always return 0
                     */
                    ustack->d[1] = 0;
                    break;

                case SS_BlkRd:
                    /*
                     * like a Read
                     */
                    ustack->d[1] = ustack->d[2];
                    return( Read( procdesc, ustack));

                default:        
                    errno = E_UNKSVC;
                    return(-1);
            }
    }
    return (0);
}


/*
 * S e t S t a t
 */
SetStat(procdesc, ustack)
  procid    *procdesc;
  REGISTERS *ustack;
{
    register struct ptybuf  *ptr;

    switch (ustack->d[1] & 0x0ffff) {

        case SS_EnRTS:
        case SS_DCOn:
            /*
             * set the pd_onsig -- thats all
             */
            pd.ptypvt.onsig = (u_short) ustack->d[2];
            break;
            
        case SS_DsRTS:
        case SS_DCOff:
            /*
             * set the pd_offsig -- thats all
             */
            pd.ptypvt.offsig = (u_short) ustack->d[2];
            break;

        case SS_Opt:
            /*
             * copy the option-field
             */
            memcpy( &(pd.ptyopt.pd_dtp), ustack->a[0], OPTMAX);
            break;

        default:
            if( hangup(procdesc) )
                return -1;
            switch (ustack->d[1] & 0x0ffff) {
                register    union pathdesc *sp;

                case SS_IOSTOP:
                    sp = ( pd.ptypvt.typ == PTY) ?
                              &pd :
                               pd.ptypvt.pty;
                    sp->ptypvt.rbuf.flags |= IOSTOP;
                    sp->ptypvt.wbuf.flags |= IOSTOP;
                    break;

                case SS_IOCONT:
                    sp = ( pd.ptypvt.typ == PTY) ?
                              &pd :
                               pd.ptypvt.pty;
                    sp->ptypvt.rbuf.flags &= ~IOSTOP;
                    WAKE( sp->ptypvt.rbuf.rpid, sp->ptypvt.rbuf.rsig );
                    sp->ptypvt.wbuf.flags &= ~IOSTOP;
                    WAKE( sp->ptypvt.wbuf.rpid, sp->ptypvt.wbuf.rsig );
                    break;

                case SS_SSig:
                    /*
                     * set ssig, if someother is already waiting --> error
                     * if data is already available --> send sig immediatly
                     */
                    ptr = ( pd.ptypvt.typ == PTY) ?
                              &pd.ptypvt.rbuf :
                              &((pd.ptypvt.pty)->ptypvt.wbuf);
                    if( ptr->rpid || (ptr->flags & STOPPED)) {
                        errno = E_NOTRDY;
                        return -1;
                    }
                    if( ((ptr->wptr - ptr->rptr)) <= 0 ) {
                        ptr->rpid = procdesc->_id;
                        ptr->rsig = ustack->d[2];
                    } else kill(procdesc->_id,ustack->d[2]);
                    break;

                case SS_Relea:
                    /*
                     * clear _ss_sign()
                     */
                    ptr = ( pd.ptypvt.typ == PTY) ?
                              &pd.ptypvt.rbuf :
                              &((pd.ptypvt.pty)->ptypvt.wbuf);
                    if( ptr->rpid == procdesc->_id)
                        ptr->rpid = 0;
                    break;
#ifdef ST
                /*
                 * like Blkwr
                 */
                case SS_Screen:
                    if( (u_short) ustack->d[2] != ScrOut)
                        break;
                    ustack->d[2] = ustack->d[3];
#endif
                case SS_BlkWr:
                /*
                 * like a Write
                 */
                    ustack->d[1] = ustack->d[2];
                    return( Write( procdesc, ustack));

                default:
                    errno = E_UNKSVC;
                    return(-1);
            }
    }
    return (0);
}
