/*       This software is copyright (C) 1989 by Reimer Mellin        *
*                                                                    *
*        Permission is granted to reproduce and distribute           *
*        this package by any means so long as no fee is charged      *
*        above a nominal handling fee and so long as this            *
*        notice is always included in the copies.                    *
*        Commerical use or incorporation into commercial software    *
*        is prohibited without the written permission of the         *
*        author.                                                     *
*                                                                    *
*        Other rights are reserved except as explicitly granted      *
*        by written permission of the author.                        *
*                Reimer Mellin                                       *
*                                                                    *
*                Sulenstr.8                                          *
*                D-8000 Muenchen 71 (Federal Republic of Germany)    *
*                                                                    *
*           EMAIL:                                                   *
*                mellin@lan.informatik.tu-muenchen.dbp.de            *
*                ram@altger.UUCP                                     *
*                ram%ramsys@chiuur.sub.org (home)                    *
*                                                                    */
/*  */

/*
 * Funcs.c : Unterfunktionen zum Pty-FileManager.
 *
 * $Header: /h0/USR/REIMER/PTYMAN/RCS/funcs.c_v 1.3 91/06/08 01:20:27 ram Exp $
 *
 * $Log:	funcs.c_v $
 * Revision 1.3  91/06/08  01:20:27  ram
 * Added SS_IOCONT & SS_IOSTOP, various bugfixes, ftp-release on smilodon,
 * please share and distribute !!
 * 
 * Revision 1.2.1.2  89/09/04  13:12:41  ram
 * added some comments
 * 
 * Revision 1.2.1.1  89/08/31  12:24:51  ram
 * negative Read/Write Counts are made positive
 * 
 * Revision 1.2  89/07/16  01:04:51  ram
 * minor changes to Sub-net release
 * 
 * Revision 1.1.1.1  89/07/14  19:48:36  ram
 * Fixed: kbich, kbach. Sub-net Beta-Release
 * 
 * Revision 1.1  89/07/13  23:21:10  ram
 * Initial revision
 * 
 */

#include <types.h>
#include <MACHINE/reg.h>
#include "ptyman.h"
/*#include <path.h>*/
#include "path.h"
#include <sg_codes.h>
#include <procid.h>
#include <signal.h>
#include <modes.h>
#include <errno.h>

#include "misc.h"

extern union pathdesc pd;

int
hangup(procdesc)
register   procid    *procdesc;
{
    /* TRUE:
     *          - pty-typ is a tty
     *          - and correspondent pty has gone
     * Action:    send a offsig, if conection was severed by server
     */

    if(pd.ptypvt.typ == TTY && pd.ptypvt.pty == (union pathdesc *) 0) {
        errno = E_HANGUP;
        return TRUE;
    }
    return FALSE;
}

int inline
dosleep( procdesc )
register    procid  *procdesc;
{
    /*
     * 0:   - if wakedup by SIGWAKE
     * -1:  - if signal is < 32 ( ENOENT ) orseq process has been aborted
     * 0:   - other
     */

    if( tsleep(0) == 0 && procdesc->_signal == 0)
        return 0;
    if( (errno = procdesc->_signal) < 32
      || procdesc->_state & (P_DEAD|P_CONDEMNED))
        return -1;
    return 0;
}

/*
 * Falls Echo angeschaltet ist, schreibe einen Charakter in den Echobuffer
 * 1:   - falls echo ausgeschaltet ist oder echo erfolgreich
 * -1:  - Fehler bei Ausgabe (z.b. Prozess aborted)
 */
int
echochar( ch, buf, procdesc)
register    u_char          ch;
register    struct  ptybuf *buf;
            procid         *procdesc;
{   register    int rv;

    /*
     * if echo is off, return success
     */
    if( pd.ptyopt.pd_eko == '\0')
        return(1);

    /*
     * wait for other I/O, and register for SIGINT,SIGQUIT (set lpd )
     */
    iowait( buf->wpid);
    buf->wsig = SIGWAKE;
    buf->lpd = &pd;

    /*
     * my standard output-loop
     */
    while( buf->wptr >= (buf->buf + buf->size)) {
        /* stopped means STOP, so hang around and do not WakeUp */
        if( !(buf->flags & STOPPED))
          WAKE(buf->rpid, buf->rsig);
        buf->wpid = procdesc->_id;
        do {
            if( dosleep(procdesc) < 0) {
                rv = -1;
                goto outloop;
            }
        } while( buf->wpid);
    }
    *(buf->wptr)++ = ch;
    rv = 1;
outloop:
    buf->wpid = 0;
        /* stopped means STOP, so do not WakeUp */
    if( !(buf->flags & STOPPED))
      WAKE(buf->rpid, buf->rsig);
    return( rv );
}

/*
 * Lese cnt-Bytes im Raw-modus ein. Kein Echo, Lineediting etc....
 * 0:   - cnt-bytes gelesen
 * x:   - (cnt-x) bytes gelesen
 * -x:  - nach (cnt-x) ist Fehler aufgetreten (Interupted, Hangup etc.)
 */
int
cpinraw(buf, echobuf, ustack, procdesc)
register    struct  ptybuf *buf;
register    struct  ptybuf *echobuf;
            REGISTERS      *ustack;
            procid         *procdesc;
{   register    int     cnt = ustack->d[1] & 0x7fffffff; /* no neg. counts */
    register    u_char *dest = (u_char *) ustack->a[0];
    register    u_char ch;
    
    /*
     * this can only happen if _ss_sign() was set
     */
    if( buf->rpid == procdesc->_id) {
        errno = E_NOTRDY;
        return -cnt;
    }

    /* wait for other processes to finish */
    iowait( buf->rpid);
    buf->rsig = SIGWAKE;

    /* copy cnt bytes */
    for(; cnt > 0; --cnt) {
        /* if read-ptr reached write-ptr synchronize with partner */
        while( buf->rptr >= buf->wptr ) {
            /* reset ptr */
            buf->wptr = buf->rptr = buf->buf;

            /* stopped means STOP, so hang around and do not WakeUp */
            if( !(buf->flags & STOPPED))
              WAKE(buf->wpid, buf->wsig);

            buf->rpid = procdesc->_id;
            do {
                if( dosleep(procdesc) < 0) {
                    cnt = -cnt;
                    goto outloop;
                }
            } while ( buf->rpid);
        }
        /*
         * in read, one has still to check for SIGQUIT etc..
         * the signal is sent by the writing-process
         */
        if( ch = getctrlchar( (*dest++ = *(buf->rptr)++), &pd))
          switch( ch ) {
            case INT:
                errno = SIGINT;
                cnt = - (--cnt);
                goto outloop;

            case QUT:
                errno = SIGQUIT;
                cnt = - (--cnt);
                goto outloop;

            case EOR:
                pd.ptypvt.line = 0;
                break;
#ifdef LEV
/*
To make Microware's mshell happy when in
fancy readln mode ( -f)
*/
            case EOF:
                errno = E_EOF;
                cnt = - cnt;
                goto outloop;
#endif				
          }
    }
outloop:
    buf->rpid = 0;
    if(buf->rptr >= buf->wptr ) {
        buf->wptr = buf->rptr = buf->buf;
        /* stopped means STOP, so do not WakeUp */
        if( !(buf->flags & STOPPED))
          WAKE(buf->wpid, buf->wsig);
    }
    return( cnt);
}

/*
 * Lese cnt-Bytes. Echo, Lineediting, vorzeitiger Abbruch bei Lesen von CR
 * 0:   - cnt-bytes gelesen
 * x:   - (cnt-x) bytes gelesen
 * -x:  - nach (cnt-x) ist Fehler aufgetreten (Interupted, Hangup etc.)
 */
int
cpin(buf, echobuf, ustack, procdesc)
register    struct  ptybuf *buf;
            struct  ptybuf *echobuf;
            REGISTERS      *ustack;
            procid         *procdesc;
{   register    int     cnt = ustack->d[1] & 0x7fffffff; /* no neg. counts */
    register    u_char *dest = (u_char *) ustack->a[0];
    register    u_char *old  = pd.path.pd_buf;
    register    u_char  ch;
#ifdef LEV
/*
If we are readln, we may erase only these characters
we are input in this session, z.B.
writeln(1, "---->", 12);
readln (0, &buf, 12);
we must not erase prompt "---->"
while typing characters
*/   
	int colm = 0;
#endif	
    /*
     * this can only happen if _ss_sign() was set
     */
    if( buf->rpid == procdesc->_id) {
        errno = E_NOTRDY;
        return -cnt;
    }

    /* wait for other processes to finish */
    iowait( buf->rpid);
    buf->rsig = SIGWAKE;

    for(; cnt > 0; --cnt) {
        /* if read-ptr reached write-ptr synchronize with partner */
        while( buf->rptr >= buf->wptr ) {
            /* reset ptr */
            buf->wptr = buf->rptr = buf->buf;

            /* stopped means STOP, so do not WakeUp */
            if( !(buf->flags & STOPPED))
              WAKE(buf->wpid, buf->wsig);

            buf->rpid = procdesc->_id;
            do {
                if( dosleep(procdesc) < 0) {
                    cnt = -cnt;
                    goto outloop;
                }
            } while( buf->rpid);
        }
#ifdef UPCHAR
        ch = ( pd.ptyopt.pd_upc ? upchar(*(buf->rptr)++) : *(buf->rptr)++);
#else
        ch = *(buf->rptr)++;
#endif
        switch( getctrlchar(ch, &pd) ) {

            case BSP:
               /*
                * look in the Tech. manual to see what is meant here
                */
#ifdef LEV
/* See comment above */
			   if(!colm) {
			   		cnt++;
			   		break;
			   }
			   colm--;		
#endif
               if( ( pd.ptyopt.pd_bso ?
                   (echochar( pd.ptyopt.pd_bse, echobuf, procdesc) +
                    echochar( ' ' ,echobuf, procdesc) +
                    echochar( pd.ptyopt.pd_bse, echobuf, procdesc) < 3) :
                   (echochar( pd.ptyopt.pd_bse, echobuf, procdesc) < 1))) {
                        cnt = -cnt;
                        goto outloop;
                }
                dest--; old--;
                dest = MAX( (dest), ((u_char *) ustack->a[0]));
                old  = MAX( (old ), pd.path.pd_buf);
                if( cnt == ustack->d[1] )
                    cnt = ustack->d[1]+1;
                else
                    cnt += 2;
                break;

            case EOR:
                /*
                 * EOR resets pd_line and finishes
                 */
                pd.ptypvt.line = 0;
                *old++ = *dest++ = ch;
                if( ( echochar( ch, echobuf, procdesc) < 0
                    || ( pd.ptyopt.pd_alf
                        && echochar( '\l', echobuf, procdesc) < 0))) {
                    cnt = -cnt;
                    goto outloop;
                }
                cnt--;
                goto outloop;

            case INT:
                *old = *dest = ch;
                errno = SIGINT;
                cnt = - (--cnt);
                goto outloop;

            case QUT:
                *old = *dest = ch;
                errno = SIGQUIT;
                cnt = - (--cnt);
                goto outloop;

            case EOF:
                /*
                 * EOF only as first character !
                 */
                if( old == pd.path.pd_buf) {
                    errno = E_EOF;
                    cnt = -cnt;
                    goto outloop;
                } 

            case DEL:
                if( pd.ptyopt.pd_dlo != '\0' ) {
                  for(; old > pd.path.pd_buf; --old,cnt++)
                    if(( pd.ptyopt.pd_bso ?
                       (echochar( pd.ptyopt.pd_bse, echobuf, procdesc) +
                        echochar( ' ' ,echobuf, procdesc) +
                        echochar( pd.ptyopt.pd_bse, echobuf, procdesc) < 3) :
                       (echochar( pd.ptyopt.pd_bse, echobuf, procdesc) < 1))) {
                          cnt = -cnt;
                          goto outloop;
                    }
                }
                else
                   if( (echochar( pd.ptyopt.pd_eor, echobuf, procdesc)
                      + echochar( '\l', echobuf, procdesc) < 2)) {
                            cnt = -cnt;
                            goto outloop;
                   }
                dest = (u_char *) ustack->a[0];
                old  = pd.path.pd_buf;
                cnt  = ustack->d[1]+1;
                break;

            case DUP:
#ifdef LEV
/*
It's a simple bug
*/            
                for(; cnt > 1 ; --cnt) {
#else
                for(; cnt > 0 ; --cnt) {
#endif
                  if((ch = *dest++ = *old++) == pd.ptyopt.pd_eor &&
                      pd.ptyopt.pd_eor) {
                           dest--; old--;
                           break;
                  }
                  if( echochar( (ch < ' ' ? '.': ch), echobuf, procdesc) < 0) {
                  	cnt = - (--cnt);
                    goto outloop;
                  }
#ifdef LEV
				colm++;
#endif
                }
#ifdef LEV
                cnt++;
#endif
                break;

            case RPR:
                *old = *dest = pd.ptyopt.pd_eor;
                if(( echochar( *old, echobuf, procdesc) < 0 ||
                    (pd.ptyopt.pd_alf && echochar( '\l', echobuf, procdesc) < 0))) {
                      cnt = -cnt;
                      goto outloop;
                }
                {
                    register u_char *tmp = pd.path.pd_buf;

                    for(; tmp < old; tmp++)
                        if( echochar( *tmp, echobuf, procdesc) < 0) {
                            cnt = - cnt;
                            goto outloop;
                        }
		}
                break;

            default:
#ifdef LEV
				colm++;
#endif
                *old++ = *dest++ = ch;
                if( echochar( (ch < ' ' ? '.': ch), echobuf, procdesc) < 0) {
                    cnt = - (--cnt);
                    goto outloop;
                }
        }
    }
outloop:
    buf->rpid = 0;
    if( buf->rptr >= buf->wptr ) {
        buf->wptr = buf->rptr = buf->buf;
        /* stopped means STOP, so do not WakeUp */
        if( !(buf->flags & STOPPED))
          WAKE(buf->wpid, buf->wsig);
    }
    return( cnt);
}

/*
 * Schreibe cnt-Bytes im Raw-modus. Kein Alf etc....
 * 0:   - cnt-bytes geschrieben
 * x:   - (cnt-x) bytes geschrieben
 * -x:  - nach (cnt-x) ist Fehler aufgetreten (Interupted, Hangup etc.)
 */
int
cpoutraw(buf, echobuf, ustack, procdesc)
register    struct  ptybuf *buf;
register    struct  ptybuf *echobuf;
            REGISTERS      *ustack;
            procid         *procdesc;
{   register    int               cnt = ustack->d[1] & 0x7fffffff;
    register    u_char            *src = (u_char *) ustack->a[0];
    register    union   pathdesc  *echopd = echobuf->lpd;
    register    u_char            ch;
    register    u_int             bufend = (u_int) buf->buf + buf->size;

    iowait( buf->wpid);
    buf->wsig = SIGWAKE;
    buf->lpd = &pd;

    for(; cnt > 0; --cnt) {
        while( (buf->wptr >= (u_char *) bufend)) {
            if( !(buf->flags & STOPPED))
              WAKE(buf->rpid, buf->rsig);
            buf->wpid = procdesc->_id;
            do {
                if( dosleep(procdesc) < 0) {
                    cnt = -cnt;
                    goto outloop;
                }
	    } while( buf->wpid);
        }
        ch = *(buf->wptr)++ = *src++;
        if( echopd )
          switch( getctrlchar( ch, echopd )) {
            /*
             * Pause-Char: set pause-stop and remove char
             */
            case PSC:
              echobuf->flags |= PSCSTOP;
              (buf->wptr)--; /* dont send */
              break;

            /*
             * XOFF-char .. set xoff-stop and remove char
             */
            case XOFF:
              echobuf->flags |= XOFFSTOP;
              (buf->wptr)--; /* dont send */
              break;

            /*
             * XON-char .. remove xoff-stop and remove char
             * we have to Wake the stopped process !!
             */
            case XON:
              echobuf->flags &= ~XOFFSTOP;
              (buf->wptr)--; /* dont send */
              WAKE(echobuf->wpid, echobuf->wsig);
              break;

            /*
             * here the INT and QUIT signals are sent to the
             * last writing process ( echopd )
             */
            case INT:
            case QUT:
              if( ch == echopd->ptyopt.pd_int)
                kill(echopd->path.pd_lproc,SIGINT);
              else
                kill(echopd->path.pd_lproc,SIGQUIT);
              /* fall through ?! */

            default:
              /*
               * any char removes the pause-stop !!!
               * but the char gets clobbered
               */
              if( echobuf->flags & PSCSTOP ) {
                echobuf->flags &= ~PSCSTOP;
                (buf->wptr)--; /* dont send */
                WAKE(echobuf->wpid, echobuf->wsig);
              }
              break;
          }
    }
outloop:
    buf->wpid = 0;
    /*
     * only send WAKEUP if we output any char !! (XON/PSC-stop!
     * otherwise this may get confused with _ss_sigs !!
     */
    if( buf->wptr > buf->rptr && !(buf->flags & STOPPED ))
      WAKE(buf->rpid, buf->rsig);
    return( cnt);
}

/*
 * Schreibe cnt-Bytes. Alf, Tab-expanding, Pause-behandlung, Abbruch bei
 * vorzeitigem CR
 * 0:   - cnt-bytes geschrieben
 * x:   - (cnt-x) bytes geschrieben
 * -x:  - nach (cnt-x) ist Fehler aufgetreten (Interupted, Hangup etc.)
 */
int
cpout(buf, echobuf, ustack, procdesc)
register    struct  ptybuf *buf;
register    struct  ptybuf *echobuf;
            REGISTERS      *ustack;
            procid         *procdesc;
{   register    int               cnt = ustack->d[1] & 0x7fffffff;
    register    u_char            *src = (u_char *) ustack->a[0];
    register    union   pathdesc  *echopd = echobuf->lpd;
    register    u_char            ch;
    register    u_int             bufend = (u_int) buf->buf + buf->size;

    iowait( buf->wpid );
    buf->wsig = SIGWAKE;
    buf->lpd = &pd;

    for(; cnt > 0; --cnt) {
        while( (buf->wptr >= (u_char *) bufend)) {
            if( !(buf->flags & STOPPED))
              WAKE(buf->rpid, buf->rsig);
            buf->wpid = procdesc->_id;
            do {
                if( dosleep(procdesc) < 0) {
                    cnt = -cnt;
                    goto outloop;
                }
            } while( buf->wpid);
        }
        pd.ptyopt.pd_Col++;
        ch = *(buf->wptr)++ = *src++;
        if( ch ) {
          if( echopd )
            switch( getctrlchar( ch, echopd )) {
             /*
              * Pause-Char: set pause-stop and remove char
              */
              case PSC:
                echobuf->flags |= PSCSTOP;
                (buf->wptr)--; /* dont send */
                break;

             /*
              * XOFF-char .. set xoff-stop and remove char
              */
              case XOFF:
                echobuf->flags |= XOFFSTOP;
                (buf->wptr)--; /* dont send */
                break;

             /*
              * XON-char .. remove xoff-stop and remove char
              * we have to Wake to stopped process !!
              */
              case XON:
                echobuf->flags &= ~XOFFSTOP;
                (buf->wptr)--; /* dont send */
                WAKE(echobuf->wpid, echobuf->wsig);
                break;

             /*
              * QUIT and INT signals to last writing device
              */
              case INT:
              case QUT:
                if( ch == echopd->ptyopt.pd_int)
                  kill(echopd->path.pd_lproc,SIGINT);
                else
                  kill(echopd->path.pd_lproc,SIGQUIT);
                /* fall through ?? */

              /*
               * any char removes the pause-stop !!!
               * but the char gets clobbered
               */
              default:
                if( echobuf->flags & PSCSTOP ) {
                  echobuf->flags &= ~PSCSTOP;
                  (buf->wptr)--; /* dont send */
                  WAKE(echobuf->wpid, echobuf->wsig);
                }
                break;
            }
          if( ch == pd.ptyopt.pd_eor ) {
            pd.ptyopt.pd_Col = 0;
            if( pd.ptyopt.pd_pau && ++pd.ptypvt.line == pd.ptyopt.pd_pag ) {
                pd.ptypvt.line = 0;
                iowait( echobuf->rpid);
                if( !(echobuf->flags & STOPPED))
                  WAKE(echobuf->wpid, echobuf->wsig);
                echobuf->rpid = procdesc->_id;
                do {
                   if( dosleep(procdesc) < 0) {
                      cnt = -cnt;
                      goto outloop;
                   }
                } while( echobuf->rpid);
                echobuf->rptr++;
            }
            if( pd.ptyopt.pd_alf ) {
#ifdef LEV
/*
It's a very hard bug!
*/
                while( buf->wptr >= (buf->buf + buf->size)) {
#else
                if( buf->wptr >= (buf->buf + buf->size)) {
#endif
                    if( !(echobuf->flags & STOPPED))
                      WAKE(buf->rpid, buf->rsig);
                    buf->wpid = procdesc->_id;
                    do {
                        if( dosleep(procdesc) < 0) {
                            cnt = -cnt;
                            goto outloop;
                        }
                    } while( buf->wpid);
		}
                *(buf->wptr)++ = '\l';
            }
            --cnt;
            break;
          } else
            if( pd.ptyopt.pd_Tabs && pd.ptyopt.pd_Tab && ch == pd.ptyopt.pd_Tab) {
#ifdef LEV
/*
tabs handling by Mellin is simply incorrect
*/
				register short i = pd.ptyopt.pd_Tabs -
						(pd.ptyopt.pd_Col-1) % pd.ptyopt.pd_Tabs;
				pd.ptyopt.pd_Col += i-1;
#else
                register short i = (pd.ptyopt.pd_Col-1) % pd.ptyopt.pd_Tabs;
#endif
                (buf->wptr)--;
                for(; i > 0; i--) {
                    while( buf->wptr >= (buf->buf + buf->size)) {
                        if( !(buf->flags & STOPPED))
                          WAKE(buf->rpid, buf->rsig);
                        buf->wpid = procdesc->_id;
                        do {
                            if( dosleep(procdesc) < 0) {
                                cnt = -cnt;
                                goto outloop;
                            }
                        } while( buf->wpid);
                    }
                    *(buf->wptr)++ = ' ';
                }
            }
        }
    }
outloop:
    buf->wpid = 0;
    /*
     * only send WAKEUP if we output any char !! (XON/PSC-stop!
     * otherwise this may get confused with _ss_sigs !!
     */
    if( buf->wptr > buf->rptr && !(buf->flags & STOPPED ))
      WAKE(buf->rpid, buf->rsig);
    return( cnt);
}

