/* 
 * Routines to implement tags, and, especially, tag stacking.
 * Added by Dave Tutelman - 12/89.
 * The do_tag() routine is a modification of the posted
 * version by Tony Andrews.
 * The untag() routine is new.
 */

#include <stdio.h>
#include "pvic.h"
#include "locdefs.h"

#define LSIZE   256     /* max. size of a line in the tags file */

#ifdef TAGSTACK
/*  We build a stack of file records, on which we push info about
 *  current file when do_tag() is called.
 */
#define TAGSTACKSIZE    12              /* how many tag calls can we stack? */
static  struct filerecord {
		char    *name;                  /* file name pointer */
		int     linenum;                        /* line number when we left */
} tagstack [TAGSTACKSIZE];
static  int     stackindex = 0;         /* here's how we keep track */
#endif

extern  char    **files;
extern  int     current_file;
static  void    pushtags(), poptags();


/*
 * do_tag(tag, force) - goto tag.  If force=(1), dump pending changes.
 */
void
do_tag(tag, force)
char    *tag;
int     force;
{
	FILE    *tp, *fopen();
	char    lbuf[LSIZE];            /* line buffer */
	char    pbuf[LSIZE];            /* search pattern buffer */
	register char   *fname, *str;
	register char   *p;

	if ((tp = fopen("tags", "r")) == NULL) {
		error_message("Can't open tags file");
		return;
	}

	while (fgets(lbuf, LSIZE, tp) != NULL) {
	
		if ((fname = get_pointer_to_chr_in_string(lbuf, CTRL_I)) == NULL) {
			error_message("Format error in tags file");
			return;
		}
		*fname++ = '\0';
		if ((str = get_pointer_to_chr_in_string(fname, CTRL_I)) == NULL) {
			error_message("Format error in tags file");
			return;
		}
		*str++ = '\0';

		if (strcmp(lbuf, tag) == 0) {

			/*
			 * Scan through the search string. If we see a magic
			 * char, we have to quote it. This lets us use "real"
			 * implementations of ctags.
			 */
			p = pbuf;
			*p++ = *str++;          /* copy the '/' or '?' */
			*p++ = *str++;          /* copy the '^' */

			for (; *str != '\0' ;str++) {
				if (*str == '\\') {
					*p++ = *str++;
					*p++ = *str;
				} else if (get_pointer_to_chr_in_string("/?", *str) != NULL) {
					if (str[1] != '\n') {
						*p++ = '\\';
						*p++ = *str;
					} else
						*p++ = *str;
				} else if (get_pointer_to_chr_in_string("^()*.", *str) != NULL) {
					*p++ = '\\';
					*p++ = *str;
				} else
					*p++ = *str;
			}
			*p = '\0';


			/*
			 * This looks out of order, but by calling put_string_into_input_buffer()
			 * before do_e_command() we keep an extra screen update
			 * from occuring. This put_string_into_input_buffers() have no effect
			 * until we get back to the main loop, anyway.
			 */

			put_string_into_input_buffer(pbuf);             /* str has \n at end */
			put_string_into_input_buffer("\007");   /* CTRL_G */

			if (do_e_command(fname, force)) {
				fclose(tp);
				return;
			} else {
				put_string_into_input_buffer(NULL);     /* clear the input */
			}
		}
	}
	error_message("Tag not found");
	fclose(tp);
}

/*
 * do_untag (spec) - undo the last ':ta' command, popping the tag stack.
 *      spec is the appended character, giving specifics:
 *        '!'   dump pending changes.
 *        'e'   came from K_CCIRCM "shortcut".  do :e# if stack empty.
 *        ' '   do normal untag.
 *        else  bad command.
 */

void
do_untag (spec)
  char spec;
{
	bad_command();       /* complain & return */
}



