/*
* Version.
*/

#define VERSION_STRING  "PVIC 1.0"





/* 
* Declarations of standard library functions.
*/

char *malloc();
char *strncpy();
char *getenv();
char *strcpy();




/*
*  Definitions for all control characters.
*/

#define CTRL_A  		'\001'
#define CTRL_B   		'\002'
#define CTRL_C   		'\003'
#define CTRL_D   		'\004'
#define CTRL_E   		'\005'
#define CTRL_F   		'\006'
#define CTRL_G   		'\007'
#define CTRL_H   		'\010'
#define CTRL_I   		'\011'
#define CTRL_J   		'\012'
#define CTRL_K   		'\013'
#define CTRL_L   		'\014'
#define CTRL_M   		'\015'
#define CTRL_N   		'\016'
#define CTRL_O   		'\017'
#define CTRL_P   		'\020'
#define CTRL_Q   		'\021'
#define CTRL_R   		'\022'
#define CTRL_S   		'\023'
#define CTRL_T   		'\024'
#define CTRL_U   		'\025'
#define CTRL_V   		'\026'
#define CTRL_W   		'\027'
#define CTRL_X   		'\030'
#define CTRL_Y   		'\031'
#define CTRL_Z   		'\032'
#define ESC         		'\033'
#define CTRL_BACKSLASH 		'\034'
#define CTRL_RIGHT_BRACKET 	'\035'
#define CTRL_CIRCUMFLEX  	'\036'
#define CTRL_UNDERSCORE   	'\037'
#define DEL        		'\177'





/*
* General type and structure definitions.
*/

typedef struct line {
	struct line *prev;	/* Previous line. */
	struct line *next; 	/* Next line. */
	char *s;		/* Text for this line. */
	int size;	 	/* Actual size of space at 's'. */
	unsigned long num; 	/* Line number. */
} LINE;

typedef struct param {
	char *fullname; 	/* Full parameter name. */
	char *shortname;	/* Permissible abbreviation. */
	int value;  		/* Parameter value. */
	int flags;
} PARAM;

typedef struct lptr {
	struct line *linep; 	/* Line we're referencing. */
	int index; 		/* Position within that line. */
} LPTR;

typedef struct charinfo {
	char ch_size;
	char *ch_str;
} CHARINFO;





/* 
* General defines.
*/

#define STATUS_NORMAL 		0
#define STATUS_INSERT 		1
#define STATUS_REPLACE 		2
#define STATUS_CMDLINE 		3

#define SEARCH_FORWARD 		4
#define SEARCH_BACKWARD 	5

#define CHANGED  		(changed=1)
#define UNCHANGED 		(changed=0)

/* SLOP is the amount of extra space we get for text on a line during
editing operations that need more space. This keeps us from calling
malloc every time we get a character during insert mode. No extra
space is allocated when the file is initially read. */
#define SLOP 			10

/* LINEINC is the gap we leave between the artificial line numbers. This
helps to avoid renumbering all the lines every time a new line is
inserted. */
#define LINEINC 		10

#define LINEOF(x) 		((x)->linep->num)

/* Operators. */
#define NOP 		0  	/* No pending operation. */
#define DELETE 		1
#define YANK 		2
#define CHANGE 		3
#define LSHIFT 		4
#define RSHIFT 		5
#define FILTER 		6
#define TILDE 		7

/* When a cursor motion command is made, it is marked as being a character
or line oriented motion. Then, if an operator is in effect, the operation
becomes character or line oriented accordingly.
Character motions are marked as being inclusive or not. Most char.
motions are inclusive, but some (e.g. 'w') are not. */
#define MBAD 		(-1)  	/* Bad motion type marks unusable yank buf. */
#define MCHAR 		0
#define MLINE 		1

/* Macro to get current character from a LPTR * value. */
#define CHAR(lpp)	lpp->linep->s[lpp->index]











/*
* alloc.c
*/

char *alloc();
char *strsave();
char *mkstr();
int alloc_screen();
void file_alloc();
void freeall();
LINE *newline();
int buffer_empty();
int buf1line();
int line_empty();
int end_of_line();
int can_increase();




/*
* cmdline.c
*/

void do_command_line();
void msg();
void error_message();
void show_message();
void goto_command();
void wait_return();
void bad_command();
int do_e_command();
char *getcmdln();




/*
* edit.c
*/

void edit();
void insert_char();
void get_out();
void scroll_up();
void scroll_down();
void begin_line();
int one_right();
int one_left();
int one_up();
int one_down();




/*
* fileio.c
*/

void file_message();
void renum();
int read_file();
int write_it();


/*
* general.c
*/

void beep();
void loop_n_seconds();
void pvic_init();
void pvic_exit();
char to_lower();
char to_upper();
int is_upper();
int is_lower();
int is_alpha();
int is_space();
int is_digit();
void rename_file();


/*
* help.c
*/

int help();




/*
* linefunc.c
*/

LPTR *next_line();
LPTR *previous_line();
LPTR *advance_column();
LPTR *next_char();
LPTR *previous_char();




/*
* main.c
*/

void put_string_into_input_buffer();
void put_int_into_input_buffer();
void do_mlines();
int  get_char_from_input_buffer();
int is_input_pending();

extern char **files;                /* used for "n" and "rew" */
extern int number_of_files;
extern int current_file;
extern int need_redraw;
extern int did_ai;
extern int number_of_files;
extern int current_file;
extern int interactive;
extern char **files;
extern int current_file;
extern struct param params[];
extern CHARINFO chars[];
extern int current_status;
extern int current_lines;
extern int current_columns;
extern char *real_screen;
extern char *next_screen;
extern char *file_name;
extern LPTR *file_memory;
extern LPTR *top_of_file;
extern LPTR *end_of_file;
extern LPTR *top_char;
extern LPTR *bottom_char;
extern LPTR *cursor_char;
extern LPTR *start_insert;
extern int cursor_row;
extern int cursor_column;
extern int cursor_virtual_column;
extern int wanted_cursor_column;
extern int set_wanted_cursor_column;
extern int prenum;
extern int changed;
extern char redo_buffer[];
extern char insert_buffer[];
extern char *insert_pointer;
extern int insert_n;




/*
* mark.c
*/

void set_pc_mark();
void clear_all();
void clear_mark();
int set_mark();
LPTR *get_mark();




/*
* misccmds.c
*/

void open_command();
void file_info();
void inschar();
void delete_line();
int delete_char();
int  cntllines();
int plines();
LPTR *goto_line();




/*
* normal.c
*/

void normal();

extern int operator;  		/* Current pending operator. */

extern int mtype;   		/* type of the current cursor motion */
extern int mincl;   		/* true if char motion is inclusive */

extern LPTR startop;  		/* cursor pos. at start of operator */







/*
*  param.c
*/

/* Flags used for the parameters in the params array. */
#define BOOLEAN_PARAMETER  	0x01 	/* The parameter is boolean. */
#define NUMERIC_PARAMETER  	0x02 	/* The parameter is numeric. */
#define PARAMETER_HAS_CHANGED  	0x04 	/* The parameter has been changed. */

/* The following are the indices for the numeric parameters 
in the params array for each parameter.  */
#define PARAMETER_LINES  	0	/* Lines. */
#define PARAMETER_REPORT 	1	/* Report. */
#define PARAMETER_SCROLL 	2	/* Scroll size. */
#define PARAMETER_TABSTOP 	3	/* Tab size. */

/* The following are the indices for the boolean parameters 
in the params array for each parameter. */
#define PARAMETER_AUTOINDENT 	4 	/* auto-indent */
#define PARAMETER_BACKUP 	5	/* make backups when 
					writing out files */
#define PARAMETER_ERRORBELLS 	6	/* error bells */
#define PARAMETER_IGNORECASE 	7	/* ignore case in searches */
#define PARAMETER_LIST   	8	/* show tabs and newlines 
				      	graphically */
#define PARAMETER_MODELINES 	9	/* enables mode-lines processing */
#define PARAMETER_NUMBER 	10	/* number lines on the screen */
#define PARAMETER_SHOWMATCH 	11	/* show_match */
#define PARAMETER_SHOWMODE 	12	/* show mode */
#define PARAMETER_VBELL  	13	/* visual bell */
#define PARAMETER_WRAPSCAN 	14	/* wrap scan */

/* Macro to get the value of a parameter.  */
#define PARAMETER_VALUE(n) (params[n].value)

void do_set();



/*
* ptrfunc.c
*/

int inc();
int dec();
int gchar();
void pchar();
void pswap();
int lt();
int equal();
int ltoreq();




/*
* screen.c
*/

void update_screen();
void update_line();
void clear_screen();
void update_cursor();
void prt_line();
extern int need_redraw;




/*
* search.c
*/

void do_sub();
void do_glob();
int search_char();
int crep_search();
int find_function();
int do_search();
int rep_search();
LPTR *show_match();
LPTR *forward_word();
LPTR *back_word();
LPTR *end_word();




/*
* tagcmd.c
*/

void do_tag();
void do_untag();





/* 
* termin.c 
*/

void init_translate_table();
void read_input();
void put_char_into_input_buffer();
void put_string_into_input_buffer();
void put_int_into_input_buffer();
int is_input_pending();
void test_n_seconds_for_input();




/*  
* termcap.c 
*/

void init_termcap();
char *read_termcap_entry();
char *get_termcap_string();
int get_termcap_number();

extern int termcap_lines;
extern int termcap_columns;
extern char *termcap_init_terminal;
extern char *termcap_deinit_terminal;
extern char *termcap_clr_eol;  /* Erase the entire current line. */
extern char *termcap_save_cursor; /* Save the cursor position. */
extern char *termcap_clear_screen; /* Erase display (may optionally 
     home cursor). */
extern char *termcap_restore_cursor; /* Restore the cursor position. */
extern char *termcap_cursor_invisible; /* Invisible cursor (very optional). */
extern char *termcap_cursor_visible; /* Visible cursor (very optional). */
extern char *termcap_cursor_address; /* Cursor motion string. */
extern char *termcap_bell;  /* Audible bell. */
extern char *termcap_key_f1;
extern char *termcap_key_f2;
extern char *termcap_key_ic;
extern char *termcap_key_dc;
extern char *termcap_key_home;
extern char *termcap_key_eol;
extern char *termcap_key_ppage;
extern char *termcap_key_npage;
extern char *termcap_key_up;
extern char *termcap_key_down;
extern char *termcap_key_left;
extern char *termcap_key_right;
extern char *termcap_key_backspace;



/*
 * undo.c
 */

void u_save();
void u_save_line();
void u_clear();
void u_l_check();
void u_l_undo();
void u_undo();
int inchar();
void flushbuf();
void outchar();
void outstr();
void beep();
char *fixname();
void pvic_init();
void pvic_exit();
void goto_screen_pos();
void pause();
void do_shell();
char *get_pointer_to_chr_in_string();
int get_offset_of_chr_in_s1_matching_chr_in_s2();





/*
* ops.c
*/

void do_shift();
void do_delete();
void do_put();
void do_change();
void do_filter();
void dotilde();
int do_join();
int do_yank();
void do_start_insert();



/* 
* regexp.c 
*/

#define MAGIC 			0234

#define NSUBEXP  		10

typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

extern regexp *reg_comp();
extern int reg_exec();
extern void reg_sub();
extern void reg_error();
char *cstrchr();

extern int reg_ic;

