#include <stdio.h>
#include "pvic.h"
#include "locdefs.h"

int current_lines;
int current_columns;

char *real_screen = NULL;	/* What's currently on the screen, a single */
char *next_screen = NULL;	/* What's to be put on the screen. */

char *file_name = NULL;		/* Current file name */

LPTR *file_memory;		/* Pointer to the first line of the file */

LPTR *top_of_file;		/* Line 'above' the start of the file */

LPTR *end_of_file;		/* Pointer to the end of the file in 
				file_memory. (It points to the byte AFTER 
				the last byte.) */

LPTR *top_char;			/* Pointer to the byte in file_memory which 
				in the upper left corner of the screen. */

LPTR *bottom_char;		/* Pointer to the byte in file_memory which is
				just off the bottom of the screen. */

LPTR *cursor_char;		/* Pointer to byte in file_memory at which the 
				cursor is currently placed. */

int cursor_row, cursor_column;	/* Current position of cursor */

int cursor_virtual_column;	/* Current virtual column, the column 
				number of the file's actual line, as 
				opposed to the column number we're at on 
				the screen.  This makes a difference on 
				lines that span more than one screen line. */

int wanted_cursor_column = 0;	/* The column we'd like to be at. This is used 
				try to stay in the same column through up/down 
				cursor motions. */

int set_wanted_cursor_column;	/* If set, then update wanted_cursor_column 
				the next time through update_cursor() to 
				the current virtual column. */

int current_status = STATUS_NORMAL;	/* This is the current state of the 
					command interpreter. */

int prenum = 0;			/* The (optional) number before a command. */

LPTR *start_insert;		/* This is where the latest insert/append 
				mode started. */

int changed = 0;		/* Set to 1 if something in the file has been 
				changed and not written out. */

char redo_buffer[1024];		/* Each command should stuff characters into 
				this  buffer that will re-execute itself. */

char insert_buffer[1024];	/* Each insertion gets stuffed into this buffer. */

int insert_n = 0;		/* Number of characters in the current 
				insertion. */
char *insert_pointer = NULL;

int interactive=0;		/* Set (1) when main() is ready to roll. */

char **files;			/* List of input files. */
int  number_of_files;		/* Number of input files. */
int  current_file;		/* Number of the current file. */




static void usage()
{
	fprintf(stderr, "Usage: vi [file ...]\n");
	fprintf(stderr, "       vi -t tag\n");
	fprintf(stderr, "       vi +[num] file\n");
	fprintf(stderr, "       vi +/pat  file\n");
	exit(1);
}




main(argc,argv)
int	argc;
char	*argv[];
{
	char *initstr,*getenv();	/* init string from the environment */
	char *tag=NULL;			/* tag from command line */
	char *pat=NULL;			/* pattern from command line */
	int line=-1;			/* line number from command line */

	/*
	 * Process the command line arguments.
	 */
	if (argc > 1) {
		switch (argv[1][0]) {

		case '-':			/* -t tag */
			if (argv[1][1] != 't')
				usage();

			if (argv[2] == NULL)
				usage();

			file_name = NULL;
			tag = argv[2];
			number_of_files = 1;
			break;

		case '+':			/* +n or +/pat */
			if (argv[1][1] == '/') {
				if (argv[2] == NULL)
					usage();
				file_name = strsave(argv[2]);
				pat = &(argv[1][1]);
				number_of_files = 1;

			} else if (is_digit(argv[1][1]) || argv[1][1] == '\0') {
				if (argv[2] == NULL)
					usage();
				file_name = strsave(argv[2]);
				number_of_files = 1;

				line = (is_digit(argv[1][1])) ?
					atoi(&(argv[1][1])) : 0;
			} else
				usage();

			break;

		default:			/* must be a file name */
			file_name = strsave(argv[1]);
			files = &(argv[1]);
			number_of_files = argc - 1;
			break;
		}
	} else {
		file_name = NULL;
		number_of_files = 1;
	}
	current_file = 0;

 	if (number_of_files > 1)
 		fprintf(stderr, "%d files to edit\n", number_of_files);

	pvic_init();

	/*
	 * Allocate LPTR structures for all the various position pointers
	 */
 	if ((file_memory = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
 	    (top_of_file = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
 	    (end_of_file = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
 	    (top_char = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
 	    (bottom_char = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
 	    (cursor_char = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
	    (start_insert = (LPTR *) malloc(sizeof(LPTR))) == NULL ||
	    (alloc_screen() == -1) ) 
	{
		fprintf(stderr, "Can't allocate data structures\n");
		pvic_exit(1);
	}

	/* Initialize file_memory, top_of_file, and end_of_file */
	file_alloc();

	clear_screen();

	if ((initstr = getenv("EXINIT")) != NULL) 
	{
		char *lp, buf[128];

		if ((lp = getenv("LINES")) != NULL) 
		{
			sprintf(buf, "%s lines=%s", initstr, lp);
			do_command_line(buf);
		}
		else do_command_line(initstr);
	}

	if (file_name != NULL) 
	{
		if (read_file(file_name, file_memory, (0)))
			file_message("[new file]");
	} 
	else if (tag == NULL)msg("Empty buffer");

	set_pc_mark();

	if (tag) 
	{
		put_string_into_input_buffer(":ta ");
		put_string_into_input_buffer(tag);
		put_string_into_input_buffer("\n");

	}
	else if (pat)
	{
		put_string_into_input_buffer(pat);
		put_string_into_input_buffer("\n");

	}
	else if (line >= 0) 
	{
		if (line > 0)put_int_into_input_buffer(line);
		put_string_into_input_buffer("G");
	}

	interactive=1;

	update_screen(1);
	edit();

	pvic_exit(0);

	return 1;		/* shouldn't be reached */
}




