#include <stdio.h>
#include <signal.h>
#include "pvic.h"
#include "locdefs.h"

#include <sgstat.h>


/* Read one character from the terminal without echoing it. */
int local_get_character()
{
        char c;
        if(read(0,&c,1)!=1)return '\033';
        else return c;
}


/* Test if there is a character to be read from the terminal. If so the
return value is possitive. If not the return value is zero. If we are
not able to determine whether a character is waiting or not, the return
value is negative. */
int local_is_input_pending()
{
	return _gs_rdy(0)>0?1:0;
}


/* Initialize PVIC. */
void local_init()
{
	return;
}


/* Deinitialize PVIC. */
void local_deinit()
{
	return;
}


static struct sgbuf old_settings;

/* Initialize the terminal I/O. */
void local_init_terminal_io()
{
        struct sgbuf new_settings;

        _gs_opt(0,&old_settings);
        _gs_opt(0,&new_settings);
        new_settings._sgm._sgs._sgs_pause=0;
        new_settings._sgm._sgs._sgs_echo=0;
        new_settings._sgm._sgs._sgs_eofch=0;
        new_settings._sgm._sgs._sgs_bspch=0;
        new_settings._sgm._sgs._sgs_dlnch=0;
        new_settings._sgm._sgs._sgs_dulnch=0;
        new_settings._sgm._sgs._sgs_psch=0;
        new_settings._sgm._sgs._sgs_kbich=0;
        new_settings._sgm._sgs._sgs_kbach=0;
        new_settings._sgm._sgs._sgs_bsech=0;
        new_settings._sgm._sgs._sgs_bellch=0;
        _ss_opt(0,&new_settings);

	return;
}


/* Deinitialize the terminal I/O. */
void local_deinit_terminal_io()
{
        _ss_opt(0,&old_settings);

	return;
}



/* Flag which is set by local_control_c_handler if control-c is pressed. */
static int control_c_pressed=0;



/* Function called when control-c is pressed. */
void local_control_c_handler()
{
	control_c_pressed=1;
}



/* Reset the control_c_pressed flag. */
void local_reset_control_c_pressed()
{
	control_c_pressed=0;
}



/* Get the value of the control_c_pressed flag. */
int local_control_c_pressed()
{
	return control_c_pressed;
}



rename(old,new)
char *old,*new;
{
        char cmd[128];
        sprintf(cmd,"rename %s %s",old,new);
        system(cmd);
}
