/* Terminal size. */
#define DEFAULT_TERMCAP_LINES			24
#define DEFAULT_TERMCAP_COLUMNS			80

/* Default termcap strings. */
#define	DEFAULT_TERMCAP_CLR_EOL			"\033[K"	
#define	DEFAULT_TERMCAP_CLEAR_SCREEN		"\033[2J"
#define	DEFAULT_TERMCAP_SAVE_CURSOR		"\033[s"
#define	DEFAULT_TERMCAP_RESTORE_CURSOR		"\033[u"
#define	DEFAULT_TERMCAP_CURSOR_INVISIBLE	""
#define	DEFAULT_TERMCAP_CURSOR_VISIBLE		""	
#define	DEFAULT_TERMCAP_CURSOR_ADDRESS		"\033[%i%d;%dH"
#define DEFAULT_TERMCAP_INIT_TERMINAL		""
#define DEFAULT_TERMCAP_DEINIT_TERMINAL		""
#define DEFAULT_TERMCAP_BELL			"\007"   

#define DEFAULT_TERMCAP_KEY_F1			"\033OP"   
#define DEFAULT_TERMCAP_KEY_F2			"\033OQ"   
#define DEFAULT_TERMCAP_KEY_IC			""		/* Insert. */
#define DEFAULT_TERMCAP_KEY_DC			"\177"		/* Delete. */
#define DEFAULT_TERMCAP_KEY_HOME	 	""
#define DEFAULT_TERMCAP_KEY_EOL			""	
#define DEFAULT_TERMCAP_KEY_PPAGE		""     	 	/* PgUp. */
#define DEFAULT_TERMCAP_KEY_NPAGE		""	  	/* PgDn. */
#define DEFAULT_TERMCAP_KEY_UP			"\033[A"
#define DEFAULT_TERMCAP_KEY_DOWN		"\033[B"
#define DEFAULT_TERMCAP_KEY_LEFT		"\033[D"
#define DEFAULT_TERMCAP_KEY_RIGHT		"\033[C"
#define DEFAULT_TERMCAP_KEY_BACKSPACE 		"\010"	

/* Strings for keys. Even if a termcap entry is available, these key
strings are recognised. */
#define ALT_TERMCAP_KEY_F1			""   
#define ALT_TERMCAP_KEY_F2			""   
#define ALT_TERMCAP_KEY_IC			""	        /* Insert. */
#define ALT_TERMCAP_KEY_DC			""        	/* Delete. */
#define ALT_TERMCAP_KEY_HOME			""
#define ALT_TERMCAP_KEY_EOL			""	
#define ALT_TERMCAP_KEY_PPAGE			""              /* PgUp. */
#define ALT_TERMCAP_KEY_NPAGE			""        	/* PgDn. */
#define ALT_TERMCAP_KEY_UP			""
#define ALT_TERMCAP_KEY_DOWN	 		""
#define ALT_TERMCAP_KEY_LEFT			""
#define ALT_TERMCAP_KEY_RIGHT			""
#define ALT_TERMCAP_KEY_BACKSPACE 		""	

/* Local definitions of control characters. */
#define LOCAL_BACKSPACE_KEY			"\010"
#define LOCAL_TAB_KEY				"\020"
#define LOCAL_RETURN_KEY			"\015"
#define LOCAL_ESC_KEY				"\033"
#define LOCAL_DEL_KEY				"\177"

/* Local non-portable strings. */
#define LOCAL_SHELL				"shell"
#define LOCAL_TERMCAP_FILE			"/dd/sys/termcap"
#define LOCAL_TERM_ENVIRONMENT_VAR		"TERM"
#define LOCAL_TERMCAP_ENVIRONMENT_VAR		"TERMCAP"

/* Local non-portable functions. */
int local_get_character();
int local_is_input_pending();
void local_init();
void local_deinit();
void local_init_terminal_io();
void local_deinit_terminal_io();
void local_control_c_handler();
void local_reset_control_c_pressed();
int local_control_c_pressed();

