/* 
 * Basic line-oriented motions.
 */

#include <stdio.h>
#include "pvic.h"
#include "locdefs.h"

/*
 * next_line(curr)
 *
 * Return a pointer to the beginning of the next line after the one
 * referenced by 'curr'. Return NULL if there is no next line (at EOF).
 */

LPTR *
next_line(curr)
LPTR    *curr;
{
	static  LPTR    next;

	if (curr->linep->next != end_of_file->linep) {
		next.index = 0;
		next.linep = curr->linep->next;
		return &next;
	}
	return (LPTR *) NULL;
}

/*
 * previous_line(curr)
 *
 * Return a pointer to the beginning of the line before the one
 * referenced by 'curr'. Return NULL if there is no prior line.
 */

LPTR *
previous_line(curr)
LPTR    *curr;
{
	static  LPTR    prev;

	if (curr->linep->prev != top_of_file->linep) {
		prev.index = 0;
		prev.linep = curr->linep->prev;
		return &prev;
	}
	return (LPTR *) NULL;
}

/*
 * advance_column(p,col)
 *
 * Try to advance to the specified column, starting at p.
 */

LPTR *
advance_column(p, col)
LPTR    *p;
register int    col;
{
	static  LPTR    lp;
	register int    c, in;

	lp.linep = p->linep;
	lp.index = p->index;

	/* If we're on a blank ('\n' only) line, we can't do anything */
	if (lp.linep->s[lp.index] == '\0')
		return &lp;
	/* try to advance to the specified column */
	for ( c=0; col-- > 0; c++ ) {
		/* Count a tab for what it's worth (if list mode not on) */
		if ( gchar(&lp) == CTRL_I && !PARAMETER_VALUE(PARAMETER_LIST) ) {
			in = ((PARAMETER_VALUE(PARAMETER_TABSTOP)-1) - c%PARAMETER_VALUE(PARAMETER_TABSTOP));
			col -= in;
			c += in;
		}
		/* Don't go past the end of */
		/* the file or the line. */
		if (inc(&lp)) {
			dec(&lp);
			break;
		}
	}
	return &lp;
}


/*
 * next_char(curr)
 *
 * Return a line pointer to the next character after the
 * one referenced by 'curr'. Return NULL if there is no next one (at EOF).
 * NOTE: this COULD point to a \n or \0 character.
 */

LPTR *
next_char(curr)
LPTR    *curr;
{
	static  LPTR    *next;
	char    c;

	next = curr;
	c = CHAR( next );
	if (c=='\n' || c=='\0')         /* end of line */
		next = next_line (next);
	else
		next->index++;

	return (next);
}


/*
 * previous_char(curr)
 *
 * Return a line pointer to the previous character before the
 * one referenced by 'curr'. Return NULL if there is no previous one.
 * Note: this COULD point to a \n or \0 character.
 */

LPTR *
previous_char(curr)
LPTR    *curr;
{
	static  LPTR    *prev;
	char    c;

	prev = curr;
	if (prev->index == 0) {         /* beginning of line */
		prev = previous_line (prev);         /* jump back */
		c = CHAR( prev );
		while (c!='\n' && c!= '\0') {   /* go to end of line */
			prev->index++;
			c = CHAR( prev );
		}
	}
	else
		prev->index--;

	return (prev);
}


