#include <stdio.h>
#include "pvic.h"
#include "locdefs.h"




#define LAST_HELP_PAGE		 8



void help_param();





int help()
{
	static int current_help_page = 0;

	if(current_columns<80)return 1;

	for(;;)
	{
		termcap_out(termcap_clear_screen);
		termcap_out(termcap_cursor_invisible);
                goto_screen_pos(0,0);
	
		switch(current_help_page)
		{

		    default:

fprintf(stdout,"Help Index\n");
fprintf(stdout,"==========\n");
fprintf(stdout,"0           Help Index (this screen)\n");
fprintf(stdout,"1           Positioning within Files\n");
fprintf(stdout,"            Adjusting the Screen\n");
fprintf(stdout,"2           Character Positioning\n");
fprintf(stdout,"3           Line Positioning\n");
fprintf(stdout,"            Marking and Returning\n");
fprintf(stdout,"            Undo and Redo\n");
fprintf(stdout,"4           Insert and Replace\n");
fprintf(stdout,"            Words, Sentences, Paragraphs\n");
fprintf(stdout,"5           Operators\n");
fprintf(stdout,"            Miscellaneous Operations\n");
fprintf(stdout,"            Yank and Put\n");
fprintf(stdout,"6           EX Command-Line Operations\n");
fprintf(stdout,"7           Set Parameters\n");
fprintf(stdout,"8           About PVIC");

			break;

		    case 1:

fprintf(stdout,"Positioning within File\n");
fprintf(stdout,"=======================\n");
fprintf(stdout,"^F          forward screenfull\n");
fprintf(stdout,"^B          backward screenfull\n");
fprintf(stdout,"^D          scroll down half screen\n");
fprintf(stdout,"^U          scroll up half screen\n");
fprintf(stdout,"G           goto line (end default)\n");
fprintf(stdout,"]]          next function\n");
fprintf(stdout,"[[          previous function\n");
fprintf(stdout,"/re         next occurence of regular expression 're'\n");
fprintf(stdout,"?re         prior occurence of regular expression 're'\n");
fprintf(stdout,"n           repeat last / or ?\n");
fprintf(stdout,"N           reverse last / or ?\n");
fprintf(stdout,"%%           find matching (, ), {, }, [, or ]\n");
fprintf(stdout,"\n");
fprintf(stdout,"Adjusting the Screen\n");
fprintf(stdout,"====================\n");
fprintf(stdout,"^L          redraw the screen\n");
fprintf(stdout,"^E          scroll window down 1 line\n");
fprintf(stdout,"^Y          scroll window up 1 line\n");
fprintf(stdout,"z<RETURN>   redraw, current line at top\n");
fprintf(stdout,"z-          ... at bottom\n");
fprintf(stdout,"z.          ... at center");

			break;

		    case 2:

fprintf(stdout,"Character Positioning\n");
fprintf(stdout,"=====================\n");
fprintf(stdout,"^           first non-white\n");
fprintf(stdout,"0           beginning of line\n");
fprintf(stdout,"$           end of line\n");
fprintf(stdout,"h           backward\n");
fprintf(stdout,"l           forward\n");
fprintf(stdout,"^H          same as h\n");
fprintf(stdout,"space       same as l\n");
fprintf(stdout,"fx          find 'x' forward\n");
fprintf(stdout,"Fx          find 'x' backward\n");
fprintf(stdout,"tx          upto 'x' forward\n");
fprintf(stdout,"Tx          upto 'x' backward\n");
fprintf(stdout,";           Repeat last f, F, t, or T\n");
fprintf(stdout,",           inverse of ;\n");
fprintf(stdout,"|           to specified column\n");
fprintf(stdout,"%%           find matching (, ), {, }, [, or ]");

			break;

		    case 3:

fprintf(stdout,"Line Positioning\n");
fprintf(stdout,"================\n");
fprintf(stdout,"H           home window line\n");
fprintf(stdout,"L           last window line\n");
fprintf(stdout,"M           middle window line\n");
fprintf(stdout,"+           next line, at first non-white\n");
fprintf(stdout,"-           previous line, at first non-white\n");
fprintf(stdout,"CR          return, same as +\n");
fprintf(stdout,"j           next line, same column\n");
fprintf(stdout,"k           previous line, same column\n");
fprintf(stdout,"\n");
fprintf(stdout,"Marking and Returning\n");
fprintf(stdout,"=====================\n");
fprintf(stdout,"``          previous context\n");
fprintf(stdout,"''          ... at first non-white in line\n");
fprintf(stdout,"mx          mark position with letter 'x'\n");
fprintf(stdout,"`x          to mark 'x'\n");
fprintf(stdout,"'x          ... at first non-white in line\n");
fprintf(stdout,"\n");
fprintf(stdout,"Undo and Redo\n");
fprintf(stdout,"=============\n");
fprintf(stdout,"u           undo last change\n");
fprintf(stdout,"U           restore current line\n");
fprintf(stdout,".           repeat last change");

			break;

		    case 4:

fprintf(stdout,"Insert and Replace\n");
fprintf(stdout,"==================\n");
fprintf(stdout,"a           append after cursor\n");
fprintf(stdout,"i           insert before cursor\n");
fprintf(stdout,"A           append at end of line\n");
fprintf(stdout,"I           insert before first non-blank\n");
fprintf(stdout,"o           open line below\n");
fprintf(stdout,"O           open line above\n");
fprintf(stdout,"rx          replace single char with 'x'\n");
fprintf(stdout,"R           replace characters\n");
fprintf(stdout,"~           change case (upper/lower) of single char\n");
fprintf(stdout,"\n");
fprintf(stdout,"Words, Sentences, Paragraphs\n");
fprintf(stdout,"============================\n");
fprintf(stdout,"w           word forward\n");
fprintf(stdout,"b           back word\n");
fprintf(stdout,"e           end of word\n");
fprintf(stdout,")           to next sentence\n");
fprintf(stdout,"}           to next paragraph\n");
fprintf(stdout,"(           back sentence\n");
fprintf(stdout,"{           back paragraph\n");
fprintf(stdout,"W           blank delimited word\n");
fprintf(stdout,"B           back W\n");
fprintf(stdout,"E           to end of W");

			break;

		    case 5:

fprintf(stdout,"Operators (double to affect lines)\n");
fprintf(stdout,"==================================\n");
fprintf(stdout,"d           delete\n");
fprintf(stdout,"c           change\n");
fprintf(stdout,"<           left shift\n");
fprintf(stdout,">           right shift\n");
fprintf(stdout,"y           yank to buffer\n");
fprintf(stdout,"!           filter lines (command name follows)\n");
fprintf(stdout,"\n");
fprintf(stdout,"Miscellaneous Operations\n");
fprintf(stdout,"========================\n");
fprintf(stdout,"C           change rest of line\n");
fprintf(stdout,"D           delete rest of line\n");
fprintf(stdout,"s           substitute chars\n");
fprintf(stdout,"S           substitute lines (not yet)\n");
fprintf(stdout,"J           join lines\n");
fprintf(stdout,"x           delete characters\n");
fprintf(stdout,"X           ... before cursor\n");
fprintf(stdout,"\n");
fprintf(stdout,"Yank and Put\n");
fprintf(stdout,"============\n");
fprintf(stdout,"p           put back text\n");
fprintf(stdout,"P           put before\n");
fprintf(stdout,"Y           yank lines");

			break;

		    case 6:

fprintf(stdout,"EX Command-Line Operations\n");
fprintf(stdout,"==========================\n");
fprintf(stdout,":w          write back changes\n");
fprintf(stdout,":wq         write and quit\n");
fprintf(stdout,":x          write if modified, and quit\n");
fprintf(stdout,":q          quit\n");
fprintf(stdout,":q!         quit, discard changes\n");
fprintf(stdout,":e name     edit file 'name'\n");
fprintf(stdout,":e!         reedit, discard changes\n");
fprintf(stdout,":e #        edit alternate file\n");
fprintf(stdout,":w name     write file 'name'\n");
fprintf(stdout,":n          edit next file in arglist\n");
fprintf(stdout,":N          edit prior file in arglist\n");
fprintf(stdout,":rew        rewind arglist\n");
fprintf(stdout,":f          show current file and lines\n");
fprintf(stdout,":f file     change current file name\n");
fprintf(stdout,":g/pat/p|d  global command (print or delete only)\n");
fprintf(stdout,":s/p1/p2/g  text substitution (trailing 'g' optional)\n");
fprintf(stdout,":sh         run an interactive shell\n");
fprintf(stdout,":!cmd       execute a shell command");

			break;

		    case 7:

fprintf(stdout,"Set Parameters\n");
fprintf(stdout,"==============\n");
fprintf(stdout,":set [no]param-name            set boolean parameters\n");
fprintf(stdout,":set param-name=param-value    set other parameters\n");
fprintf(stdout,":set all                       display all values\n");
fprintf(stdout,":set                           display non-default values\n");
fprintf(stdout,"\n");
fprintf(stdout,"Abbrev, name, and current value:\n");
help_param(PARAMETER_AUTOINDENT);help_param(PARAMETER_BACKUP);fprintf(stdout,"\n");
help_param(PARAMETER_ERRORBELLS);help_param(PARAMETER_IGNORECASE);fprintf(stdout,"\n");
help_param(PARAMETER_LINES);help_param(PARAMETER_MODELINES);fprintf(stdout,"\n");
help_param(PARAMETER_NUMBER);help_param(PARAMETER_SHOWMATCH);fprintf(stdout,"\n");
help_param(PARAMETER_SHOWMODE);help_param(PARAMETER_TABSTOP);fprintf(stdout,"\n");
help_param(PARAMETER_LIST);fprintf(stdout," (show tabs, newlines graphically)\n");
help_param(PARAMETER_REPORT);fprintf(stdout," (min # of lines to report on oper)\n");
help_param(PARAMETER_SCROLL);fprintf(stdout," (# of lines for ^D, ^U)\n");
help_param(PARAMETER_WRAPSCAN);fprintf(stdout," (search wraps around end of file)\n");

			break;

		    case 8:
fprintf(stdout,"About PVIC\n");
fprintf(stdout,"==========\n");
fprintf(stdout,"\n");
fprintf(stdout,"%s\n",VERSION_STRING);
fprintf(stdout,"\n");
fprintf(stdout,"PVIC is a public domain Portable VI Clone, derived from\n");
fprintf(stdout,"STEVIE 3.69B.\n");
			break;
		}

		if(current_help_page!=0)
		{
			goto_screen_pos(termcap_lines-3,termcap_columns-30);
			fprintf(stdout,"Press '0' for index");
		}
		goto_screen_pos(termcap_lines-2,termcap_columns-30);
		fprintf(stdout,"Press ESC to quit");
		goto_screen_pos(termcap_lines-1,termcap_columns-30);
		fprintf(stdout,"Other keys navigate screens");

		if(get_next_help_page(&current_help_page)<0)
		{
			termcap_out(termcap_cursor_visible);
			return 0;
		}
	}

}



/*      help_param (n)
 *      Put the help info for param #n into the buffer.
 */
void help_param (p)
int p;
{
	fprintf(stdout, "        %6s  %-10s  ",
		params[p].shortname, params[p].fullname);
	if(params[p].flags & NUMERIC_PARAMETER)
		fprintf(stdout, "%-3d", params[p].value);
	else 
	{
		if(params[p].value)fprintf(stdout,"yes");
		else fprintf(stdout,"no ");
	}
}

/* Get keystroke and return instructions on what to do next.
 * Argument is current help screen.
 * Return value is target help screen, or -1 to quit help.
 */


int get_next_help_page(current_help_page)
int *current_help_page;
{
	int c;

	/* Now get keystrokes till we get a valid one */
	for(;;)
	{
		c=get_char_from_input_buffer();
		switch(c)
		{
		    /* Next screen. */
		    case ' ':       
		    case CTRL_I:
		    case CTRL_J:    
		    case CTRL_M:    
		    case '+':
		    case 'f':       
		    case CTRL_F:
		    case CTRL_D:    
		    case CTRL_Y:
		    case 'n':       
		    case 'N':     
		    case CTRL_N:
		    case 'j':
			if(*current_help_page<LAST_HELP_PAGE)
			{
				(*current_help_page)++;
				return *current_help_page;
			}
			break;

		    /* Previous screen. */
		    case CTRL_H:    
		    case '-':
		    case 'b':       
		    case CTRL_B:
		    case CTRL_U: 
		    case CTRL_E:
		    case 'p':       
		    case 'P':     
		    case CTRL_P:
		    case 'k':
			if(*current_help_page>0)
			{
				(*current_help_page)--;
				return *current_help_page;
			}
			break;

                    /* Redraw. */
                    case CTRL_L:
                        return *current_help_page;

		    /* Quit help. */
		    case ESC:
		    case 'Q':
		    case 'q':
		    case 'X':
		    case 'x':
			return -1;

		    case 'Z':
		    	if(get_char_from_input_buffer()=='Z')return -1;
			break;

		    /* Page number or invalid key. */
		    default:
			if(c>='0' && c<=LAST_HELP_PAGE+'0')
			{
				*current_help_page=c-'0';
				return *current_help_page;
			}
			break;
		}
	}

	return *current_help_page;
}


