#include <stdio.h>
#include "pvic.h"
#include "locdefs.h"


/* Sound a beep. */
void beep()
{
	if(PARAMETER_VALUE(PARAMETER_ERRORBELLS))
		termcap_out(termcap_bell);
	fflush(stdout);
}


/* Loop for a while. */
void loop_n_seconds(seconds)
int seconds;
{
	long t;

	fflush(stdout);

	t=time(NULL);
	while(time(NULL)<t+1+seconds);
}



/* Initialization of PVIC. */
void pvic_init()
{
	init_termcap();
	current_lines=PARAMETER_VALUE(PARAMETER_LINES)=termcap_lines;
	current_columns=termcap_columns;
	local_init();
	local_init_terminal_io();
	termcap_out(termcap_init_terminal);
	init_translate_table();
}


/* Exit PVIC. Return return_value to the operating system. */
void pvic_exit(return_value)
int return_value;
{
	termcap_out(termcap_deinit_terminal);
	local_deinit_terminal_io();
	local_deinit();
	exit(return_value);
}





/* Execute cmd as child process. If cmd is NULL a shell is executed. */
void do_shell(cmd)
char	*cmd;
{
	if (cmd == NULL) cmd = LOCAL_SHELL;

        local_deinit_terminal_io();
	system(cmd);
        local_init_terminal_io();
	wait_return();
}





/* Put the cursor on possition r,c. */
void goto_screen_pos(r, c)             /* Move cursor to r'ow & c'olumn */
register int    r, c;
{

	termcap_out(termcap_cursor_address,r,c);
	fflush(stdout);
	return;

}



/* Get a pointer to the first character in string which is equal
to chr. If there is no such character, NULL is returned. */
char *get_pointer_to_chr_in_string(string,chr)
char string[];
char chr;
{
	int i;

	for(i=0;string[i]!='\0';i++)if(string[i]==chr)return &string[i];
	return NULL;
}



/* Get the offset in s1 of the first character which also appears in s2. */ 
int get_offset_of_chr_in_s1_matching_chr_in_s2(s1,s2)
char s1[];
char s2[];
{
	int i,j;

	for(i=0;s1[i]!=0;i++)
	{
		for(j=0;s2[j]!='\0';j++)if(s1[i]==s2[j])return i;
	}
	return i;
}



/* Convert c to lower case. */
char to_lower(c)
char c;
{
        if('A'<=c && c<='Z')return c-'A'+'a';
        else return c;
}



/* Convert c to upper case. */
char to_upper(c)
char c;
{
        if('a'<=c && c<='z')return c-'a'+'A';
        else return c;
}



/* Return non-zero if c is an upper case character. */
int is_upper(c)
char c;
{
        if('A'<=c && c<='Z')return 1;
        else return 0;
}



/* Return non-zero if c is an lower case character. */
int is_lower(c)
char c;
{
        if('a'<=c && c<='z')return 1;
        else return 0;
}



/* Return non-zero if c is an alphabetic character. */
int is_alpha(c)
char c;
{
        if('A'<=c && c<='Z' || 'a'<=c && c<='z')return 1;
        else return 0;
}




/* Return non-zero if c is a white space character. */
int is_space(c)
char c;
{
        if(c==' ' || c=='\t' || c=='\n' || c=='\r' || c=='\f')return 1;
        else return 0;
}



/* Return non-zero if c is a digit. */
int is_digit(c)
char c;
{
        if('0'<=c && c<='9')return 1;
        else return 0;
}



/* Copy the file named old_name to new_name, and delete old_name. */
void rename_file(old_name,new_name)
char *old_name,*new_name;
{
        FILE *old_fp,*new_fp;
        char buffer[1024];
        int n;

	/* Open old file. If there is no old file, there is nothing to
	do. */
        if( (old_fp=fopen(old_name,"r"))==NULL )return;

	/* Open new file. */
        if( (new_fp=fopen(new_name,"w"))!=NULL )
        {
		/* Copy file. */
                while(!feof(old_fp))
                {
                       n=fread(buffer,1,1024,old_fp);
                       fwrite(buffer,1,n,new_fp);
                }

		/* Close new file. */
                fclose(new_fp);
        }

	/* Close old file. */
        close(old_fp);

	/* Delete old file. */
        unlink(old_name);

	/* Ready. */
        return;
}
