#include "oscom.h"

char *SwitchLogic(int state)
{
	static char logicstate[4];

	switch(state) {
		case 0:
			strcpy(logicstate, "Off");
			break;

		case 1:
			strcpy(logicstate, "On");
			break;
	}
	return(logicstate);
}


struct table stopBitTable[] = {
	{"1", 		ONESTOP,	'1',	"1. 1 Stop bit"},
	{"2",		TWOSTOP,	'2',	"2. 2 Stop bits"},
	{"1.5",		ONE_5STOP,	'3',	"3. 1.5 Stop bits"},
	{NULL,		-1,			0,		NULL}
};

#define	STOPBIT_DEFAULT	0		/* default if bad code passed */

char *CodeToStopBits(int code)
{
	struct table *p;

	for (p = stopBitTable; p->string != NULL; p++) {
		if (code == p->value) {
			return(p->string);
		}
	}

	/* default */
	return(stopBitTable[STOPBIT_DEFAULT].string);
}


int StopBitsToCode(char *stopbits)
{
	struct table *p;

	for (p = stopBitTable; p->string != NULL; p++) {
		if (strcmp(stopbits, p->string) == 0) {
			return(p->value);
		}
	}

	/* default */
	return(stopBitTable[STOPBIT_DEFAULT].value);
}


struct table wordSizeTable[] = {
	{"5", 		WORDSIZE5,		'5',	"5. 5 Bits"},
	{"6",		WORDSIZE6,		'6',	"6. 6 Bits"},
	{"7",		WORDSIZE7,		'7',	"7. 7 Bits"},
	{"8",		WORDSIZE8,		'8',	"8. 8 Bits"},
	{NULL,		-1,				0,		NULL}
};

#define	WORDSIZE_DEFAULT	3	/* default if bad code passed */

char *CodeToWordSize(int code)
{
	struct table *p;

	for (p = wordSizeTable; p->string != NULL; p++) {
		if (code == p->value) {
			return(p->string);
		}
	}

	/* default */
	return(wordSizeTable[WORDSIZE_DEFAULT].string);
}


int WordSizeToCode(char *wordsize)
{
	struct table *p;

	for (p = wordSizeTable; p->string != NULL; p++) {
		if (strcmp(wordsize, p->string) == 0) {
			return(p->value);
		}
	}

	/* default */
	return(wordSizeTable[WORDSIZE_DEFAULT].value);
}


struct table baudTable[] = {
	{"50", 		BAUD50,		'1',	"1. 50 Baud"},
	{"75",		BAUD75,		'2',	"2. 75 Baud"},
	{"110",		BAUD110,	'3',	"3. 110 Baud"},
	{"134.5",	BAUD134_5,	'4',	"4. 134.5 Baud"},
	{"150",		BAUD150,	'5',	"5. 150 Baud"},
	{"300",		BAUD300,	'6',	"6. 300 Baud"},
	{"600",		BAUD600,	'7',	"7. 600 Baud"},
	{"1200",	BAUD1200,	'8',	"8. 1200 Baud"},
	{"1800",	BAUD1800,	'9',	"9. 1800 Baud"},
	{"2000",	BAUD2000,	'A',	"A. 2000 Baud"},
	{"2400",	BAUD2400,	'B',	"B. 2400 Baud"},
	{"3600",	BAUD3600,	'C',	"C. 3600 Baud"},
	{"4800",	BAUD4800,	'D',	"D. 4800 Baud"},
	{"7200",	BAUD7200,	'E',	"E. 7200 Baud"},
	{"9600",	BAUD9600,	'F',	"F. 9600 Baud"},
	{"19200",	BAUD19200,	'G',	"G. 19200 Baud"},
	{"31250",	BAUD31250,	'H',	"H. 31250 Baud"},
	{"38400",	BAUD38400,	'I',	"I. 38400 Baud"},
	{"56000",	BAUD56000,	'J',	"J. 56000 Baud"},
	{"57600",	BAUD57600,	'K',	"K. 57600 Baud"},
	{"64000",	BAUD64000,	'L',	"L. 64000 Baud"},
	{"115200",	BAUD115200,	'M',	"M. 115200 Baud"},
	{NULL,		-1,			0,		NULL}
};

#define	BAUD_DEFAULT	14		/* default if bad code passed */

char *CodeToBaud(int code)
{
	struct table *p;

	for (p = baudTable; p->string != NULL; p++) {
		if (code == p->value) {
			return(p->string);
		}
	}

	/* default */
	return(baudTable[BAUD_DEFAULT].string);
}


int BaudToCode(char *baud)
{
	struct table *p;

	for (p = baudTable; p->string != NULL; p++) {
		if (strcmp(baud, p->string) == 0) {
			return(p->value);
		}
	}

	/* default */
	return(baudTable[BAUD_DEFAULT].value);
}


struct table parityTable[] = {
	{"NONE",	NOPARITY,		'1',	"1. None"},
	{"ODD",		ODDPARITY,		'2',	"2. Odd"},
	{"EVEN",	EVENPARITY,		'3',	"3. Even"},
	{"MARK",	MARKPARITY,		'4',	"4. Mark"},
	{"SPACE",	SPACEPARITY,	'5',	"5. Space"},
	{NULL,		-1,				0,		NULL}
};

#define	PARITY_DEFAULT	0		/* default if bad code passed */

int ParityToCode(char *parity)
{
	struct table *p;

	for (p = parityTable; p->string != NULL; p++) {
		if (strucmp(parity, p->string) == 0) {
			return(p->value);
		}
	}

	/* default */
	return(parityTable[PARITY_DEFAULT].value);
}


char *CodeToParity(int code)
{
	struct table *p;

	for (p = parityTable; p->string != NULL; p++) {
		if (code == p->value) {
			return(p->string);
		}
	}

	/* default */
	return(parityTable[PARITY_DEFAULT].string);
}



