#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* strucmp - string compare w/ case masking
		compares two strings regardless of their case and returns:
			-1 	str1 < str2
			 0	str1 = str2
			 1  str1 > str2

NOTE: strucmp() will replace an occurence of \n (carriage return) with a NULL!
	  this allows you to pass in strings that are carriage return-terminated
	  without worry, but be cautious if that's NOT what you want to do.
*/

int strucmp(char *str1, char *str2)
{
	int pl1, pl2;
	char *p;

	if ((p = strchr(str1,'\n')) != NULL) *p ='\0';
	if ((p = strchr(str2,'\n')) != NULL) *p ='\0';
	pl1 = strlen(str1);
	pl2 = strlen(str2);
	if (pl2 < pl1) pl1 = pl2;
	while ((pl1 > 0) && (toupper(*str1) == toupper(*str2))) {
		--pl1;
		++str1;
		++str2;
	}
	if (toupper(*str1) == toupper(*str2)) return(0);
	if (toupper(*str1) > toupper(*str2)) return(1);
	return(-1);
}


/* struncmp - string compare w/ case masking on a set number of characters.
		compares two strings regardless of their case up to 'n' characters
		and returns:
			-1 	str1 < str2
			 0	str1 = str2
			 1  str1 > str2

NOTE: struncmp() will replace an occurence of \n (carriage return) with a NULL!
	  this allows you to pass in strings that are carriage return-terminated
	  without worry, but be cautious if that's NOT what you want to do.
*/

int struncmp(char *str1, char *str2, int length)
{
	int pl1, pl2;
	char *p;

	if ((p = strchr(str1,'\n')) != NULL) *p ='\0';
	if ((p = strchr(str2,'\n')) != NULL) *p ='\0';
	pl1 = pl2 = length;
	while ((pl1 > 1) && (toupper(*str1) == toupper(*str2))) {
		--pl1;
		++str1;
		++str2;
	}
	if (toupper(*str1) == toupper(*str2)) return(0);
	if (toupper(*str1) > toupper(*str2)) return(1);
	return(-1);
}
