#include <stdio.h>
#include <stdlib.h>
#include <types.h>
#include <modes.h>
#include <string.h>
#include <ctype.h>
#include <sg_codes.h>
#include <scf.h>

#ifdef MAIN
#define global
#else
#define global extern
#endif

typedef struct modeminfo {
	char modemport[32];
	int baud;
	int wordsize;
	int parity;
	int stopbits;
	int echo;
	int linefeeds;
	char modeminit[128];
} modemInfo, *ModemInfo;


struct table {
	char	 *string;
	u_int32	value;
	char	key;  
	char	*menuStr;
};


global modemInfo mparam;	/* modem information structure */
global char initfile[64];	/* OSCom initialization file */
global path_id modem;  		/* modem path */
global u_int32 state;		/* program state */
global scf_path_opts okbuf, kbuf, ombuf, mbuf; /* path option buffers */
global char metachar;		/* meta character */
 
#define	DEFAULTPORT	"/T1"
#define PORTVAR		"MODEM"
#define	CONFIGVAR	"HOME"
#define DEFAULTCON	"/dd/sys"
#define INITFILE	".oscom.init"

#define	DELIM_CHAR	'%'

#define MODEMSIG	1000
#define	KEYSIG		1001
#define SUCCESS		1
#define FAILURE		0
#define COMMAND		1

/* Function prototypes */
#include "proto.h"