#define MAIN
#include "oscom.h"

#include <signal.h>
#include <cglob.h>

#define BUFFSIZE	1024
char buff[BUFFSIZE];

extern struct table stopBitTable[];
extern struct table wordSizeTable[];
extern struct table baudTable[];
extern struct table parityTable[];

void SigHandler(signal_code sigcode)
{
	switch (sigcode)
	{
	}
	_os_rte();
}


error_code main(int argc, char **argv)
{
	metachar = 26;	/* ^Z */
	state = !COMMAND;
	setup();	/* setup */
	_os_intercept(SigHandler, _glob_data);
	_os_ss_sendsig(modem, MODEMSIG);
	_os_ss_sendsig(0, KEYSIG);

	/* write modem initialization string */
	{
		u_int32 len;

		len = strlen(mparam.modeminit);
		_os_write(modem, mparam.modeminit, &len);
		len = 1;
		_os_write(modem, "\n", &len);
	}

	/* main loop */
	for (;;) {
		u_int32 t;
		signal_code s;
		u_int32 len, modem_ready, key_ready;

		_os_sigmask(1);
		_os_ss_sendsig(modem, MODEMSIG);	/* set modem signal */
		_os_ss_sendsig(0, KEYSIG);				/* set keyboard signal */
		t = 0;
		_os_sleep(&t, &s);

		/* is it the modem? */
		if (_os_gs_ready(modem, &modem_ready) == 0) {
			len = modem_ready > BUFFSIZE ? BUFFSIZE : modem_ready;

			_os_read(modem, buff, &modem_ready);
			_os_write(1, buff, &modem_ready);
			_os_sigmask(1);
			_os_ss_sendsig(modem, MODEMSIG);	/* set modem signal */
		}

		/* is it the keyboard? */
		while (_os_gs_ready(0, &key_ready) == 0) {
			service_keyboard(0);
			_os_sigmask(1);
			_os_ss_sendsig(0, KEYSIG);			/* set keyboard signal */
		}
	}

	exit(0);
}


void modemraw(path_id path, scf_path_opts *buf)
{
	buf->pd_echo = buf->pd_eorch = buf->pd_eofch = buf->pd_bellch = 0;
	buf->pd_bspch = buf->pd_backsp = buf->pd_alf = 0;
	buf->pd_pause = 0;
	_os_ss_popt(path, sizeof(*buf), buf);
}


void keyraw(path_id path, scf_path_opts *buf)
{
	buf->pd_echo = buf->pd_eofch = buf->pd_bellch = 0;
	buf->pd_bspch = buf->pd_backsp;
	buf->pd_pause = 0;
	_os_ss_popt(path, sizeof(*buf), buf);
}


void cleanup(char *message)
{
	_os_ss_popt(0, sizeof(okbuf), &okbuf);
	_os_ss_popt(modem, sizeof(ombuf), &ombuf);
	if (message != NULL) {
		printf("%s\n", message);
	}
	exit(0);
}

	
void SelectBaud(void)
{
	char c;
	struct table *p;
	int status = 1;
	u_int32 len;

	CR();
	for (p = baudTable; p->string != NULL; p++) {
		printf("%c %s\n", DELIM_CHAR, p->menuStr);
	}
	printf("%c Any other key to abort\n", DELIM_CHAR);
	printf("%c ? ", DELIM_CHAR);
	fflush(stdout);

	len = 1;
	_os_read(0, &c, &len);

	for (p = baudTable; p->string != NULL; p++) {
		if (p->key == toupper(c)) {
			mparam.baud = BaudToCode(p->string);
			break;
		}
	}

	if (p->string == NULL) {
		printf("\n");
		return;
	}

	printf("%c\n", c);
	return;
}

	
void SelectParity(void)
{
	char c;
	struct table *p;
	int status = 1;
	u_int32 len;

	CR();
	for (p = parityTable; p->string != NULL; p++) {
		printf("%c %s\n", DELIM_CHAR, p->menuStr);
	}
	printf("%c Any other key to abort\n", DELIM_CHAR);
	printf("%c ? ", DELIM_CHAR);
	fflush(stdout);

	len = 1;
	_os_read(0, &c, &len);

	for (p = parityTable; p->string != NULL; p++) {
		if (p->key == toupper(c)) {
			mparam.parity = ParityToCode(p->string);
			break;
		}
	}

	if (p->string == NULL) {
		printf("\n");
		return;
	}

	printf("%c\n", c);
	return;
}


void SelectWordSize(void)
{
	char c;
	struct table *p;
	int status = 1;
	u_int32 len;

	CR();
	for (p = wordSizeTable; p->string != NULL; p++) {
		printf("%c %s\n", DELIM_CHAR, p->menuStr);
	}
	printf("%c Any other key to abort\n", DELIM_CHAR);
	printf("%c ? ", DELIM_CHAR);
	fflush(stdout);

	len = 1;
	_os_read(0, &c, &len);

	for (p = wordSizeTable; p->string != NULL; p++) {
		if (p->key == toupper(c)) {
			mparam.wordsize = WordSizeToCode(p->string);
			break;
		}
	}

	if (p->string == NULL) {
		printf("\n");
		return;
	}

	printf("%c\n", c);
	return;
}


void SelectStopBits(void)
{
	char c;
	struct table *p;
	int status = 1;
	u_int32 len;

	CR();
	for (p = stopBitTable; p->string != NULL; p++) {
		printf("%c %s\n", DELIM_CHAR, p->menuStr);
	}
	printf("%c Any other key to abort\n", DELIM_CHAR);
	printf("%c ? ", DELIM_CHAR);
	fflush(stdout);

	len = 1;
	_os_read(0, &c, &len);

	for (p = stopBitTable; p->string != NULL; p++) {
		if (p->key == toupper(c)) {
			mparam.stopbits = StopBitsToCode(p->string);
			break;
		}
	}

	if (p->string == NULL) {
		printf("\n");
		return;
	}

	printf("%c\n", c);
	return;
}


char *helpMsg[] = {
	"",
	"OSCom Keyboard Commands:",
	" <.>        show modem parameters",
	" <b>        set baud rate",
	" <p>        set parity",
	" <q>        exit OSCom",
	" <r>        return to terminal mode",
	" <s>        set stop bits",
	" <w>        set wordsize",
	" <$>        fork OS-9 Shell",
	" </>        write current configuration",
	" <?>        show help",
	"",
	NULL
};

void ShowHelp(void)
{
	char **p;

	for (p = helpMsg; *p != NULL; p++) {
		printf("%c %s\n", DELIM_CHAR, *p);
	}
	return;
}


void service_keyboard(path_id path)
{
	u_int32 len;
	char c;

	len = 1;
	_os_read(path, &c, &len);

	if (mparam.echo == 1) {
		_os_write(1, &c, &len);
	}

	if (state != COMMAND) {
		/* check if this key is the command character */
		if (c == metachar) {
			state = COMMAND;
			CR();
			printf("%c OSCom: ", DELIM_CHAR);
			fflush(stdout);
		} else {
			/* write character to modem and return */
			len = 1;
			_os_write(modem, &c, &len);
		}
		return;
	} else {
		switch (c)
		{
			case 'b':
			case 'B':
				printf("%c\n", c);
				SelectBaud();
				SetModem();
				break;

			case '?':
				printf("%c\n", c);
				ShowHelp();
				break;

			case 'w':
			case 'W':
				printf("%c\n", c);
				SelectWordSize();
				SetModem();
				break;

			case 'p':
			case 'P':
				printf("%c\n", c);
				SelectParity();
				SetModem();
				break;

			case 'r':
			case 'R':
				printf("%c\n", c);
				break;

			case 's':
			case 'S':
				printf("%c\n", c);
				SelectStopBits();
				SetModem();
				break;

			case 'q':
			case 'Q':
				cleanup("exiting");
				break;

			case '.' :
				printf("%c\n", c);
				ShowParams();
				break;

			case '$' :
				ForkShell();
				break;

			case '/':
				printf("Writing configuration...");
				fflush(stdout);
				WriteOptions();
				printf(" Done!\n");
				break;

			default:	/* unknown command */
				printf("\x7Unknown command '%c'\n", c);
				fflush(stdout);
		}
	}
	state = !COMMAND;
	return;
}


void CR(void)
{
	printf("%c\n", DELIM_CHAR);
	return;
}
