***
* MC146818/DS1287 RTC Clock module part 2
* COCO3 Level 2 OS-9
*
* Written by Bruce Isted
*
* History:
*   Edition 1
*     88/10/06  version 1 completed                             BRI
*   Edition 2
*     88/11/17  shift D.Tick & exit if UIP (not wait up to
*               2228 uS for completion), general clean up       BRI
*   Edition 3
*     88/11/26  re-wrote clock access to eliminate repeated
*               subroutine calls to increase speed.             BRI

 nam Clock2
 ttl COCO3 Clock module part 2

 ifp1
 use /dd/defs/defsfile
 endc

ClkAddr equ $FF72 clock base address
Edtn equ 3
Vrsn equ 1
SpeedClk equ $20 32.768 KHz, rate=0
StartClk equ $06 binary, 24 Hour, DST disabled
StopClk equ $86 bit 7 set stops clock to allow setting time

* MC146818/DS1287 clock register map:
 org $00
CRegSec rmb $01 seconds register
CRegSAl rmb $01 seconds alarm register
CRegMin rmb $01 minutes register
CRegMAl rmb $01 minutes alarm register
CRegHour rmb $01 hours register
CRegHAl rmb $01 hours alarm register
CRegDayW rmb $01 day of week register
CRegDayM rmb $01 day of month register
CRegMnth rmb $01 months register
CRegYear rmb $01 years register
CRegA rmb $01 bits 7-0: UIP (read only); DV2-DV0; RS3-RS0
CRegB rmb $01 bits 7-0: SET; PIE; AIE; UIE; SQWE; DM; 24/12; DSE
CRegC rmb $01 bits 7-0: IRQF; PF; AF; UF; Unused3-Unused0
CRegD rmb $01 bits 7-0: VRT; Unused6-Unused0
CSRAM rmb $40-. CMOS static RAM

 mod CSize,CNam,Systm+Objct,ReEnt+Vrsn,Entry,ClkAddr

CNam fcs "Clock2"
 fcb Edtn edition byte

Entry clrb *clock hardware initialization
 rts *nothing to do
 nop maintain 3 byte entry table spacing
 bra CGetT get hardware time
 nop save a couple cycles with short branch above...
 bra CSetT set hardware time
* last NOP not required for 3 byte entry table spacing
* nop save a couple cycles with short branch above... 

UIPShift ldb #30 ticks in 1/2 second
 stb <D.Tick move next RTC read as far as possible from RTC update
 bra CGExit clean up & return

CGetT clrb no error for return...
 pshs cc,d,x,y,u save regs which will be altered
 ldx <M$Mem,pc get clock base address from fake memory requirement
 lda #CRegA RTC Update In Progress status register
 sta ,x generate address strobe
 lda 1,x get UIP status
 bmi UIPShift RTC Update In Progress (1:449 chance), go shift D.Tick
 leay <GetTable,pc point [Y] to RTC "get" register info table
 ldu #D.Time point [U] to time variables in DP
 ldb #(GetEnd-GetTable)/2 get loop count
 stb R$B,s save counter to B reg on stack
CGetLoop ldd ,y++ get clock register info from table
 sta ,x generate clock address strobe
 lda 1,x get clock data
 sta b,u save data to D.Time variables
 dec R$B,s done all D.Time vars?
 bne CGetLoop no, go do next...
CGExit puls cc,d,x,y,u,pc recover regs, return to caller

CSetT clrb no error for return...
 pshs cc,d,x,y,u save regs which will be altered
 ldx <M$Mem,pc get clock base address from fake memory requirement
 leay <SetTable,pc point [Y] to RTC register set table
 ldu #D.Time point [U] to time variables in DP
 ldb #(SetEnd-SetTable)/2 get loop count
 stb R$B,s save counter to B reg on stack
 orcc #IntMasks disable IRQs while setting clock
CSetLoop ldd ,y++ get clock set data
 bmi CRegSet [A] Sign bit set, go save [B] to clock register
 ldb b,u get system time from D.Time variables
CRegSet anda #^Sign clear sign bit
 std ,x generate clock address strobe, store data
 dec R$B,s done all clock regs?
 bne CSetLoop no, go do next...
 puls cc,d,x,y,u,pc restore altered regs, return to caller

SetTable equ *
 fcb Sign+CRegB,StopClk
 fcb Sign+CRegA,SpeedClk
GetTable equ *
 fcb CRegYear,D.Year-D.Time
 fcb CRegMnth,D.Month-D.Time
 fcb CRegDayM,D.Day-D.Time
 fcb CRegHour,D.Hour-D.Time
 fcb CRegMin,D.Min-D.Time
 fcb CRegSec,D.Sec-D.Time
GetEnd equ *
 fcb Sign+CRegDayW,$00
 fcb Sign+CRegHAl,$00
 fcb Sign+CRegMAl,$00
 fcb Sign+CRegSAl,$00
 fcb Sign+CRegB,StartClk
SetEnd equ *

 emod
CSize equ *
 end


