 nam LII Clock
 ttl CoCo3 Clock Module- Part 1

 ifp1
 use /dd/defs/defsfile
 endc

*******************************************************
* 01/01/87 Original version           KKD
* 05/22/87 Fixed labels.              KDM
* 09/29/88 break into 2 modules       KKD
* 10/05/88 fixed GIME IRQ toggle      BRI
* 11/12/88 changed to TSlice = 3      BRI
* 11/16/88 changed to TSlice = 2      BRI
* 12/09/88 added F$TPS, chopped size  BRI
*******************************************************

 mod len,name,systm+objct,reent+1,init,0

*******************************************************
IrqEnR equ $FF92
ALARMTIM EQU $100F
ALARMTSK EQU $1015
BELLVCTR EQU $1017
xFF00 equ $FF00

D.GPoll equ $00B4 *** new D.xx for GIME reset!
D.Clock2 equ $00B6 *** new D.xx for Clock2!

F$TPS equ $25 *** new call returns system ticks per second
TkPerSec equ 60 ticks per second

*******************************************************

name fcs "Clock"
 fcb 12 second prelim version

* Svc Calls:

newsvc
 fcb F$Time
 fdb f.time-*-2
********* new
 fcb F$STime
 fdb f.stime-*-2

 fcb F$TPS *** new BRI ***
 fdb f.tps-*-2 *** new BRI ***

 fcb F$Virq
 fdb f.virq-*-2
 FCB F$ALARM
 FDB F.ALARM-*-2
 fcb $80

*---------------------------------
* IRQ Handler:
* Note NO STACK HERE!

irqchek
 lda >IRQEnR get GIME irq status
 ora <D.IRQS save it
 sta <D.IRQS
 bita #$08 was it VBORD irq?
 bne L0039 ..yes, increment time
********* new
* ldd <D.Poll else set D.SvcIRQ to polling
 LDD <D.GPoll set D.SvcIRQ to GIME polling

 bra L0088 ..and jmp D.XIRQ

* WAS VBORD IRQ so increment Time Vars:

L0039
 anda #^$08 drop vbord irq
 sta <D.IRQS
 dec <D.Tick ticks-1
 bne L0086 ..skip if not yet
 lda #TkPerSec reset ticks to start of second
 sta <D.Tick (also F$Alarm check flag!!)
L0086
 ldd <D.VIRQ set alternate IRQ
L0088
 std <D.SvcIrq for system state
 jmp [D.XIRQ] and finish irq handling.

*------------------------------
* VIRQ Handler:

virqchek
 clr ,-s clear found flag
 lda <D.IRQS check for other irqs
 bita #$37 any others?
 beq L0099 ..no
 inc ,s yes, set flag
L0099
 ldy <D.CLTb point to virqtable
 bra L00B7 ..begin search

* Main Loop:

L009E
 ldd ,x get virq counter
 subd #$0001 decrement
 bne L00B5 ..skip if not ready
 lda #$01 else set
 sta ,s  found flag
 lda $04,x check kill flag
 bne L00AF ..nope
 bsr L010C ..yep, delete entry
L00AF
 ora #$01 set software irq bit
 sta $04,x
 ldd $02,x reset counter
L00B5
 std ,x

L00B7
 ldx ,y++ last entry?
 bne L009E ..no
 lda ,s+ else any found?
 beq L00C5 ..no
L00BF
 jsr [D.Poll] found= do IOMan poll
 bcc L00BF ..until done
 lbsr GFix ************** should reset GIME now??

L00C5
 jsr [D.AltIRQ] poll keyboard

********* new
* ldd #9
* lbsr call2 do irq in clock2
 ldb #TkPerSec
 cmpb <D.Tick new second starting?
 bne L0108 ..not yet
 ldd #3 gettime vector
 lbsr call2

 LDD ALARMTSK alarm set?
 BLE L0108 ..no
* LDD #$0500+TkPerSec A=timevar cnt, B=ticks per second
* CMPB D.TICK second up?
* BNE L0108 ..no
 lda #$05 <<<
 LDY #D.YEAR point to time
 LDX #ALARMTIM and alarm setting

L00DC
 LDB ,Y+ get alarm time
 CMPB ,X+ same as realtime?
 BNE L0108 ..no
 DECA yes,cnt-1
 BNE L00DC ..loop

 LDD ALARMTSK get id,signal
 CMPD #1 terminal alarm?
 BEQ L00F3 ..yes
 OS9 F$SEND else send signal
 BRA L00F9 ..

L00F3
 LDB ,Y get seconds
 ANDB #$F0 0-15?
 BEQ L0101 ..yes

L00F9
 LDD #$FFFF reset alarm
 STD ALARMTSK to no entry
 BRA L0108 ..

L0101
 LDX BELLVCTR point to CC3IO bell
 BEQ L0108 ..none
 JSR ,X do a Bell

L0108 jmp [D.Clock] continue w/multitasking

*--------------------------
* delete virq entry:

L010C
 pshs x,y save regs
L010E
 ldx ,y++ move entries
 stx -$04,y  up in table
 bne L010E until last one (0000)
 puls x,y
 leay -$02,y reset table ptr
 rts

*---------------------------------
f.virq
 pshs cc save irq status
 orcc #IntMasks stop irq/firqs
 ldy <D.CLTb point to virq table
 ldx <D.Init and Init module
 ldb $0C,x get max devices
 ldx R$X,u get X parameter
 beq L0147 ..remove entry
 tst ,y first entry empty?
 beq L013B ..yes
 subb #$02 else point to last
 aslb entry in table
 leay b,y
 tst ,y empty?
 bne L0157 ..no, error

L0135
 tst ,--y found spot?
 beq L0135 ..no, back up
 leay $02,y yes, reset ptr

L013B
 ldx R$Y,u get packet ptr
 stx ,y set entry
 ldd R$D,u get first count *** changed BRI ***
 std ,x set it *** changed BRI ***
 bra L0153 return okay.

L0147
 ldx R$Y,u get entry
L0149
 tst ,y return if
 beq L0153 no entries
 cmpx ,y++ else search for
 bne L0149 this entry
 bsr L010C then remove it
L0153
 puls cc restore intrpt status
 clrb ok
 rts .

L0157
 puls cc retrieve CC reg
 comb set error bit
 ldb #E$Poll 'Polling Table Full'
 rts .


F.ALARM
 LDX #ALARMTIM point to alarm setting
 LDD R$D,U was call = clear?
 BNE L0167 ..no
 STD ALARMTSK-ALARMTIM,X yes, clear id,signal
 RTS end.

L0167
 TSTA id present?
 BNE L0170 ..yes
 CMPD #1 else is it set term alarm?
 BNE L0184 ..no

L0170
 STD ALARMTSK-ALARMTIM,X set term alarm
 LDX D.PROC get process *** changed BRI ***
 LDA P$TASK,X task number *** changed BRI ***
 LDB D.SYSTSK destination is system map
 LDX R$X,U source packet
 LDU #ALARMTIM destination packet
 LDY #D.SEC-D.YEAR count
 BRA L01A4 ..move alarm settings

L0184
 CMPD #2 was call = return setting?
 BNE L0190 ..no
 LDD ALARMTSK-ALARMTIM,X get id,sig
 STD R$D,U return them to user
 BRA L0197 and return alarm setting.

L0190
 COMB error
 LDB #E$IllArg <<< fixed
 RTS 'Illegal Argument'

*---------------------------------
* F$Time
*  Note that time is already here
*  from once/second clock polling!

f.time
 ldx #D.Time point to time packet Moved ****

L0197
 ldy <D.Proc user process
 ldb P$Task,y to user map
 lda <D.SysTsk from sys map
 ldu R$X,u destination=user(X)
 ldy #6 six bytes long

L01A4
 os9 f$move move time data
 rts end.

*--------------------------------- new!
* F$STime

f.stime
 ldx <D.Proc calling process *** changed BRI ***
 lda P$Task,x from user map *** changed BRI ***
 ldb D.SysTsk to system map
 ldx R$X,u packet
 ldu #D.Time dest
 ldy #6 number bytes
 os9 F$Move get them
 ldd #06 do setime in clock2:

*---------------------------------
* CALL CLOCK2: D=offset
call2
 ldx D.Clock2 else update time vars
 jmp d,x do it and rts

*---------------------------------
* NEW GIME irq register reset:
GPoll
 jsr [D.Poll] do regular polling
GFix
 ldb <D.IRQER get enabled bits
 tfr b,a copy it for GIME IRQ re-trigger
 andb #^$01 select GIME IRQ input(s) to toggle
 stb >IRQEnR disable selected GIME input(s)
 sta >IRQEnR trigger GIME again
 rts

*--------------------------------- *** new ***
* get ticks per second:

f.tps
 ldd #TkPerSec number of ticks per second
 std R$D,u save it to caller's reg stack
 clrb no error...
 rts

*---------------------------------
* Clock Init:

init
 pshs cc save intpt status
 lda #TkPerSec sixty ticks/sec
 sta <D.Tick
 lda #$02 two ticks/time slice
 sta <D.TSlice
 sta <D.Slice and first slice
 orcc #IntMasks stop interrupts
 leax >irqchek,pcr set IRQ handler
 stx <D.IRQ
 leax >virqchek,pcr set VIRQ handler
 stx <D.VIRQ

******* new
 LEAX >gpoll,pcr set GIME irq reset
 stx <D.GPoll

 leay >newsvc,pcr insert syscalls
 os9 f$ssvc
 ldx #xFF00 point to PIA0
 clra
 sta $01,x dir register
 sta ,x side A are inputs
 sta $03,x dir register
 coma
 sta $02,x side B outputs
 lda #$34 reset A
 sta $01,x  control reg
 lda #$3C set up irq
 sta $03,x ..from VBORD
 lda $02,x dummy reset
 lda <D.IRQER get GIME IRQ reg
 ora #$08 enable VBorder irqs
 sta <D.IRQER save shadow reg
 sta >IRQEnR set VBorder irqs
************** new
 leax <clok2,pc
 lda #$C1
 os9 F$Link
 bcs err
 sty <D.Clock2 save exec vector
 jsr ,y do init of clock (ignore errs)
 puls cc,pc

err
 ldb #5 "no clock2" err
 jmp [D.Crash] tell user the booterr

clok2 fcs "Clock2"

 emod
len equ *
 end


