#define DEBUG /* Only define when testing */

#include <utime.h>
#include <time.h>
#include <os9.h>

#define F_TIMALM 0x26

unsigned
alarm(seconds)
unsigned seconds;
{
   long clock = time((long *) 0) + (long)seconds;
   struct tm *timeptr;
   struct sgtbuf alarmtime;
   struct registers regs;

   regs.rg_x = &alarmtime;

   if (seconds)
     {
       timeptr = localtime(&clock);
       u2otime(&alarmtime,timeptr);

       regs.rg_b = 1; /* Set Alarm */

       if (_os9(F_TIMALM,&regs) == -1)
          return(-1);

       return(seconds);
     }
   else
     {
       regs.rg_b = 2; /* Return Alarm Settings */

       if (_os9(F_TIMALM,&regs) == -1)
          return(-1);

       if (alarmtime.t_year == (char)0)
         return(0);

       regs.rg_b = 0; /* Clear Alarm */

       if (_os9(F_TIMALM,&regs) == -1)
          return(-1);

       clock = o2utime(&alarmtime) - clock;
       return((unsigned) clock);
     }
}

#ifdef DEBUG
trap(signal)
{
   if (signal == 2)
     {
       printf("\nAlarm aborted with %d seconds left\n",alarm(0));
       exit(0);
     }

   printf("Received signal #%d\n",signal);
   printf("\nTHANKS, that was a rough dream\n");
   exit(0);
}

main(argc,argv)
char *argv[];
{
   int time;

   if (argc < 2)
     {
       printf("Usage: alarm seconds\n");
       printf("       send sigalrm(5) to process after 'seconds' have past.\n");
       exit(0);
     }

   if ((time = atoi(argv[1])) < 0)
     time = 30;

   intercept(trap);

   printf("\nI'm going to sleep for %d seconds\n",time);

   alarm((unsigned)time);

   while (1)
     {
       printf("\nPlease wake me up!\n");
       sleep(60);
     }
}
#endif