* DMode   by Kevin K. Darling
*           updated by Bruce R. Isted
* Disk descriptor utility.
*
* This version will do desc file on disk also.
* 23 Sept 86, 1 Oct 86, 2 Oct 86, 20 Jul 88, 11 Dec 88
* Oversized and kludgy, but works.
* Apologies for lack of comments.
****************
* RBF descriptor utility similar to xmode.
* Use: dmode </devicename> [options]
*      dmode -<filename>   [options]
*       (allows dmode use on a saved desc)
*       (-filename will use data dir for default)
*      dmode -?  will give bit definitions
* If no options given, just returns desc info.
* All numbers must be in HEX.

* dmode
* dmode /h0 cyl=0200 sas=8 ilv=4
* dmode /d0
* dmode -?
* dmode -/d1/modules/d2.dd cyl=0028

 ifp1
 use /dd/defs/defsfile use defsfile
 endc

BuffSize equ 10 max. CHAR string length
DescSize equ $50 maximum descripter size
Edtn equ 9
MinSize equ $30 minimum descriptor size

* conditional assembly flags
CCDisk equ true  RS CCDisk messages, options
OptsHelp equ false extended option help message

 ifeq CCDisk-true
namsiz equ 2 max. module name size
TablOpts equ 16 number of table entries
 else
namsiz equ 3 max. module name size
TablOpts equ 19 number of table entries
 endc

 org 0
Count rmb 1 number of option bytes
dataptr rmb 2 current option ptr
dsize   rmb 2 desc size
hexin   rmb 2 2 byte hex number
module  rmb 2 desc address
parmptr rmb 2 next name dataptr
path    rmb 1 file path
txtptr  rmb 2 option name ptr
buffer  rmb BuffSize miscellaneous output buffer
desc    rmb DescSize dev desc copy
stack   rmb 256
params  rmb 256
msiz equ .

 mod size,name,$11,$83,entry,msiz

****************
name fcs "DMode"
 fcb Edtn edition number

equal fcc "="

 ifeq OptsHelp-true
helpmsg
 fcb C$LF
 fcc "The NAM option accepts only a legal OS-9 module name."
 fcb C$LF
 fcc "The MGR and DDR options can be inspected but can not be changed."
 fcb C$LF
 fcc "All other options require hex numbers (0 through FFFF)."
 fcb C$LF
 fcc "EG:  Dmode /D0 drv=0 nam=RS stp=3 hpn=07 hpa=FF40 cyl=50 dns=03"
 fcb C$LF,C$LF
 fcc "nam  Device Descriptor Name             "
 fcc "mgr  File Manager Name"
 fcb C$LF
 fcc "ddr  Device Driver Name                 "
 fcc "hpn  Hardware Page Number"
 fcb C$LF
 fcc "hpa  Hardware Port Address              "
 fcc "drv  Physical Drive Number"
 fcb C$LF

 ifeq CCDisk-true
 fcc "stp  Step Rate Code (40mS=0, 6mS=3)     "
 else
 fcc "stp  Step Rate Code                     "
 endc

 fcc "typ  Drive Type"
 fcb C$LF
 fcc "dns  Drive/Disk Density                 "
 fcc "cyl  Drive Cylinders"
 fcb C$LF
 fcc "sid  Drive Sides (Heads)                "
 fcc "vfy  Write Verify Flag (yes=0)"
 fcb C$LF
 fcc "sct  Sectors Per Track                  "
 fcc "t0s  Sectors On Track Zero"
 fcb C$LF
 fcc "ilv  Sector Interleave Factor           "
 fcc "sas  Segment Allocation Size"

 ifne CCDisk-true
 fcb C$LF
 fcc "wpc  Write Precompensation Code         "
 fcc "ofs  Partition Offset Cylinder"
 fcb C$LF
 fcc "rwc  Reduced Write Current Cylinder"
 endc

 fcb C$LF,C$CR
helplen equ *-helpmsg
 endc

rbfmsg
 fcb C$LF
 fcc "Not an RBF descriptor!"
 fcb C$LF
cr fcb C$CR
rbflen equ *-rbfmsg

sizemsg
 fcb C$LF
 fcc "Descriptor size out of range!"
 fcb C$LF,C$CR
sizelen equ *-sizemsg

synmsg
 fcb C$LF
 fcc "Syntax error:  "
synlen equ *-synmsg

table
 fcc " nam" option name
 fcb Sign+M$Name,namsiz offset to option offset & max. byte count to change
 fcc " mgr" option name
 fcb Sign+M$FMgr,0 offset to option offset & no changes allowed
 fcc " ddr" option name
 fcb Sign+M$PDev,0
 fcc " hpn"
 fcb M$Port,1 option offset & byte count
 fcc " hpa"
 fcb M$Port+1,2
 fcc " drv"
 fcb $13,1
 fcc " stp"
 fcb $14,1
 fcc " typ"
 fcb $15,1
 fcc " dns"
 fcb $16,1
 fcc " cyl"
 fcb $17,2
 fcc " sid"
 fcb $19,1
 fcc " vfy"
 fcb $1A,1
 fcc " sct"
 fcb $1B,2
 fcc " t0s"
 fcb $1D,2
 fcc " ilv"
 fcb $1F,1
 fcc " sas"
 fcb $20,1

 ifne CCDisk-true
 fcc " wpc"
 fcb $25,1
 fcc " ofs"
 fcb $26,2
 fcc " rwc"
 fcb $28,2
 endc

 fcb $80 end of table

usemsg
 fcb C$LF
 fcc "Use:  Dmode /<device> [opt] [opt] [...]"
 fcb C$LF
 fcc "      Dmode -<path> [opt] [opt] [...]"

 ifeq OptsHelp-true
 fcb C$LF
 fcc "      Dmode -?"
 endc

 fcb C$LF,C$LF
 fcc "Purpose:  To alter device descriptor in"
 fcb C$LF
 fcc "          memory or in disk file.  If"
 fcb C$LF
 fcc "          no options print current"
 fcb C$LF
 fcc "          settings."

 ifeq OptsHelp-true
 fcc "  If -? print option"
 fcb C$LF
 fcc "          help."
 endc

 fcb C$LF,C$CR
uselen equ *-usemsg

****************
* miscellaneous error and help routines

 ifeq OptsHelp-true
muchhelp
 leax helpmsg,pc
 ldy #helplen
 bra helpprnt
 endc

badsize
 leax sizemsg,pc
 ldy #sizelen
 bra AddHelp

notrbf
 leax rbfmsg,pc
 ldy #rbflen
AddHelp
 lda #2
 OS9 I$WritLn
help
 leax usemsg,pc
 ldy #uselen
helpprnt
 lda #2
 OS9 I$WritLn
 lbra okayend2

****************
entry
 ldd #0
 std module zero mod flag
 sta path zero file flag
 ldd ,x+ check for device name
 cmpa #'- file option?
 bne link
 cmpb #'? help option?

 ifeq OptsHelp-true
 beq muchhelp
 else
 beq help
 endc

* Use Filename to Get Desc:
 lda #Updat. open path to desc file
 OS9 I$Open
 lbcs error
 stx parmptr
 sta path save path number
 ldy #DescSize max size
 leax desc,u desc buff
 OS9 I$Read get it
 lbcs error
 cmpy #MinSize reasonable descriptor size?
 blo badsize no, go return error...
 ldd M$Size,x get desc size
 cmpd #DescSize desc size OK?
 bhi badsize no, go return error...
 cmpd #MinSize reasonable descriptor size?
 blo badsize no, go return error...
 std dsize
 bra gotit

link
 cmpa #'/ else must be /<devicename>
 bne help
 pshs u
 lda #Devic
 OS9 F$Link link to descriptor
 lbcs error
 stx parmptr update after name
 tfr u,x
 puls u
 stx module
 ldd M$Size,x get desc size
 cmpd #DescSize desc size OK?
 lbhi badsize no, go report error...
 cmpd #MinSize reasonable descriptor size?
 lblo badsize no, go return error...
 std dsize
 leay desc,u

mloop
 lda ,x+
 sta ,y+
 decb
 bne mloop

gotit
 leax desc,u
 lda $12,x test device type
 cmpa #1 RBF?
 lbne notrbf
 ldx parmptr point to input parms
 lbsr skipspc go skip leading spaces...
 cmpa #C$CR no options?
 lbeq info ..yes, give info
 leax -1,x

****************
* X=parmptr
* Find and Set Options:

flup10
 lbsr skipspc get next input param
 stx parmptr save for syntax error use
 cmpa #C$CR end?
 lbeq verify ..yes, update desc CRC
 leay table-6,pc ready option table ptr
 pshs u
 ldu ,x++ get next two chars
 ora #$20 convert 1st param char to lower case
 exg d,u move [U] where we can convert param chars
 ora #$20 convert 2nd param char...
 orb #$20 convert 3rd...
 exg d,u move back again

flup20
 leay 6,y next option entry
 tst ,y last entry?
 bmi syntax ..yes, bad option
 cmpa 1,y
 bne flup20 same name?
 cmpu 2,y
 bne flup20 ..no, loop
* Found Option
 puls u
 sty txtptr
 ldd ,x+ must be followed by "=", leave [X] pointing at char after "="
 cmpa #'=
 bne syntax
 cmpb #C$CR rest of option missing?
 beq syntax yes, go report error
 cmpb #C$SPAC rest of option missing?
 beq syntax yes, go report error
 ldb 5,y get # of bytes
 beq syntax 0 bytes, not allowed to change this option
 stb <Count
 ldb 4,y get option offset or offset to option offset
 bpl NumOpt option offset, go set hexadecimal option
* Get CHAR input and set option:
 andb #^Sign clear sign bit of offset to option offset
 leay desc,u point to desc
 ldd b,y get offset to option
 leay d,y point to option
 pshs y save option pointer
 os9 F$PrsNam valid OS-9 name?
 puls y recover option pointer (end of name pointer lost)
 bcs syntax no, go report error
 cmpa #C$SPAC space delimiter char?
 beq ChkLen yes, go check name length...
 cmpa #C$CR <CR> delimiter char?
 bne syntax no, go report error

ChkLen
 cmpb <Count name length OK?
 bhi syntax no, go report error...

SetChrLp
 lda ,x+ get character
 sta ,y+ save it to module copy
 decb done yet?
 bne SetChrLp no, go copy another char...
 lda -1,y get last char
 ora #Sign set sign bit
 sta -1,y save last char
 bra flup10 go do next...

* Syntax Error:
syntax
 leax synmsg,pc
 ldy #synlen
 lda #2
 OS9 I$Write
 ldx parmptr
 leax -1,x
 pshs x
 ldy #0

slup
 leay 1,y
 lda ,x+
 cmpa #C$CR
 beq synsay
 cmpa #C$SPAC
 bne slup

synsay
 puls x
 lda #2
 OS9 I$Write output err
 lbra okayend

* Get Hex Input and Set Option:
NumOpt
 clr hexin zero hex input bytes
 clr hexin+1

SetNumLp
 lda ,x+ get next #
 cmpa #C$SPAC end of number?
 beq setnum2 ..yes, set option
 cmpa #C$CR end of line?
 beq setnum1 ..yes, set option
* Convert ASCII Hex-->Byte:
 suba #$30 make number from ASCII
 bmi syntax
 cmpa #10 is it number?
 bcs num
 anda #$5F make uppercase
 suba #$11-$0A make hex $A-$F
 cmpa #$0A
 bcs syntax
 cmpa #$10 not hex char?
 bcc syntax

num
 ldb #16 fancy asl *4
 mul
 pshs b save top 4 bits
 ldd hexin
 rol ,s
 rolb
 rola
 rol ,s
 rolb
 rola
 rol ,s
 rolb
 rola
 rol ,s
 rolb
 rola
 std hexin
 puls b drop temp
 bra SetNumLp ..loop

setnum1
 leax -1,x reset so can find <cr>

setnum2
 ldb 4,y get option offset
 leay desc,u point to desc
 leay b,y point to option
 ldd hexin pick up hex input
 dec Count
 beq setone
 std ,y set two byte option
 lbra flup10

setone
 tsta
 lbne syntax
 stb ,y set one byte option

SetNDone
 lbra flup10

* --------------
* Skip Spaces:
skipspc
 lda ,x+
 cmpa #C$SPAC
 beq skipspc
 rts

* --------------
* Update Descriptor CRC:
verify
 pshs u save data ptr
 leau desc,u
 tfr u,x X is mod address
 ldy M$Size,x Y is mod size
 leay -3,y beginning of chksum
 tfr y,d Y is byte count
 leau d,u set U to chksum
 lda #$FF init chksum
 sta ,u
 sta 1,u
 sta 2,u
 pshs u
 OS9 F$Crc calc new crc
 puls u
 com ,u+ fix it up right
 com ,u+
 com ,u
 lda path was it file?
 beq memmod ..no, in memory
 ldx #0
 tfr x,u
 OS9 I$Seek go back to file begin
 bcs error
 puls u
 leax desc,u
 ldy dsize
 OS9 I$Write update desc file
 bra okayend

memmod
 puls u
 leax desc,u
 ldb dsize+1
 ldy module

move
 lda ,x+
 sta ,y+
 decb
 bne move

vretn
 bra okayend2

okayend
 bsr outcr

okayend2
 clrb okay

error
 pshs b,cc
 ldu module
 beq bye
 OS9 F$UnLink

bye
 puls b,cc
 OS9 F$Exit end dmode.

* --------------
* Print a <CR>:
outcr
 leax cr,pc
 ldy #1
 lda #1
 OS9 I$WritLn
 rts

****************
* Output Current Desc Info:
info
 bsr outcr do a <cr>
 ldb #TablOpts number of table entries
 pshs b save counter
 leax table,pc point to text table
 stx txtptr

ilup
 ldx txtptr
 ldy #4
 lbsr output print option name
 leax equal,pc
 ldy #1
 bsr output print =
 ldx <txtptr
 ldb 4,x get offset to HEX option;  if minus, offset to option offset
 bpl printhex go do simple offset to HEX option
 andb #^Sign clear sign bit
 leay desc,u point [Y] to descriptor copy
 ldd b,y get CHAR string offset within module
 leay d,y point [Y] to CHAR string
 lda #BuffSize get max. chars to print
 leax buffer,u point [X] to CHAR string buffer
 clr <Count init counter

charcopy ldb ,y+ get char
 bpl notlast sign bit clear so not last, go on...
 andb #^Sign clear sign bit
 lda #1 set up as last char

notlast stb ,x+
 inc <Count count chars in string
 deca done yet?
 bne charcopy no, go do another char...
 ldb <Count get chars in string ([A]=0, so [D]=char count)
 tfr d,y module name length into [Y]
 leax buffer,u point [X] to CHAR string copy
 bsr output print CHAR string
 bra moveptr skip HEX output routine

* Print Hex Option Values:
printhex
 ldx txtptr
 ldb 5,x get # of digits
 stb Count
 ldb 4,x get option offset in descriptor
 leax desc,u point [X] to descriptor copy
 abx point [X] to option
 stx dataptr

* Print One Byte:
numlup
 ldx dataptr
 lda ,x+
 stx dataptr
 pshs a
 lsra
 lsra
 lsra
 lsra
 bsr outone
 puls a
 anda #$0F
 bsr outone
 dec Count
 bne numlup

moveptr
 ldx txtptr
 leax 6,x
 stx txtptr
 dec ,s
 lbeq okayend done...
 ldb ,s
 bitb #$03 # of options remaining evenly divisible by four?
 bne ilup no, go print next option on same line
 lbsr outcr <cr> after every 4th option
 bra ilup ..loop

* --------------
* Print 1/2 Byte Hex Char:
outone
 cmpa #10
 bcs number
 adda #$11-10 make alpha

number
 adda #$30 make ASCII
 sta buffer
 leax buffer,u
 ldy #1

output
 lda #1 std out
 OS9 I$Write
 lbcs error
 rts

 emod
size equ *
 end


