* 5-15-87
* Repaired by KDM.
* Errors and undefines removed.
* Order of pshs/puls fixed
* September 11, 1986
* Modified to reflect CC3 Level II.
* Assembles to CC3 Level II Version.
* Changed all z0 labels to L0 labels that match absolute addresses.
* January 8, 1987.
* Updated System defs equates. KDM March 21, 1987.
* Finished comments. KDM March 29, 1987.
* Added vectors to end of module. KDM March 30, 1987.
* Cleaned up formatting in some areas. KDM May 15, 1987.
* Ed. 17a.  Improved F$Move and subroutines, calls.  BRI 88/10/29
* Ed. 17b.  Added FIRQ and F$AllTsk fixes per KDM.  BRI 88/10/31
* Ed. 17c.  UsrIRQ checks for signal, not priority.  BRI 88/11/02
* Ed. 17d.  UsrIRQ checks ALL active processes for signal, FIRQ vector
*           routed through RTI, F$Move reworked again, getax.y changed
*           to use subroutine at L0AC8 per KDM.  BRI 88/11/09
* Ed. 17e.  Reworked UsrIRQ to set 1 tick per process if ANY active
*           process has pending signal.  BRI 88/11/12
* Ed. 17f.  Made all edition 17 changes conditional, cleaned up
*           UsrIRQ fall-through to LastTick.  BRI 88/11/13
* Ed. 17g.  Dumped all UsrIRQ priority/signal checks.  BRI 88/11/15
* Ed. 17h.  Added P$UTicks, P$STicks, P$FCalls, P$ICalls, P$DatBeg,
*           and P$TimBeg to process descriptor.  BRI 88/11/21

* July 24,1986
* April 4,1986
 nam OS9P1_LII
 ifp1
 use defsfile
 endc
* ttl Comments by Kevin K. Darling 1986
 ttl For CC3 Level II

* commented out because it's already defined  BRI
*suspend equ $08
verson equ $08

COCO3.30 equ true false for edition 16, true for edition 17

 org P$SelP+1 new stuff for counters, time stamp  BRI
P$UTicks rmb 4 proc User Tick counter
P$STicks rmb 4 proc System Tick counter
P$FCalls rmb 4 proc F$ call counter
P$ICalls rmb 4 proc I$ call counter
P$DatBeg rmb 3 proc Date of creation
P$TimBeg rmb 3 proc Time of creation (not including Tick)
* P$DatBeg, P$TimBeg at end because there's no harm if stack trashes them.

L0000 equ *

 mod endmod,name,systm,reent+verson,entry,msiz ++

 org $0000
msiz equ .
 nam OS9P1_LII

* commented out because they're already defined  BRI
*D.BtPtr EQU $36 start of bootfile in sys memory ++
*D.BtSz EQU $38 bootfile size ++
*D.Crash EQU $6B vector for failed boot ++
*D.TINIT EQU $91 image of task register ++
*D.TskIPt EQU $A1 DAT image table address ++
*D.MemSz EQU $A3 extended (512k) memory flag ++
*D.SSTskN EQU $A4 current running task ++
*D.CCMem EQU $A5 keyboard scanner static storage ++
*D.CCStk EQU $A7 top of stack in sys memory for GRFDRV ++
*D.AltIRQ EQU $B2 keyboard irq entry point ++
*D.Flip0 EQU $A9 GrfDrv to System Vector ++
*D.Flip1 EQU $AB System to GrfDrv Vector ++

name fcs "OS9p1"

 ifne COCO3.30-true
 fcb 16
 else
 fcb 17 new edition  BRI
* fcb 0 padding to make even bytes  BRI
* fdb 0,0,0,0 more padding  BRI
 endc

*------------------------------------------------*
*                OS9p1 begins here:
*------------------------------------------------*
entry
 ldx #$100 clear rest of first 8k Block: ++
 ldy #8192-$100 ++
 clra
 clrb
L001C
 std ,x++
 leay -2,y
 bne L001C

 inca
 std D.Tasks =$0100 task flags (32)
 addb #$20 (DAT.TkCt) ++
 std D.TskIPt =$0120 temporary images ++

 ifne COCO3.30-true
 clrb
 inca
 std D.BlkMap =$0200 mem block map (64) ++
 addd #$0040 ++
 std D.BlkMap+2 =$0240 end of mem block map ++
 clrb ++
 else
 inca
 aslb
 std D.BlkMap+2 =$0240 end of block map
 clrb
 std D.BlkMap =$0200 mem block map (64)
 endc

 inca ++
 std D.SysDis =$0300 sys dispatch table
 inca
 std D.UsrDis =$0400 usr dispatch table
 inca
 std D.PrcDBT =$0500 proc desc pointers
 inca
 std D.SysPrc =$0600 original sys proc
 std D.Proc =$0600 original proc
 adda #P$Size/256 desc
 tfr d,s SP=$0800 sys SP within sys desc
 inca
 std D.SysStk =$0900 main sys stack ptr
 std D.SysMem =$0900 sys memmap
 inca
 std D.ModDir =$0A00 module dir
 std D.ModEnd =$0A00  (grows upward)
 adda #$06
 std D.ModDir+2 =$1000 module DAT images
 std D.ModDAT =$1000  (grows downward)
 std D.CCMem =$1000 CC3IO static memory ++

 ifne COCO3.30-true
 ldd #$2000 GrfDrv stack area ++
 else
 asla d=$2000  BRI
 endc

 std D.CCStk ++

*------------------------------------------------*
 leax >vectors,pcr put jmp[,x] vectors:
 tfr x,d
 ldx #D.SWI3

* used by top 256 to jmp to sys.

L0065
 std ,x++
 cmpx #D.NMI
 bls L0065

 leax >ENDOFROM,pcr move secondary vectors
 pshs x from end of rom:
 leay >D.VECTRS,pcr
 ldx #D.Clock (Tick-NMI)
L0079
 ldd ,y++ get vector
 addd ,s add offset
 std ,x++ store
 cmpx #D.XNMI done?
 bls L0079 ..no
 leas 2,s drop offset

 ldx D.XSWI2 set calls to sys
 stx D.UsrSvc
 ldx D.XIRQ set IRQ to sys
 stx D.UsrIRQ

 leax >syscall,pcr set syscall handler
 stx D.SysSvc
 stx D.XSWI2

 leax >S.SYSIRQ,pcr set sysirq handler
 stx D.SysIRQ
 stx D.XIRQ

 leax >S.SVCIRQ,pcr IRQ svc handler
 stx D.SvcIRQ
 leax >S.POLL,pcr default poll 'til IOMan
 stx D.Poll
 LEAX S.ALTIRQ,PCR default keyboard till CC3io ++
 STX D.AltIRQ ++
 LEAX S.FLIP0,PCR Grfdrv return vector ++
 STX D.Flip0 ++
 LEAX S.FLIP1,PCR GrfDrv exec vector ++
 STX D.Flip1 ++

 leay >calls,pcr enter os9p1 svc calls:
 lbsr ssvc

*------------------------------------------------*
 ldu D.PrcDBT set up first proc desc:
 ldx D.SysPrc
 stx 0,u proc table entries
 stx 1,u zero and one

 lda #$01 sys proc id=01
 sta P$ID,x
 lda #SysState set sys state
 sta P$State,x
 lda #Systask sys task # ++
 sta D.SysTsk
 sta P$Task,x
 lda #$FF top priority
 sta P$Prior,x
 sta P$Age,x

 leax P$DATImg,x point sysdat -> sys proc
 stx D.SysDAT
 clra
 clrb
 std ,x++ first block always sys

* DAT.BlCt-ROMCount-RAMCount:
 ldy #6 next 6 are unused ++
 ldd #DAT.Free
L00EF
 std ,x++
 leay -1,y
 bne L00EF

 ldd #IOBlock last one is Kernel ++
 std ,x++

 ldx D.Tasks first task# is sys's
 inc 0,x
 inc 1,x Task 1 is GrfDrv ++

*------------------------------------------------*
 ldx D.SysMem
 ldb D.CCStk (=$20) ++

* set 1st 8K sys mem used

L0104
 inc ,x+
 decb
 bne L0104
 CLR D.MemSz default is 128k ++
 LDD #$0313 blocks $03 and $13 ++
 STD DAT.REGS+5 map at logical $A000 ++
 LDX #$A000 point to first block ++
 LDD #$DC78 get inverted sync bytes ++
 STD ,X store at start of first block ++
 CMPD 8192,X in second block too? ++
 BEQ L0122 yes, just 128k ++
 INC D.MemSz else set 512k flag ++

L0122 ldy #$2000 point to second block in map ++
 ldx D.BlkMap X=$0200

* Check Memory Blocks Loop:

L0128
 pshs x save current map pointer
 ldd ,s D=map ptr
 subd D.BlkMap D=block number
 cmpb #IOBlock is it sys?
 BNE L0136 ..no, test for 512k ++
 LDB #RAMinUse load marker ++
 BRA L015B go set in map ++

L0136 LDA D.MemSz 512k memory? ++
 BNE L013E yes, continue ++
 CMPB #$0F end of 128k mem? ++
 BHS L0159 yes, set notram ++

L013E stb >DAT.Regs+1 set block at $2000 for test ++
 ldu ,y get two bytes
 ldx #$00FF store test bytes
 stx ,y
 cmpx ,y same on read
 bne L0159 ..end if no mem here

 ldx #$FF00 make sure again
 stx ,y
 cmpx ,y
 bne L0159 ..bad mem
 stu ,y restore original bytes
 bra L015D do next

* End of Memory:

L0159
 ldb #NotRAM set non-mem flag

L015B stb [,s] store at ,X in table ++

L015D
 puls x get current map pointer
 leax 1,x next block
 cmpx D.BlkMap+2 end of map?
 blo L0128 ..no, keep trying

*------------------------------------------------*
* Search For ROM Modules:

 ldx D.BlkMap X=map strt (X=$0200)
 inc ,x mark as RAMinUse
 ldx D.BlkMap+2 start at end of map (X=$0240)

 ifne COCO3.30-true
 leax >-1,x back up 1 ++
 else
 leax -1,x back up 1 (X=$023F)  BRI
 endc

*------------------------------------------------*
 tfr x,d else D=block number (D=$023F)
 subd D.BlkMap make into block number (D=$003F)

 ifne COCO3.30-true
 leas -16,s make local var space ++
 leay ,s Y=var ptr
 lbsr L01F1 set 8 markers X+ -->Y++
 pshs x save map ptr (X=$0047) *** useless ***  BRI
 else
 pshs d save block number
 leay ,s Y=var pointer for routine below
 endc

 ldx #$0D00 offset in block ++

*------------------------------------------------*
* Check Block for Modules Loop:

L017F
 pshs x,y
 lbsr L0AF0 set up Y for X offset
 ldb 1,y B=block# from image
 stb >DAT.Regs map into sys zero
 lda ,x get byte from block
 clr >DAT.Regs back to sys
 puls x,y
 cmpa #$87 module?
 bne L01A7

 lbsr L0463 do verify
 bcc L019D
 cmpb #E$KwnMod 'Known Module'?
 bne L01A7 ..no, continue
L019D
 ldd #M$Size else get mod size
 lbsr L0B02
 leax d,x skip over it
 bra L01A9

* Not Known Module:

L01A7
 leax 1,x byte ptr+1

L01A9
 CMPX #$1E00 don't overrun vector page! ++
 BLO L017F ok to continue ++
 BSR L01D2 setup system mem map ++

*------------------------------------------------*
* OS9p1 init finished:

L01B0
 leax >initnm,pcr 'Init'
 bsr L01EB link to it
 bcc L01BF ..okay
 os9 f$boot else do Boot
 bcc L01B0 ..try again
 bra L01CE else report boot failed

L01BF
 stu D.Init save Init ptr
L01C1
 leax >os9p2nm,pcr 'OS9p2'
 bsr L01EB link to it
 bcc L01D0 do it if found
 os9 f$boot else do Boot
 bcc L01C1 ..try again
L01CE
 jmp D.Crash else report boot failed

L01D0
 jmp ,y do OS9p2...

* Setup system memory map.

L01D2 LDX D.SYSMEM point to map ++
 LEAX $ED00/256,X kernel offset in map ++
 LDA #NOTRAM mark IOPage ++
 STA 18,X as Not RAM ++
 LDB #$12 18 pages in kernel ++

L01DF LDA #RAMINUSE mark kernel ++

L01E1 STA ,X+ RAM as in use ++
 DECB all done ++
 BNE L01E1 no, continue
 LDX D.BLKMAP+2 end of map++
 STA -1,X mark block #3F ++
 RTS exit ++

* Link to Module (X):

L01EB
 lda #Systm systm+data
 os9 f$link try to find it
 rts

 ifne COCO3.30-true
*------------------------------------------------*
* Make Temp DAT Image:

L01F1
 pshs a,b,x,y Y=local stack
 ldb #DAT.BlCt do 16 blocks
 ldx ,s X=begin block (X=$003F)
L01F7
 stx ,y++ set marker
 leax 1,x
 decb count-1
 bne L01F7 ..loop
 puls a,b,x,y,pc
 endc

*------------------------------------------------*
*              System Service Calls
*------------------------------------------------*
calls
 fcb F$Link
 fdb f.link-*-2
 fcb F$PrsNam
 fdb f.prsnam-*-2
 fcb F$CmpNam
 fdb f.cmpnam-*-2
 fcb F$CmpNam+$80 (sys)
 fdb s.cmpnam-*-2
 fcb F$CRC
 fdb f.crc-*-2
 fcb F$SRqMem+$80
 fdb f.srqmem-*-2
 fcb F$SRtMem+$80
 fdb f.srtmem-*-2
 fcb F$AProc+$80
 fdb f.aproc-*-2
 fcb F$NProc+$80
 fdb f.nproc-*-2
 fcb F$VModul+$80
 fdb f.vmodul-*-2
 fcb F$SSvc
 fdb f.ssvc-*-2
 fcb F$SLink+$80
 fdb f.slink-*-2
 fcb F$Boot+$80
 fdb f.boot-*-2
 fcb F$BtMem+$80
 fdb f.btmem-*-2
 fcb F$Move+$80
 fdb f.move-*-2
 fcb F$AllRam
 fdb f.allram-*-2
 fcb F$AllImg+$80
 fdb f.allimg-*-2
 fcb F$SetImg+$80
 fdb f.setimg-*-2
 fcb F$FreeLB+$80
 fdb f.freelb-*-2
 fcb F$FreeHB+$80
 fdb f.freehb-*-2
 fcb F$AllTsk+$80
 fdb f.alltsk-*-2
 fcb F$DelTsk+$80
 fdb f.deltsk-*-2
 fcb F$SetTsk+$80
 fdb f.settsk-*-2
 fcb F$ResTsk+$80
 fdb f.restsk-*-2
 fcb F$RelTsk+$80
 fdb f.reltsk-*-2
 fcb F$DATLog+$80
 fdb f.datlog-*-2
 fcb F$LDAXY+$80
 fdb f.ldaxy-*-2
 fcb F$LDDDXY+$80
 fdb f.ldddxy-*-2
 fcb F$LDABX+$80
 fdb f.ldabx-*-2
 fcb F$STABX+$80
 fdb f.stabx-*-2
 fcb F$ELink+$80
 fdb f.elink-*-2
 fcb F$FModul+$80
 fdb f.fmodul-*-2
 fcb F$AlHRam+$80 new call ++
 fdb f.alhram-*-2 for CoCo3 ++
 fcb $80 End of Table

*------------------------------------------------*
initnm fcs "Init"
os9p2nm fcs "OS9p2"
bootnm fcs "Boot"

*------------------------------------------------*
vectors
 jmp [-16,x] goto irq routine

*------------------------------------------------*
*             User State SWI Vectors:
*------------------------------------------------*

L0274
 ldx D.Proc proc desc
 ldu P$SWI3,x diff swi3 vector?
 beq L028E ..no, do normal

L027B
 lbra L0E5E else do usr call.

L027E
 ldx D.Proc X=proc desc
 ldu P$SWI2,x swi2 svc ptr
 beq L028E ..zero, do normal
 bra L027B else do usr map

usrcall
 ldx D.Proc proc desc
 ldu P$SWI,x swi ptr
 bne L027B ..do user, else:

*------------------------------------------------*
* System SWI calls: (X=pd, U=svc)

L028E
 ldd D.SysSvc set system state:
 std D.XSWI2
 ldd D.SysIRQ
 std D.XIRQ
 lda P$State,x
 ora #SysState
 sta P$State,x

 sts P$SP,x and save user stack
 leas P$Stack-R$Size,x get local sys stack
 andcc #^IntMasks okay interrupts
 leau ,s U=sys reg stack
 bsr L02CB copy user stack here

 ldb P$Task,x B=task#
 ldx R$PC,u X=PC ptr
 lbsr f.ldbbx get call byte from user map ++
 leax 1,x increment PC
 stx R$PC,u past call

 ldy D.UsrDis Y=user dispatch table
 lbsr L033B do the call
 ldb R$CC,u okay interrupts
 andb #^IntMasks on return
 stb R$CC,u to user map

 ldx D.Proc
 bsr L02DA copy back new user stack
 lda P$State,x drop sys state
 anda #^SysState
 lbra L0D7C and return to user.

*------------------------------------------------*
* Get Caller's Regs:

L02CB
 PSHS CC,X,Y,U ++
 ldb P$Task,x A=user tsk# ++
 ldx P$SP,x X=from user stack
 LBSR L0BF5 get offset in 8k space ++
 LEAX $A000,X +$A000 =logical address ++
 bra L02E9 get regs & rts.

* Return Regs to Caller:

L02DA
 PSHS CC,X,Y,U save state ++
 ldb P$Task,x B=user tsk#
 ldx P$SP,x X=to user stack
 LBSR L0BF5 get offset in 8k space ++
 LEAX $A000,X +$A000 =logical address ++
 exg x,u U=user, X=sys

* move caller stack -->

L02E9
 PSHS U save U ++
 LBSR L0C09 get DAT image pointer in U ++
 LEAU A,U point to block # in image ++
 LEAU 1,U point to LSB ++
 LDA ,U++ first block # in A ++
 LDB ,U second block # in B ++
 LDU #DAT.REGS+5 $A000 logical ++
 ORCC #INTMASKS mask interrupts ++
 STD ,U set DAT ++
 PULS U recover U ++
 LDY #R$SIZE register stack size ++

L0303 LDD ,X++ move them ++
 STD ,U++ ++
 LEAY -2,Y done yet? ++
 BNE L0303 no, continue ++
 LDX D.SYSDAT system DAT image ++
 LDA 11,X get real ++
 LDB 13,X system blocks ++
 STD DAT.REGS+5 and restore system map ++
 PULS CC,X,Y,U,PC clean up and rts ++

*------------------------------------------------*
*                Sys State OS Call:
*------------------------------------------------*
syscall
 leau ,s U=reg stack
 LDA D.SSTskN get task image ++
 CLR D.SSTskN set to system ++
 PSHS A save old task # ++
 lda R$CC,u
 tfr a,cc set CC=user CC
 ldx R$PC,u get call
 LDB ,S is task sys? ++
 BEQ L032F yes ++
 lbsr f.ldbbx get call from user space ++
 LEAX 1,X point past it ++
 BRA L0331 set as PC ++

L032F ldb ,x+ and increment PC

L0331 stx R$PC,u past it
 ldy D.SysDis Y=system dispatch table
 bsr L033B do the call
 lbra L0E2B end

*------------------------------------------------*
* Do Svc Call(B), Y=table:

L033B
 aslb index
 bcc L0345 ..okay if not I/O

 ifeq COCO3.30-true
* count I$ calls for current process (D.Proc)  BRI
 pshs b save index into table
 ldb #P$ICalls set up I$ counter
 bsr IncCount go do it... (X is altered)
 puls b recover index
 endc

 rorb else reset B
 ldx $00FE,y else X=IOMan vector
 bra L034F and do it.

 ifeq COCO3.30-true
* count User Ticks, System Ticks, F$ calls, or I$ calls
* for current process (D.Proc)  BRI
IncCount ldx <D.Proc get pointer to current proc desc
 beq IncExit no current proc, go return
 abx add offset to appropriate counter
 inc 3,x 4 byte counter LSB
 bne IncExit no overflow, go return
 inc 2,x 4 byte counter lower middle byte
 bne IncExit no overflow, go return
 inc 1,x 4 byte counter upper middle byte
 bne IncExit no overflow, go return
 inc ,x 4 byte counter MSB (ignore overflow)
IncExit rts
 endc

* (not I/O call)

L0345

 ifeq COCO3.30-true
 pshs b save index into table
 ldb #P$FCalls set up F$ counter
 bsr IncCount go do it... (X is altered)
 puls b recover index
 endc

 clra A=00
 ldx d,y X=vector from table
 bne L034F ..ok if one
 comb else
 ldb #E$UnkSvc 'Unknown Service Call'
 bra L0355 bad end: return err

*------------------------------------------------*
* Do Call Vector (X)

L034F
 pshs u save reg ptr
 jsr ,x do the call
 puls u retrieve reg ptr

L0355
 tfr cc,a A=svc call CC
 bcc L035B ..skip if no err
 stb R$B,u else return err in reg.B
L035B
 ldb R$CC,u drop lsb nibble
 andb #$D0
 stb R$CC,u
 anda #$2F put in call's CC lsnibble
 ora R$CC,u
 sta R$CC,u
 rts end service call.


*------------------------------------------------*
*                    F$SSvc
*------------------------------------------------*
f.ssvc
 ldy R$Y,u Y=table address
 bra ssvc do check first...

* SSvc Loop:

L036D
 clra A=00
 aslb B=table index (set C if >=$80)
 tfr d,u U=index
 ldd ,y++ D=new call vector offset
 leax d,y X=actual vector
 ldd D.SysDis D=sys dispatch table
 stx d,u store new call vector
 bcs ssvc ..skip if sys only
 ldd D.UsrDis else put in user
 stx d,u dispatch table also.

*  End of Table Check:

ssvc
 ldb ,y+ get next call
 cmpb #$80 is it end-of-table?
 bne L036D ..no
 rts yes, end.


*------------------------------------------------*
*                    F$SLink
*------------------------------------------------*
* Link modules into map.
* A=type,X=name,Y=DAT image ptr
f.slink
 ldy R$Y,u get DAT image ptr
 bra s.link


*------------------------------------------------*
*                    F$ELink
*------------------------------------------------*
f.elink
 pshs u
 ldb R$B,u type
 ldx R$X,u name of module
 bra L03AF go link it


*------------------------------------------------*
*                    F$Link
*------------------------------------------------*
f.link
 ldx D.Proc proc desc
 leay P$DATImg,x Y=DAT image ptr

*------------------------------------------------*
s.link
 pshs u save reg ptr
 ldx R$X,u X=module name
 lda R$A,u A=module type
 lbsr L068D search moddir

 ifne COCO3.30-true
 lbcs L041E ..err
 else
 bcs L041E ..err  BRI
 endc

 leay ,u Y=moddir entry
 ldu ,s get back reg ptr
 stx R$X,u return X
 std R$D,u return type/lang
 leax ,y X=moddir entry

L03AF
 bitb #ReEnt is it shareable?
 bne L03BB ..yes
 ldd MD$Link,x any links?
 beq L03BB ..no:ok, else
 ldb #E$ModBsy 'Module Busy' err
 bra L041E bad end.

L03BB
 ldd MD$MPtr,x D=module ptr
 pshs a,b,x save ptr,entry
 ldy MD$MPDAT,x Y=DAT img for module
 ldd MD$MBSiz,x D=mem block size
 addd #$1FFF round up A ++
 tfr a,b to 8K block ++
 lsrb B/32
 lsrb
 lsrb
 lsrb
 lsrb ++
 adda #2 (A+2)/32 ++
 lsra
 lsra
 lsra
 lsra
 lsra ++
 pshs a save blocks needed
 leau ,y U=moddir entry
 bsr L0422 find it in callers map?
 bcc L03EB ..yes

 lda ,s blocks needed
 lbsr L0A33 room to map in?
 bcc L03E8 ..okay
 leas 5,s else drop junk
 bra L041E bad end.

L03E8
 lbsr L0A8C set DAT image
L03EB
 leax P$Links,x link cnt tble
 sta ,s save block #
 asla index
 leau a,x U=link ptr
 ldx ,u increment link cnt:
 leax 1,x
 beq L03FC
 stx ,u
L03FC
 ldu 3,s U=moddir entry
 ldx MD$Link,u increment link cnt:
 leax 1,x
 beq L0406
 stx MD$Link,u
L0406
 puls b,x,y,u
 lbsr L0AB0 dattolog
 stx R$U,u return module addrss
 ldx MD$MPtr,y mod ptr
 ldy MD$MPDAT,y DAT image ptr
 ldd #M$Exec get exec offset
 lbsr L0B02
 addd R$U,u plus mod addrss
 std R$Y,u = exec address
 clrb okay
 rts end.

L041E
 orcc #Carry set error
 puls u,pc

*------------------------------------------------*
*    See if moddir image in proc map already:
*------------------------------------------------*

* B=block img #, U=moddir ptr

L0422
 ldx D.Proc proc desc
 leay P$DATImg,x Y=DAT image ptr
 clra A=00
 pshs a,b,x,y save #,proc,img
 subb #DAT.BlCt
 negb
 aslb index
 leay b,y

* Image Compare Loop:

L0430
 ldx ,s X=block cnt
 pshs y,u
L0434
 ldd ,y++ does proc img
 cmpd ,u++ match mod image?
 bne L0449 ..no
 leax -1,x yes, cnt-1
 bne L0434 ..done?

 puls a,b,u D=start ptr
 subd 4,s -block cnt = offset
 lsrb B/2 index
 stb ,s save block #
 clrb okay
 puls a,b,x,y,pc rts.

L0449
 puls y,u Y=start ptr
 leay -2,y back up one img
 cmpy 4,s too far?
 bcc L0430 ..no, try again
 puls a,b,x,y,pc error end.


*------------------------------------------------*
*                    F$VModul
*------------------------------------------------*
f.vmodul
 pshs u
 ldx R$X,u X=mod offset
 ldy R$D,u Y=DAT img ptr
 bsr L0463 do the verify
 ldx ,s
 stu R$U,x return moddir ptr
 puls u,pc

L0463
 pshs x,y
 lbsr L0586 check module crc
 bcs L0493 ..err

 ldd #M$Type
 lbsr L0B02 get type/rev bytes
 andb #$0F save rev
 pshs a,b

 ldd #M$Name get name offset
 lbsr L0B02
 leax d,x X points to mod name
 puls a
 lbsr L068D
 puls a
 bcs L0497

 pshs a
 andb #$0F
 subb ,s+
 bcs L0497
 ldb #E$KwnMod 'Known Module'
 bra L0493

L0491
 ldb #E$DirFul 'Module Dir Full'
L0493
 orcc #CARRY
 puls x,y,pc

*------------------------------------------------*
L0497
 ldx ,s X=module addrss
 lbsr L0524
 bcs L0491
 sty MD$MPDAT,u insert DAT image ptr
 stx MD$MPtr,u and module ptr
 clra
 clrb
 std MD$Link,u link count=00
 ldd #M$Size
 lbsr L0B02 get module size
 pshs x mod addrss
 addd ,s++ plus size
 std MD$MBSiz,u
 ldy [MD$MPDAT,u] Y=mod images
 ldx D.ModDir X=mod dir strt
 pshs u save entry
 bra L04BE

L04BC
 leax MD$ESize,x next moddir entry
L04BE
 cmpx D.ModEnd last one?
 bcc L04CD ..yes, end
 cmpx ,s same entry?
 beq L04BC ..yes, try again
 cmpy [,x] same image ptr?
 bne L04BC ..no, try again
 bsr L04F2

*------------------------------------------------*
* Mark BlockMaps as Modules:

L04CD
 puls u U=dir entry
 ldx D.BlkMap X=mem block map
 ldd MD$MBSiz,u D=mod block size
 addd #$1FFF round up size ++
 lsra A/32 = number of blocks
 lsra (8K)
 lsra
 lsra
 lsra ++
 ldy MD$MPDAT,u Y=mod dat image

L04DE
 pshs a,x save block size, blkmap
 ldd ,y++ D=image block#
 leax d,x X=blkmap ptr
 ldb ,x get block marker
 orb #ModBlock set module in block
 stb ,x marker
 puls a,x ..
 deca count-1
 bne L04DE ..mark all blocks

 clrb okay
 puls x,y,pc end.

*------------------------------------------------*
* Clear entries:

L04F2
 pshs a,b,x,y,u
 ldx ,x
 pshs x
 clra D=0000
 clrb
L04FA
 ldy ,x last entry?
 beq L0503 ..yes
 std ,x++ no, clear
 bra L04FA and loop

L0503
 puls x
 ldy 2,s
 ldu MD$MPDAT,u U=mod images
 puls a,b

L050C
 cmpx ,y same image?
 bne L051B ..no, try next
 stu MD$MPDAT,y yes, set new image
 cmpd MD$MBSiz,y new size bigger?
 bcc L0519 ..yes, use it
 ldd MD$MBSiz,y else use old size
L0519
 std MD$MBSiz,y set modblock size
L051B
 leay MD$ESize,y next entry
 cmpy D.ModEnd last?
 bne L050C ..no
 puls x,y,u,pc end.

*------------------------------------------------*
L0524
 pshs x,y,u save mod adrs,img,
 ldd #M$Size get module size
 lbsr L0B02
 addd ,s end = begin+size
 addd #$1FFF round to block ++
 lsra A/32
 lsra
 lsra
 lsra
 lsra ++,
 tfr a,b A,B=number of blocks
 pshs b save num
 incb
 aslb
 negb
 sex sign extend into D
 bsr L054E make new dir entry
 bcc L054C ..okay rts

 os9 F$GCMDir else get task#
 ldu #$0000 set flag
 stu 5,s
 bsr L054E make new dir entry
L054C
 puls b,x,y,u,pc rts.

*------------------------------------------------*
* Allocate module dir image:

L054E
 ldx D.ModDAT X+D = mod DAT img pointer
 leax d,x
 cmpx D.ModEnd would it be below last dir?
 bcs L0583 ..yes, err

 ldu 7,s get back old U
 bne L056E ..
 pshs x save new moddat ptr
 ldy D.ModEnd Y=end of dir
 leay MD$ESize,y plus new entry
 cmpy ,s++ collide with moddat?
 bhi L0583 ..yes, err

 sty D.ModEnd store new dir end
 leay -MD$ESize,y Y=new dir entry ptr
 sty 7,s return it to caller
L056E
 stx D.ModDAT store new moddat ptr
 ldy 5,s
 ldb 2,s B=block count
 stx 5,s return dir datimg ptr

L0577
 ldu ,y++ copy images
 stu ,x++ to new mod dat entry
 decb
 bne L0577

 clr ,x zero flag
 clr 1,x
 rts end.

L0583
 orcc #Carry set err flag
 rts end.


*------------------------------------------------*
*             Calculate CRC of Module:
*------------------------------------------------*

L0586
 pshs x,y
 clra D=offset of zero
 clrb
 lbsr L0B02 get 2 bytes
 cmpd #$87CD is it module?
 beq L0597 ..yes
 ldb #E$BMID 'Bad Module Header'
 bra L05F3 ..err end.

* Check Module Header:

L0597
 leas -1,s make var
 leax 2,x X=past sync bytes
 lbsr L0AF0 set Y for X offset
 ldb #$07 seven bytes
 lda #$4A header crc
L05A2
 sta ,s save crc
 lbsr getax.y get next byte
 eora ,s do crc
 decb more?
 bne L05A2 ..loop

 leas 1,s drop var
 inca $FF+1 = 00
 beq L05B5 ..okay header
 ldb #E$BMHP 'Bad Module Header'
 bra L05F3 err end.

*------------------------------------------------*
* Do CRC across module:

L05B5
 puls x,y

* change here to clra,clrb, rts
* for no crc checking across module:

 ldd #$0002
 lbsr L0B02
 pshs a,b,x,y
 ldd #$FFFF set temp CRC register
 pshs a,b
 pshs b
 lbsr L0AF0 set up Y for X offset
 leau ,s
L05CB
 tstb
 bne L05D8
 pshs x
 ldx #$0001
 os9 f$sleep
 puls x
L05D8
 lbsr getax.y get a byte
 bsr L05F7
 ldd 3,s
 subd #$0001
 std 3,s
 bne L05CB
 puls b,x,y
 cmpb #$80
 bne L05F1
 cmpx #$0FE3
 beq L05F5
L05F1
 ldb #E$BMCRC 'Bad Module CRC'
L05F3
 orcc #$01
L05F5
 puls x,y,pc

*------------------------------------------------*
*                  CRC Calculator:
*------------------------------------------------*

L05F7
 eora ,u
 pshs a
 ldd 1,u
 std ,u
 clra
 ldb ,s
 aslb
 rola
 eora 1,u
 std 1,u
 clrb
 lda ,s
 lsra
 rorb
 lsra
 rorb
 eora 1,u
 eorb 2,u
 std 1,u
 lda ,s
 asla
 eora ,s
 sta ,s
 asla
 asla
 eora ,s
 sta ,s
 asla
 asla
 asla
 asla
 eora ,s+
 bpl L0635
 ldd #$8021
 eora ,u
 sta ,u
 eorb 2,u
 stb 2,u
L0635
 rts

*------------------------------------------------*
*                    F$CRC
*------------------------------------------------*
f.crc
 ldd R$Y,u get byte count
 beq L0677 ..zero
 ldx R$X,u begin ptr
 pshs a,b,x
 leas -3,s
 ldx D.Proc
 lda P$Task,x
 ldb D.SysTsk
 ldx R$U,u
 ldy #$0003
 leau ,s
 pshs a,b,x,y
 lbsr L0B2C
 ldx D.Proc
 leay P$DATImg,x
 ldx 11,s
 lbsr L0AF0
L065D
 lbsr getax.y

 ifne COCO3.30-true
 lbsr L05F7
 else
 bsr L05F7  BRI
 endc

 ldd 9,s
 subd #$0001
 std 9,s
 bne L065D
 puls a,b,x,y
 exg a,b
 exg x,u
 lbsr L0B2C
 leas 7,s
L0677
 clrb
 rts

*------------------------------------------------*
*                    F$FModul
*------------------------------------------------*
* Find the Module named (X) with type (A) in Y
f.fmodul
 pshs u
 lda R$A,u A=type request
 ldx R$X,u X=name
 ldy R$Y,u Y=DAT image ptr
 bsr L068D find it
 puls y
 std R$D,y return type/attr
 stx R$X,y updated name ptr
 stu R$U,y module offset
 rts

L068D
 ldu #$0000 address flag
 pshs a,b,u
 bsr L0712 get first char
 cmpa #'/ start with slash?
 beq L070B ..bad name error
 lbsr L0741
 bcs L070E
 ldu D.ModEnd U=mod end ++
 bra L0700

*------------------------------------------------*
* Main Loop:

L06A1
 pshs a,b,x,y
 pshs x,y
 ldy MD$MPDAT,u Y=mod images
 beq L06F6
 ldx MD$MPtr,u X=mod ptr
 pshs x,y
 ldd #M$Name get mod name
 lbsr L0B02 offset
 leax d,x X=name address
 pshs x,y save add,images
 leax 8,s
 ldb 13,s
 leay ,s
 lbsr L07DE
 leas 4,s
 puls x,y
 leas 4,s
 bcs L06FE
 ldd #M$Type get mod type/lang
 lbsr L0B02
 sta ,s
 stb 7,s
 lda 6,s
 beq L06ED
 anda #$F0
 beq L06E1
 eora ,s
 anda #$F0
 bne L06FE
L06E1
 lda 6,s
 anda #$0F
 beq L06ED
 eora ,s
 anda #$0F
 bne L06FE
L06ED
 puls a,b,x,y
 abx
 clrb
 ldb 1,s
 leas 4,s
 rts

*------------------------------------------------*
L06F6
 leas 4,s
 ldd 8,s
 bne L06FE
 stu 8,s
L06FE
 puls a,b,x,y

* Moved back one ++

L0700
 leau -MD$ESize,u next dir entry ++
 cmpu D.ModDir last one? ++
 bcc L06A1 ..no, loop ++

*------------------------------------------------*
 ldb #E$MNF 'Module Not Found'
 bra L070E

L070B
 comb
 ldb #E$BNam 'Bad Name' error
L070E
 stb 1,s return err code
 puls a,b,u,pc

*------------------------------------------------*
* Get Module Name:

L0712
 pshs y save image strt
L0714
 lbsr L0AF0 point X to name in img(Y)
 lbsr L0AC8 get char
 leax 1,x ptr+1
 cmpa #$20 was char space?
 beq L0714 ..yes, skip

 leax -1,x ptr-1
 pshs a save char
 tfr y,d D=image ptr
 subd 1,s -images start
 asrb block#=image/2
 lbsr L0AB0 ??
 puls a,y,pc rts.


*------------------------------------------------*
*                    F$PrsNam
*------------------------------------------------*
f.prsnam
 ldx D.Proc proc desc
 leay P$DATImg,x Y=DAT image ptr
 ldx R$X,u X=name string
 bsr L0741 get it and length
 std R$D,u return length in D
 bcs L073E ..err
 stx R$X,u and X at name begin
 abx plus len
L073E
 stx R$Y,u return Y=end of name ptr
 rts end.

* Parse Name:

L0741
 pshs y save image ptr
 lbsr L0AF0 find map block
 pshs x,y
 lbsr getax.y get A=byte(X)
 cmpa #'/ is it a slash?
 bne L0756 ..no
 leas 4,s
 pshs x,y
 lbsr getax.y get next char
L0756
 bsr L07A1
 bcs L076A
 clrb
L075B
 incb
 tsta
 bmi L0766
 lbsr getax.y
 bsr L078A
 bcc L075B
L0766
 andcc #^Carry
 bra L077C

*------------------------------------------------*
L076A
 cmpa #',
 bne L0775
L076E
 leas 4,s
 pshs x,y
 lbsr getax.y
L0775
 cmpa #$20 is it a blank?
 beq L076E ..yes, loop
 comb else err
 ldb #E$BNam 'Bad Name' error
L077C
 puls x,y
 pshs cc,a,b
 tfr y,d
 subd 3,s
 asrb
 lbsr L0AB0
 puls cc,a,b,y,pc

L078A
 pshs a
 anda #$7F drop msb
 cmpa #'. is it '.'?
 beq L079E
 cmpa #'0 is it control?
 bcs L07B5 ..yes
 cmpa #'9 is it number?
 bls L079E ..yes
 cmpa #$5F is it '_'?
 bne L07A5 ..no
L079E
 clra
 puls a,pc

*----------------------------------------------
L07A1
 pshs a
 anda #$7F drop msb
L07A5
 cmpa #'A A-Z?
 bcs L07B5
 cmpa #'Z
 bls L079E
 cmpa #'a a-z?
 bcs L07B5
 cmpa #'z
 bls L079E
L07B5
 coma
 puls a,pc


*------------------------------------------------*
*                    F$CmpNam
*------------------------------------------------*
f.cmpnam
 ldx D.Proc proc desc
 leay P$DATImg,x Y=caller DAT image ptr
 ldx R$X,u X=first name
 pshs x,y save name,img
 bra L07CF do it


*------------------------------------------------*
*                 F$CmpNam (sys)
*------------------------------------------------*
s.cmpnam
 ldx D.Proc proc desc
 leay P$DATImg,x Y=images
 ldx R$X,u X=first name
 pshs x,y save name,imgs
 ldy D.SysDAT Y=system DAT image ptr

L07CF
 ldx R$Y,u X=second name
 pshs x,y save name2,sysimg
 ldd R$D,u D=match length
 leax 4,s [X]=name1
 leay ,s [Y]=name2
 bsr L07DE compare them
 leas 8,s drop vars
 rts end.

* Compare two strings:

L07DE
 pshs a,b,x,y,u length,name1,name2,regs
 ldu 2,s U=name1 ptr
 pulu x,y get name,images
 lbsr L0AF0 set X for img(Y)
 pshu x,y save name1 offsets
 ldu 4,s
 pulu x,y
 lbsr L0AF0
 bra L07F6

L07F2
 ldu 4,s
 pulu x,y
L07F6
 lbsr getax.y get name2 char
 pshu x,y
 pshs a save char
 ldu 3,s
 pulu x,y
 lbsr getax.y get name1 char
 pshu x,y
 eora ,s compare chars
 tst ,s+ check result
 bmi L0816 ..msb diff
 decb len-1
 beq L0813 last?
 anda #$DF
 beq L07F2 do next char

L0813
 comb err
 puls a,b,x,y,u,pc end.

L0816
 decb len-1
 bne L0813 ..err if >0
 anda #$5F
 bne L0813
 clrb okay
 puls a,b,x,y,u,pc end.


*------------------------------------------------*
*               F$SRqMem / F$BtMem
*------------------------------------------------*
f.srqmem
f.btmem
 ldd R$D,u get # bytes wanted
 addd #$00FF round up
 clrb to page
 std R$D,u return it
 ldy D.SysMem Y=system mem map
 leas -2,s
 stb ,s
L082F
 ldx D.SysDAT X=system DAT image
 aslb index block
 ldd b,x D=DAT marker
 cmpd #DAT.Free is it free?
 beq L0847 ..yes
 ldx D.BlkMap else look
 lda d,x at block map byte
 cmpa #RAMinUse is it in use?
 bne L0848 ..yes
 leay 32,y leave map ++
 bra L084F

* Free Ram:

L0847
 clra

* Ram Not in Use:

L0848
 ldb #32 count=32 pages ++
L084A
 sta ,y+ mark the ram
 decb
 bne L084A

L084F
 inc ,s
 ldb ,s
 cmpb #DAT.BlCt all blocks done?
 bcs L082F
L0857
 ldb R$A,u page count
L0859
 cmpy D.SysMem back to map start?
 bhi L0863 ..not yet
 comb
 ldb #E$NoRam was MemFul ++
 bra L0894

L0863
 lda ,-y free page?
 bne L0857 ..no,try again
 decb else got page+1
 bne L0859
 sty ,s
 lda 1,s
 lsra
 lsra
 lsra
 lsra
 lsra ++
 ldb 1,s
 andb #$1F ++
 addb R$A,u
 addb #$1F ++
 lsrb
 lsrb
 lsrb
 lsrb
 lsrb ++
 ldx D.SysPrc
 lbsr L09BE allocate ram images
 bcs L0894
 ldb R$A,u
L088A
 inc ,y+
 decb
 bne L088A
 lda 1,s
 std R$U,u return ptr to mem
 clrb
L0894
 leas 2,s
 rts


*------------------------------------------------*
*                    F$SRtMem
*------------------------------------------------*
f.srtmem
 ldd R$D,u
 beq L08F2
 addd #$00FF
 ldb R$U+1,u
 beq L08A6
 comb
 ldb #E$BPAddr 'Boundary Error'
 rts

L08A6
 ldb R$U,u
 beq L08F2
 ldx D.SysMem
 abx
L08AD
 ldb ,x
 andb #^RAMinUse
 stb ,x+
 deca
 bne L08AD
 ldx D.SysDAT
 ldy #DAT.BlCt 16 blocks/space
L08BC
 ldd ,x
 cmpd #DAT.Free free block?
 beq L08EC ..yes
 ldu D.BlkMap
 lda d,u
 cmpa #$01
 bne L08EC
 tfr x,d
 subd D.SysDAT
 aslb
 aslb
 aslb
 aslb ++
 ldu D.SysMem
 leau d,u
 ldb #32 16 blocks in sys space ++
L08DA
 lda ,u+
 bne L08EC
 decb
 bne L08DA
 ldd ,x
 ldu D.BlkMap
 clr d,u
 ldd #DAT.Free
 std ,x
L08EC
 leax 2,x
 leay -1,y
 bne L08BC
L08F2
 clrb
 rts


*------------------------------------------------*
*                    F$Boot
*------------------------------------------------*
f.boot
 comb
 lda D.Boot booted already?
 bne L0966 ..yes,rts.
 inc D.Boot flag it
 ldx D.Init X=init module
 beq L0908 ..use default if no Init
 ldd BootStr,x offset to Boot name
 beq L0908 ..none
 leax d,x X=Init BootStrap name
 bra L090C use it

L0908
 leax >bootnm,pcr default 'Boot' name
L090C
 lda #Systm+Objct
 os9 f$link get bootmodule
 bcs L0966 ..err rts
 jsr ,y do the boot
 bcs L0966 ..err
 STD D.BtSz Bootfile size ++
 STX D.BtPtr Boot start address ++
 leau d,x
 tfr x,d
 anda #$E0 ++
 clrb
 pshs a,b,u
 lsra
 lsra
 lsra
 lsra ++
 ldy D.SysDAT
 leay a,y
*------------------------------------------------*
* Find & Verify Boot Modules:

L092D
 ldd ,x get header
 cmpd #M$ID12 (87CD) is it a module?
 bne L0954 ..no
 tfr x,d
 subd ,s
 tfr d,x
 tfr y,d
 os9 f$vmodul
 pshs b
 ldd 1,s
 leax d,x
 puls b
 bcc L094E
 cmpb #E$KwnMod 'Known Module'?
 bne L0954 ..no
L094E
 ldd 2,x
 leax d,x
 bra L0956

L0954
 leax 1,x
L0956
 cmpx 2,s end of boot mem?
 bcs L092D ..no, try more
 leas 4,s
 LDX D.SYSDAT ++
 LDB 13,X ++
 INCB ++
 LDX D.BLKMAP ++
 LBRA L01DF ++

L0966
 rts


*------------------------------------------------*
*                    F$AllRam
*------------------------------------------------*
f.allram
 ldb R$B,u get # ram blocks desired
 bsr L0970
 bcs L096F
 std R$D,u
L096F
 rts

*------------------------------------------------*
L0970
 pshs a,b,x,y
 ldx D.BlkMap X=block map start

* Start at new block begin:

L0974
 leay ,x Y=start
 ldb 1,s B=count
L0978
 cmpx D.BlkMap+2 at end of block map?
 bcc L0995 ..yes,end.
 lda ,x+ is block free?
 bne L0974 ..no, try new start
 decb yes, count-1
 bne L0978 keep trying

L0983 tfr y,d D=begin block ptr ++
 subd D.BlkMap D=begin block number
 sta R$A-1,s return number on ,S
 lda R$B-1,s A=count
 stb R$B-1,s

* mark off blocks

L098D
 inc ,y+ mark as ram in use
 deca
 bne L098D
 clrb
 puls a,b,x,y,pc okay end.

L0995
 comb
 ldb #E$NoRam 'Sys Ram Full'
 stb 1,s return err
 puls a,b,x,y,pc bad end.

*------------------------------------------------*
*                    F$AlHRam
*------------------------------------------------*

F.ALHRAM LDB R$B,U get block count ++
 BSR L09A5 find blocks ++
 BCS L09A4 error ++
 STD R$D,U return count in D ++

L09A4 RTS ++

L09A5 PSHS A,B,X,Y match up stack ++
 LDX D.BLKMAP+2 point to end of map ++

L09A9 LDB R$B-1,S get block count ++

L09AB CMPX D.BLKMAP at bottom of map? ++
 BLS L0995 yes, error ++
 LDA ,-X block free? ++
 BNE L09A9 no ++
 DECB found them all? ++
 BNE L09AB no, continue ++
 TFR X,Y match up registers ++
 BRA L0983 allocate blocks ++

*------------------------------------------------*
*                    F$AllImg
*------------------------------------------------*
f.allimg
 ldd R$D,u A=begin blk#, B=# of blocks
 ldx R$X,u X=proc desc
L09BE
 pshs a,b,x,y,u
 asla
 leay P$DATImg,x Y=DAT image ptr
 leay a,y Y=image ptr
 clra
 tfr d,x
 ldu D.BlkMap
 pshs a,b,x,y,u
L09CD
 ldd ,y++ D=image
 cmpd #DAT.Free unused?
 beq L09E2 ..yes
 lda d,u else what is it?
 cmpa #RAMinUse ram?
 puls a,b
 bne L09F7 ..no

 subd #$0001
 pshs a,b
L09E2
 leax -1,x
 bne L09CD
 ldx ,s++
 beq L0A00
L09EA
 lda ,u+
 bne L09F2
 leax -1,x
 beq L0A00
L09F2
 cmpu D.BlkMap+2
 bcs L09EA

L09F7
 ldb #E$MemFul 'Proc Memory Full' (207)
 leas 6,s
 stb R$B-1,s
 comb
 puls a,b,x,y,u,pc

*------------------------------------------------*
L0A00
 puls x,y,u
L0A02
 ldd ,y++
 cmpd #DAT.Free
 bne L0A16
L0A0A
 lda ,u+
 bne L0A0A
 inc ,-u
 tfr u,d
 subd D.BlkMap
 std -2,y

L0A16
 leax -1,x
 bne L0A02
 ldx 2,s
 lda P$State,x get proc state &
 ora #ImgChg flag image change
 sta P$State,x .
 clrb
 puls a,b,x,y,u,pc


*------------------------------------------------*
*                    F$FreeHB
*------------------------------------------------*
f.freehb
 ldb R$B,u B=block count
 ldy R$llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S  X 3                                                                                                                                                                                                                                             
 peco0&94 4@O_Z&3041O'b3 'O' b'0'0 2d5c 1e0䦀'T
'P ',& "''&l4
'&5o
'" 00l
' ',' o 0c441č
oo00묩$
%9**** STACK OVERFLOW ****
04 d?o/9940040b&2d94@2wO_gO_eO_cO_a&  3A?'&?&c c& l  XIo0-&XIo0'm,qXIo0-&$XIo0-&c& =&2  XIo04g g -& a a 4g0& v:' nA:&9e =&e e & e e e e'e O_?& : r Q3A&ka'He040u40 ,42fe e'e O_c' c'O_ ? 2i54@40)40 ,4\2f 4C4@`2~ P E&
 <&
 ,&
 & g  ?' 04j4j4h2f&&04 4:2d442d&04 42d442d'.044I2d &40442f'.0442d &40u442f    2b54@0ǯ{O_{ { {O_ 04042d00 0O'@  0 0O&'W~&v~&~' O_'{{O_ 4 4042f~&Y54@?{ {{O_O_BO_D0p442d~'G44 42f~' \ & 44 4y2f~' X044-2d~'X44 4F2f~'6\ & 44 42f~&\ &{ s\'r 044 2d~'\ &Q B DD{{24@{0n44 z2d~''
B'O_  B 4@0>44F2d~' 54@{''{'' 4042d54@f 	d d3A'4'& p  l4@Qfd3 h403A42d~'d5d d& 44@f d0d4&&0 0O'O_5 54@d !0 0O'  f0f&O_54@  (4@0 4	2bh4h40 ,4d2fd42b5error unknown option %c
 error bad syntax %s
 ? syntax error no type string entered syntax error no machine string entered r unable to open input file '%s'
 w unable to open output file '%s'
 ifeq ifne if else endc 4@3 FO' h3M4@0 "  V54@h&~'FdHf+'f+&F F4r'd&   FBKD05O_54@d2|O_j j+&      0d h~' x'ٌ +' 
 \ <44@X2db' 4O_44h4
2h E44@N ʁ44@ 2db '2 O_  r' a' w' d' b2d54@O_4h4h4 K4@f4f42d&O_ 5O_ $4@h42bf4f42d~,O_ h4h44@2f54@0 4f42d0 4 
42d54@d2 g4b42d&2a54Ff 0 42b 
'&&O_ O_f2b54@f2|h b0
'03_~/l4?2bb&O_b&O_ h2d54@0 }0f4f 4@d}0h4h404(2f54@d}0h4h4042fO_}d54@f2u h';h42bh%&hO_bfh-&
 h O_h0& 0    f4 
	 4jfhh0 0O&h.&3 d b4 
4jbhh0 0O& O_dh&f404t f404 f4j0 0O404< f40404_ d& bf404f4n42f x0 }0id'8id 	'i ibb&f4kf4h442h /f4k h 2f404l42d44E2f9h42b, d'ӌ o' x' X' u'
 f' e' g' E'
 G' c' s'% l'n 2k54F0f,)f@P f,0D4042d  -0f4b42d 4vjO_bO_  l ll-0 d 6 ll,ll' bb' 0O_d dd 
&l 0O_j2f54F03fO 0fDVDVDVf& 
Į03_4@0#O_02b54V0b3hO4b 	/l' A  a  0hDVDVDVDVh& 
Įb0b3_4@0#O_0 4@fjhj&% 42bjj. 
42bhh&' 42bjj.54@fh44@2b@P h&% 42bhh. 
42b&' 42bhh.54@}4f4 2d54@d}0}5-32768 4@fF"'FO" &4@M2bFO'5 40g4H4FO@'0C 0$2f&JF F F_~&4@ 2b ă dD$FO@'d 
&4@ & d54@df44@ y4F2df44@;K4F3 O_ 
03M42b   - d4@d2~  'F& NFO'4@2b O_H42bO_F *4@d'FO" '5F_~&4@ 2b4@2b54@d2|F_~&#D'O_44@ 2b44H4
2hģBb' nF_~' cFO@'3B 'b44H42f&0d *bbb& )b4B4H42fb' 2F FD FFBKDO_2d54@54@d'FF_~&=D$ ă O*4@ n 4@f'FO'd'B"5dd54@d2|4@2bb'4@2b& b4 2d54@d2~F1'FO1 & 4@ 2b0 4&FO@'0 442bFO'%K4B4H4FO@'0F 0  40JB4H42f.F4b'    F B BDO2b54@dFO&-204H4O_42fF4b& @  F2 FFO'5K&FO@'   KB&K42bB'FF FF0JB KBKD54@e  0 ' 
e 0 5 d'ތ o'׌ x' 5 4@0 5 4@d&0d54@f2~f0& '4@f2~f0&0&f2b54@d f0f&O_53A4'45M&mb&c=b  54  44ei=beh=aa$ldi=aa$ldh=fhb2h9]'gbfcZ& 
]'dbfcZ&b4bd2d9]'hcibZ& ec'-'+'''	'4@?$5@h5@O_9f? ec'	'
f?4@hj?5@ۮbe?%?̮be?%O9c?be?be$?%O9&e&b?%v4B  3?5B$4?5\b?]c?%KO94 feh4 ?$
&O_550* 54 efh4 ? 4 h'ef?$5  54 h'ef? 4@j&     4 '% 'O05e?% 	e?%0hgf+e?%054d%'%
4 ? 5 $2b92b4d4O䧀%5b%!$4O$ 599O9%O_9 1b?9  b  ' d 
 
lx                               B                                                                                                                                                                              0               HHHHHHHHHH       BBBBBB      DDDDDD          
pecon L/llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? U   X 3!                                                                                                                                                                                                                                              "         upcas SF   U f? S   ? a zU eE? S   ?  S         ??      ?        =llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S(   sX 3)                                                                                                                                                                                                                                             s 
[  FwdBlocksMt40 K?%54
5Ƃ?%_?O_	940%	"04
=ab
=5/MTP
_lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll- S  X 31                                                                                                                                                                                                                                             
 OS9ge
Use (caution): os9gen </devname>
 ..reads (std input) pathnames until eof,
   merging paths into new OS9Boot file.
Can't find: 
ERROR - os9boot file not contiguous
 This disk will not bootstrap.
RENAME TempBoot OS9Boot
_ /&?%/'11Z*/@ 01?%/1/*1*014
?%i  @ ?%X O0Q ?%KӁ
'C?%+0Q ?% ?$&? 40Q ? &0O ?%   ?%  ?% î#%_? % 0Q ?% i&    ? % 0H ?% '"/1/*01?/1/*_0p
31?% S?% L]& G ab	   ? % &0H ?% ?%_ 0Y4 ?5?0_ 鰡lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S(   rX 39                                                                                                                                                                                                                                             r 
Z  FwdFilesMt40 K?%54
5Ƅ?%_?O_	940%	"04
=ab
=5/MTP
U;llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S)   sX 3A                                                                                                                                                                                                                                             s 
[  RevBlocksMt40 K?%54
5ƃ?%_?O_	940%	"04
=ab
=5/MTP
Dlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S)   rX 3I                                                                                                                                                                                                                                             r 
Z  RevFilesMt40 K?%54
5ƅ?%_?O_	940%	"04
=ab
=5/MTP
P$llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S)   9X 3Q                                                                                                                                                                                                                                             9 
!!   MtpF b&f&j&dƂ?%_9S89lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S)   9X 3Y                                                                                                                                                                                                                                             9 
!!   MtpF b&f&j&dƄ?%_9S89Ȑlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll? S)   9X 3a                                                                                                                                                                                                                                             9 
!!   MtpR b&f&j&dƃ?%_9S89wunlllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll