************************************************************
* Coyota - Boisy's Pick-Up Truck CoCo App
*
* This application was designed to run in my Toyota '92
* Pick-up truck using a CoCo 3 with Speech/Sound Pak.
*

         nam     GoCo
         ttl     Boisy's Pick-Up Truck CoCo App

Level    equ     2

         ifp1
         use     os9defs.l2v3
         use     scfdefs
         endc

rev      set     $00
edition  set     $01

* This timeout value is the number of ticks that this application
* will sleep for at startup.  This is necessary to give the audio
* amplifier time to warm up; we don't want audio being played 
* before we can hear it.
timeout  set     1

         mod     Size,Name,Prgrm+Objct,Reent+rev,Start,Fin

Name     fcs     "AutoEx"
         fcb     edition

JoyPath  rmb     1
SSCPath  rmb     1
HiResEnt rmb     2
TimePckt rmb     6
HiJoyNum rmb     2
HiButton rmb     2
HiJoyX   rmb     2
HiJoyY   rmb     2
ButtonL  rmb     1
JoyXL    rmb     2
JoyYL    rmb     2
InBuff   rmb     128
Stack    rmb     200
Fin      equ     .

Shell    fcc     "Shell"
CR       fcb     C$CR
JoyDev   fcs     "/v1"
SSCDev   fcs     "/ssp"
HiResMod fcc     "hires"
         fcb     C$CR
Bell     fcb     C$BELL

CopyrMsg fcb     C$CR,C$LF
         fcc     "Coyota V"
         fcb     48+edition
         fcc     "."
         fcb     48+rev
         fcb     C$CR,C$LF
         fcc     "(C) 1998 Planet 9 Systems"
         fcb     C$CR,C$LF,C$LF
         fcc     "1992 TOYOTA 1/2 Ton Pick-Up"
         fcb     C$CR,C$LF
         fcc     "VIN: 4TARN81A5NZ047604"
MenuMsg  fcb     C$CR,C$LF
         fcb     C$CR,C$LF
         fcc     "   1 - Say"
         fcb     C$CR,C$LF
         fcc     "   2 - Shell"
         fcb     C$CR,C$LF
CopyrML  equ     *-CopyrMsg
MenuML   equ     *-MenuMsg

* Version information -- spoken
VerMsg   fcc     "Coyowta Version "
         fcb     48+edition
         fcc     " point "
         fcb     48+rev
         fcb     C$CR
         fcc     "O S9 Levul 2 Version 3"
         fcb     C$CR
VerMsgL  equ     *-VerMsg

* VEHICLE information -- spoken
* "1992 Toyota half-ton pick-up"
IDMsg    fcc     "nine teen nine t2 Toyowta haf ton pick up"
         fcb     C$CR
         fcc     "VIN number 4T A R N81A5N Z047604"
         fcb     C$CR
IDMsgL   equ     *-IDMsg

       
Months   fdb     Jan-Months
         fdb     Feb-Months
         fdb     Mar-Months
         fdb     Apr-Months
         fdb     May-Months
         fdb     Jun-Months
         fdb     Jul-Months
         fdb     Aug-Months
         fdb     Sep-Months
         fdb     Oct-Months
         fdb     Nov-Months
         fdb     Dec-Months

* Months -- spoken
Jan      fcc     "January"
         fcb     C$CR
Feb      fcc     "Febuary"
         fcb     C$CR
Mar      fcc     "March"
         fcb     C$CR
Apr      fcc     "April"
         fcb     C$CR
May      fcc     "May"
         fcb     C$CR
Jun      fcc     "June"
         fcb     C$CR
Jul      fcc     "July"
         fcb     C$CR
Aug      fcc     "August"
         fcb     C$CR
Sep      fcc     "September"
         fcb     C$CR
Oct      fcc     "Octowber"
         fcb     C$CR
Nov      fcc     "November"
         fcb     C$CR
Dec      fcc     "December"
         fcb     C$CR

* Introduction message when powered on
StartMsg fcc     "System On-line"
         fcb     C$CR
StartML  equ     *-StartMsg


Start    equ     *
* Write Copyright Message
         lda     #1
         sta     SSCPath,u              assume stdout for now
         leax    CopyrMsg,pcr
         ldy     #CopyrML
         os9     I$Write

* Open a path to the Joystick device
         lda     #READ.+WRITE.		read/write mode
         leax    JoyDev,pcr		point to device name
         os9     I$Open			open it
         bcs     SOpen                  ignore error, data will go to stdout
         sta     JoyPath,u		..else save path

* Open a path to the Speech/Sound Pak
SOpen    lda     #WRITE.		write mode
         leax    SSCDev,pcr		point to device name
         os9     I$Open			open it
         bcs     TimeWait               ignore error, data will go to stdout
         sta     SSCPath,u		..else save path

* Wait for timeout
TimeWait ldx     #timeout
         os9     F$Sleep

* Send out welcome message
Welcome  lda     SSCPath,u
         leax    StartMsg,pcr		point to start msg
         ldy     #StartML		load max count
         os9     I$WritLn		write it
         lbcs    error			branch if error


* Command LOOP
*
* Supported key commands:
*   X=00, Y=00  - Say Vehicle Motto
*   X=00, Y=63  - Say Date
*   X=63, Y=00  - Say Vehicle ID information
*   X=63, Y=63  - Say Software Version information
*   Q  - Quit application

Loop
* Check for char waiting on keyboard
*         ldb     #SS.Ready
*         os9     I$GetStt
         lda     #1
         leax    MenuMsg,pcr
         ldy     #MenuML
         os9     I$Write
         bsr     ReadChar
* No char at this point, read joysticks
* Read right joystick port (hi-res mouse)
*         ldd     #0           right joystick port
*         lbsr    GetHiRes
* Read left joystick port (joystick)
         lda     JoyPath,u
         ldb     #SS.Joy
         ldx     #$0001
         os9     I$GetStt
         stx     JoyXL,u
         sty     JoyYL,u
         sta     ButtonL,u
         beq     Loop
         lbsr    ChkJoyX
         bra     Loop

Say      fcc     "Text: "
SayL     equ     *-Say

* Read character
ReadChar clra
         leax    InBuff,u
         ldy     #1
         os9     I$Read
         leax    CR,pcr
         os9     I$WritLn
         lda     InBuff,x
         cmpa    #'1
         bne     IsIt2
         lda     #1
         leax    Say,pcr
         ldy     #SayL
         os9     I$Write
         lbsr    SpeakTxt
         rts
IsIt2    cmpa    #'2
         bne     ReadEx
* Fork shell
         clra
         clrb
         leax    Shell,pcr
         ldy     #0
         leau    CR,pcr
         os9     F$Fork
         os9     F$Wait

ReadEx   rts

* Act upon button press
ChkJoyX  lda     JoyXL+1,u
         bne     ChkJoyY
         ldb     JoyYL+1,u
         beq     SayILove    X=00, Y=00
         cmpb    #63
         lbeq    SayDate     X=00, Y=63
* here, the joystick has no meaningful value
         rts 

* here, X != 0
ChkJoyY  cmpa    #63
         blt     Ret         if joystick X != 63, no meaningful value
         ldb     JoyYL+1,u
         beq     SayID       X=63, Y=00
         cmpb    #63
         beq     SayVrsn     X=00, Y=63
* here, the joystick has no meaningful value
Ret      rts 

         ifeq   1

* GetHiRes subroutine
* D  = Joystick port number (0 = right, 1 = left)
GetHiRes leas    -18,s
         std     HiJoyNum,u
         ldd     #4           set parameter count
         std     ,s
         ldd     #2           set param sizes (all 2)
         std     4,s
         std     8,s
         std     12,s
         std     16,s
         leax    HiJoyNum,u
         stx     2,s
         leax    HiJoyX,u
         stx     6,s
         leax    HiJoyY,u
         stx     10,s
         leax    HiButton,u
         stx     14,s
         jsr     [HiResEnt,u]
         leas    18,s
         rts

         endc

ILove    fcc     "I love what u do 4 me Toyowta"
         fcb     C$CR
ILoveL   equ     *-ILove

* Speak "I love what you do for me"
SayILove lda     SSCPath,u
         leax    ILove,pcr
         ldy     #ILoveL
         os9     I$Write
         rts

* Speak version information
SayVrsn  lda     SSCPath,u
         leax    VerMsg,pcr
         ldy     #VerMsgL
         os9     I$Write
         rts

* Speak vechicle's ID information
SayID    lda     SSCPath,u
         leax    IDMsg,pcr
         ldy     #IDMsgL
         os9     I$Write
         rts

* Read a line of input from standard in and write it out
* A = path to read from
SpeakTxt leax    InBuff,u
         ldy     #80
         os9     I$ReadLn
         lda     SSCPath,u
         os9     I$WritLn
         rts

SayDate  leax    TimePckt,u
         os9     F$Time
         bcs     SayDateX
* Say month
*         lda     1,x
*         deca
*         asla
*         leax    Months,pcr
*         ldd     a,x
*         leax    d,x
*         lda     SSCPath,u
*         ldy     #80
*         os9     I$WritLn

* Say day
*         leax    InBuff,u
*         leay    TimePckt,u
*         ldb     2,y
*         bsr     Str2Num
*         tfr     y,d
*         leax    d,x
*         lda     #C$CR
*         sta     ,x
*         leay    1,y
*         leax    InBuff,u
*         lda     SSCPath,u
*         os9     I$WritLn

* Say hour
         leax    InBuff,u
         leay    TimePckt,u
         ldb     3,y
         bsr     Str2Num
         tfr     y,d
         leax    d,x
         lda     #C$CR
         sta     ,x
         leay    1,y
         leax    InBuff,u
         lda     SSCPath,u
         os9     I$WritLn

* Say minute
         leax    InBuff,u
         leay    TimePckt,u
         ldb     4,y
         bsr     Str2Num
         tfr     y,d
         leax    d,x
         lda     #C$CR
         sta     ,x
         leay    1,y
         leax    InBuff,u
         lda     SSCPath,u
         os9     I$WritLn

SayDateX rts

exit     clrb				no error, clear B
error    os9     F$Exit			exit


************************************************************
* Str2Num:  Converts a one byte representation to its string
*           counterpart in the range of 0-255.
*
*  Entry:  X  - Address to store text digits
*          B  - Byte to convert
*
*  Exit:   Y  - Length of numerical string
*
Str2Num  pshs  a,b,x
         ldy   #$0000
         lda   #$2f
         inca
p1       subb  #$64
         bcc   p1
         sta   ,x+
         leay  1,y
         cmpa  #$30
         bne   p2
         leax  -1,x
p2       lda   #$3a
p3       deca
         addb  #$0a
         bcc   p3
         sta   ,x+
         addb  #$30
         stb   ,x+
         leay  1,y
         puls  pc,a,b,x

         emod
size     equ     *
         end

