         nam   REL
         ttl   os9 system module

         ifp1
         use   defsfile
         endc

Bt.Start equ   $ED00
ScStart  equ   $8008      screen start in memory
XX.Size  equ   6          number of bytes before REL actually starts
Offset   equ   Bt.Start+XX.Size

tylg     set   Systm+Objct
atrv     set   ReEnt+rev
rev      set   $01

********************************************************************
* Any changes to the next 3 lines requires changes in XX.Size, above
         fcc   /OS/                   sync bytes
         bra   Start+XX.Size  execution start
         fdb   $1205                  filler bytes

         mod   eom,name,tylg,atrv,start,size

         org   0
size     equ   .                       REL doesn't require any memory

name     fcs   /REL/
         fcb   $05

BootMsg  fcc   /OS/
         fcb   $79
         fcb   $60
         fcc   /BOOT/
FailMsg  fcc   /FAILED/

CC3Regs  fcb   $EC CC2, MMU, IRQ, Vector page, SCS
         fcb   $00 map type 0
         fcb   $00 no FIRQ
         fcb   $00 no IRQ
         fdb   $0900 timer
         fcb   $00 unused
         fcb   $00 unused
         fcb   $00
         fcb   $00
         fcb   $00
         fcb   $00
         fdb   $0FE0
         fcb   $00
         fcb   $00

DefPals  fcb   $12,$36,$09,$24,$3F,$1B,$2D,$26
         fcb   $00,$12,$00,$3F,$00,$12,$00,$26

* D.Crash
CrashRtn clr   >$FF91                  go to map type 0
*                                      called by CC3Go from map 1
         jmp   >Offset+crash

         fcb   $00                     warm start flag
         fdb   $0074                   go to $0074, next routine
* reset vector: map ROMs out and go to REL in the default DECB block map,
* which is still block $3F at the top fo memory
         nop                           required for the ROMs to believe
*                                      it's a reset vector
         clr   >$FFDF                  go to all RAM mode
         jmp   >Offset+reset and re-start the boot

crash
         fcb   $C6,$01,$20,$07,$4F
         fcb   $53,$20,$5B,$12,$05

reset
start    clrb
         orcc  #FIRQMask+IRQMask       turn off IRQ's
         clr   >$FF03                  turn off SAM IRQ's
         clra
         tfr   a,dp                    set direct page to $0000
         sta   <D.CbStrt
         sta   $FFA0                   map in block 0
         lds   #$1FFF                  set stack to the end of the block
         pshs  b
         ldb   #$E0
         ldx   #$0020
L0072    sta   ,x+                     clear out the direct page
         decb
         bne   L0072
         inca
         sta   <D.Speed                hi speed
         sta   >$FFD9                  set to high speed
         leau  CC3Regs,pcr             point to the video setup data
         ldx   #$0090                  set video mapping
L0084    ldd   ,u++                    get the bytes
         std   >-$100,x                save in the hardware
         std   ,x++                    and in the direct page
         cmpx  #$00A0                  end of video hardware yet?
         bcs   L0084

* set up palettes
         leau  >DefPals,pcr
         ldy   #$FFB0
         ldb   #16
         bsr   CopyRtn

         lda   #$3E
         sta   >$FFA4                  map in the block
         ldx   #$8000                  start of the block
         clrb
         ldu   #$6060                  clear out screen mem
L00A9    stu   ,x++
         decb
         bne   L00A9

* show OS-9 boot message
         ldy   #$810C
         leau  BootMsg,pcr
         ldb   #8
         bsr   CopyRtn

         ldb   #5
         ldx   #$FFC6
L00BF    sta   ,x++
         decb
         bne   L00BF
         sta   $01,x
         sta   $03,x
         ldb   ,s
         beq   L00DD

* boot failed
         ldy   #$814D
         leau  >FailMsg,pcr
         ldb   #$06
         bsr   CopyRtn                 show failed message
         clr   >$FF40                  shut off disk motor
L00DB    bra   L00DB                   dead loop forever

L00DD    leax  >L00DD,pcr
         cmpx  #$ED00                  warm start?
         bcc   L0101                   yep...
         ldu   #$2600                  else copy at $2600...
         ldx   #$1200                  $1200 bytes...
         ldy   #$ED00                  ...to $ED00
         bsr   L00F8
         jmp   >$EE07                  jump!

* Copies B bytes from ,U to ,Y
CopyRtn  clra
         tfr   d,x
L00F8    ldb   ,u+
         stb   ,y+
         leax  -1,x
         bne   L00F8
         rts

L0101    leau  >CrashRtn,pcr
         ldb   #16
         ldy   #$006B
         bsr   CopyRtn
         leax  <eom,pcr
         ldd   M$Size,x
         leax  d,x
         ldd   M$Exec,x
         jmp   d,x

         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts
         rts

         emod
eom      equ   *
         end
