********************************************************************
* ROMInfo - OS-9 Level One ROM boot module
*
* $Id: rominfo.asm,v 1.1.1.1 2001/02/21 23:30:52 boisy Exp $
*
* ROM Relocation code for OS-9 Level One Vr. 2.00
* Executed at $8015 from ROM
*
* Ed.    Comments                                       Who YY/MM/DD
* ------------------------------------------------------------------
* 1      Created                                        BGP 98/05/03

         nam   ROMInfo
         ttl   OS-9 Level One ROM boot module

         ifp1
         use   defsfile
         endc

tylg     set   Systm+Objct
atrv     set   ReEnt+rev
rev      set   $01
edition  set   $01

         mod   eom,name,tylg,atrv,start,size

size     equ   .

name     fcs   /ROMInfo/
         fcb   edition

start    equ   *
CCInit   ldx   #$FF20                  PIA 1
         clr   -3,x                    ????
         clr   -1,x                    ????
         clr   -4,x                    set side A to input
         ldd   #$FF34
         sta   -2,x                    set side B to output
         stb   -3,x
         stb   -1,x
         clr   1,x                     $FF20 = DDR, motoroff
         clr   3,x                     $FF22 = DDR, sound disabled
         deca                          A = $FE after deca
         sta   ,x
         lda   #$F8
         sta   2,x                     VDG OUTPUT
         stb   1,x                     $FF20 = DIO
         stb   3,x                     $FF22 = DIO
         clr   2,x
         ldb   #$02
         stb   ,x
         clrb
         tfr   b,dp                    B = 0
         ldb   #$04
         clr   -2,x
         bitb  2,x

         lda   #$37
         sta   $FF23

         lda   $FF03
         ora   #$01
         sta   $FF03

         lda   $FF22
         anda  #$07
         sta   $FF22

* VDG Mode
         sta   $FFC0
         sta   $FFC2
         sta   $FFC4

* 64K DRAM (M0=0, M1=1)
         sta   $FFDA                   RESET M0
         sta   $FFDD                   SET   M1

* ROM relocation code -- copies the boot track into $2600
RelROM   ldx   #$AE00                  src address (ROM)
         ldy   #$2600                  dst address (RAM)
copyloop ldd   ,x++                    get 2 bytes from src
         std   ,y++                    put 2 bytes to dst
         cmpx  #$AE00+$1200            at end?
         blo   copyloop                nope, copy more...
* BOOT relocation code -- copies the bootfile into $2600+$1200
RelBOOT  ldx   #$8000
         ldy   #$2600+$1200
cpy2loop ldd   ,x++
         std   ,y++
         cmpx  #$8000+$2E00
         blo   cpy2loop
         jmp   $2602                   jump to OS rel code

         emod
eom      equ   *
         end
