******************************************************************
*                                                                *
         nam  Date
         ttl  OS9 Date/Time Display Utility
*                                                                *
* This is a Y2K-compliant revision of the 'date' utility         *
* supplied with OS9 Level 2.  It assumes that the system clock   *
* will simply continue to increase the D.YEAR byte annually      *
* even after it passes 100.  Written by Richard S. Bair on       *
* February 11, 1999.                                             *
* Good 'til the year 2156!                                       *
*                                                                *
******************************************************************
*
* include definitions in pass 1
         ifp1
         use  /d0/DEFS/os9defs
         endc
*
         mod  CSIZE,NAME,TYPE,ATRV,START,DSIZE
NAME     fcs  /Date/
EDITION  fcb  $04
TYPE     set  Prgrm+Objct
REVS     set  $02
ATRV     set  ReEnt+REVS
*
* variable data storage area
*
YEAR     rmb  1 storage
MONTH    rmb  1 for data
DAY      rmb  1 supplied
HOUR     rmb  1 by OS9's
MINUTE   rmb  1 F$Time
SECOND   rmb  1 user system call
STRPNTR  rmb  2 pointer to ASCII date
DATESTR  rmb  40 ASCII date & time string
         rmb  250 storage space for stack
         rmb  150 storage space for parameters
DSIZE    equ  .
*
* storage area for constants
*
MONTHNAM fcs  "??? "
         fcs  "January "
         fcs  "February "
         fcs  "March "
         fcs  "April "
         fcs  "May "
         fcs  "June "
         fcs  "July "
         fcs  "August "
         fcs  "September "
         fcs  "October "
         fcs  "November "
         fcs  "December "
*
* code area
*
START    equ  *
*
         pshs x Save pointer to parameters.
         leax YEAR,u Set pointr for syscall outpt.
         leau DATESTR,u Set pointr to date/tim strng.
         stu  STRPNTR Save it for now.
         os9  F$Time Get data from system.
         bsr  DODATE Write date to ASCII string.
         lda  [,s++] Get a byte from param area.
         eora #$54 Is it 'T'?
         anda #$DF or 't'?
         bne  FINISHUP If not, skip time routine.
         ldd  #$2020 If so, add two spaces
         std  ,u++ to output string,
         bsr  DOTIME go to time subroutine.
FINISHUP lda  #$0D Append a
         sta  ,u+ carriage return,
         lda  #$01 set standard output path,
         ldx  STRPNTR set pointer to string,
         ldy  #$0028 set max string length,
         os9  I$WritLn write it out.
         bcs  EXIT If error, pass to caller,
         clrb else clear errorcode registr.
EXIT     os9  F$Exit Bye.
*
DOTIME   ldb  HOUR Get hours,
         bsr  TOASCII convert to ASCII & write.
         ldb  MINUTE Get minutes,
         bsr  ADDCOLON add :, convert & write.
         ldb  SECOND Get seconds,
ADDCOLON lda  #$3A This is a colon;
         sta  ,u+ write it to string,
         bra  TOASCII convert, write, and return.
*
DODATE   leay MONTHNAM,pcr Point to month names.
         ldb  MONTH Get month byte,
         beq  WRITMNTH if not greater than 0 and
         cmpb #$0C less than 13, then
         bhi  WRITMNTH write '??? ',
LOOP1    lda  ,y+ otherwise step through
         bpl  LOOP1 month names counting
         decb set sign bits to find
         bne  LOOP1 the right name,
WRITMNTH bsr  WRITSTRN add it to output string.
         ldb  DAY Get days, convert
         bsr  TOASCII to ASCII, add to string.
         ldd  #$2C20 Follow day with
         std  ,u++ ', '.
         lda  #18-100 Start with 1800,
         ldb  YEAR get year byte.
LOOP2    inca Add a century,
         subb #100 reduce byte by same,
         bcc  LOOP2 loop if it's not yet negatve.
         stb  YEAR Store remainder temporarily.
         tfr  a,b Put century count in b,
         bsr  SKIP1 convert to ASCII and write.
         ldb  YEAR Retrieve 10's & 1's info,
         bra  SKIP1 convert it and write it.
TOASCII  subb #$64 Reduce number by 100,
         bcc  TOASCII loop if it's not yet negatve.
SKIP1    lda  #$3A Start with ASC(9)+1 for 10's,
LOOP3    deca digit; reduce by 1.
         addb #$0A Add a group of 10.
         bhs  LOOP3 If still negative, loop.
         sta  ,u+ else add 10's digit to strng.
         addb #$30 Convert 1's digit to ASCII,
         stb  ,u+ add it to string.
         rts
*
WRITSTRN lda  ,y Get a byte,
         anda #$7F make sure sign bit is off,
         sta  ,u+ add it to string.
         lda  ,y+ Look at same byte again,
         bpl  WRITSTRN if its sign bit is off, loop,
         rts else return.
*
         emod  Append CRC bytes.
CSIZE    equ  *