****************************************************************
*                                                              *
         nam  Asm
         ttl  Program Module       
*                                                              *
* This is a Y2K-compliant revision of the 'asm' assembler      *
* program supplied with OS9 Level 1.  Headers of listings show *
* a 4-digit year in the range 1900 - 2155.  Revision and       *
* partial commenting by Richard S. Bair, April 6, 1999.        *
*                                                              *
****************************************************************
*
         ifp1
         use  os9defs
         endc
*
         mod  CSIZE,NAME,TYPE,ATRV,START,DSIZE
NAME     fcs  /Asm/
EDITION  fcb  $05
TYPE     set  Prgrm+Objct
REVS     set  $02
ATRV     set  ReEnt+REVS
*
* variable storage area
*
INBUFPTR rmb  2 Points to beg of input buffer
HDOUTPTR rmb  2 Points to header outstring
OUTSTPTR rmb  2 Points to body outstring
USTAKPTR rmb  2 Points to bottom of u stack
         rmb  2
         rmb  2
         rmb  2
CODBFPTR rmb  2 Points to exec. code buffer
         rmb  2
ENDATPTR rmb  2 Points to end of data area
STKBTPTR rmb  2 Points to bottom of s stack
         rmb  2
INPATHNO rmb  1 Path # of input (file)
EOTPTHNO rmb  1 Path # of module output
LOTPTHNO rmb  1 Path # of listing output
CODEFNGR rmb  2 Position in code buffer
STABLPTR rmb  2 Points to beg. of symbl tabl
USTKTPTR rmb  2 Points to top of u stack
         rmb  1
WARNGCNT rmb  2 Count of warnings
CDBYTCNT rmb  2 Count of code/constant bytes
DBYTCNT  rmb  2 Count of data bytes reserved
ERRORCNT rmb  2 Error count
         rmb  1
         rmb  1
         rmb  1
         rmb  8
LINSLEFT rmb  1 Count of lines left on page
LINPRPAG rmb  1 Lines/page (default=66)
PAGWIDTH rmb  1 Columns/line (def.=80)
         rmb  2
PAGENMBR rmb  2 Current listing page no.
         rmb  2
PASSNMBR rmb  1 Pass count
         rmb  1
         rmb  2
         rmb  2
         rmb  2
         rmb  1
         rmb  3
         rmb  2
         rmb  1
         rmb  1
         rmb  1
         rmb  1
         rmb  1
CRC      rmb  3 running CRC of code module
         rmb  1
         rmb  1
L1FLAG   rmb  1
L2FLAG   rmb  1 Default = no listing
OFLAG    rmb  1 Default = no module output
FFLAG    rmb  1 Def. = don't use form feed
MFLAG    rmb  1 Def. = not Motorola mode
GFLAG    rmb  1 Def. = truncate const. lines
EFLAG    rmb  1 Def. = show error messages
IFLAG    rmb  1 Def. = no prompt for .0 input
SFLAG    rmb  1 Def. = don't show symbol tabl
CFLAG    rmb  1 Def. = display conditnl lines
NFLAG    rmb  1 Def. = not narrow listing
         rmb  2
         rmb  2
         rmb  1
         rmb  $15A Space for s stack
STACKBOT equ  .
         rmb  9
         rmb  $51
HDOUTSTR rmb  $85 Space for header string
OUTSTRNG rmb  $92 Body string + u stack
USTAKBOT equ  .
         rmb  $50
         rmb  $28
CODEBUFR rmb  $100
         rmb  $34
         rmb  $0B23
DSIZE    equ  .
*
* code/constants area
*
START    equ  *
         tfr  u,d Points to start of data area
         addd #STACKBOT Calculate various
         std  STKBTPTR permanent pointers
         std  <$16 and record
         addd #$0009 them in the
         std  INBUFPTR appropriate
         addd #$0051 locations.
         std  HDOUTPTR
         addd #$0085
         std  OUTSTPTR
         addd #$0092
         std  USTAKPTR
         std  USTKTPTR
         std  <$08
         addd #$0050
         std  <$0A
         addd #$0028
         std  CODBFPTR
         addd #$0100
         std  <$10
         addd #$0034
         std  STABLPTR
         leau -$01,Y
         stu  ENDATPTR
         lds  STKBTPTR Relocate the stack.
*
         clra Now initialize  
         ldb  #$01 various flags
         sta  FFLAG with either
         sta  GFLAG zeros or ones.
         sta  SFLAG
         sta  IFLAG
         stb  EFLAG
         sta  OFLAG
         sta  MFLAG
         stb  CFLAG
         sta  NFLAG
         sta  PASSNMBR
         sta  INPATHNO Default input is stdin.
         sta  EOTPTHNO This means no path yet.
         stb  LOTPTHNO Def. listing output = stdout.
         ldb  #$FF
         stb  L1FLAG
         sta  L2FLAG Default = no listing.
         ldb  #$42 Default: 66
         stb  LINPRPAG lines per page
         ldb  #$50 Default: 80
         stb  PAGWIDTH columns per line
*
         lbsr L1696 Do params/switches, open I/O.
         lda  L1FLAG Check first listing flag.
         bmi  SKIP1 If still negative, skip;
         inc  L2FLAG else set flag to do listing.
SKIP1    ldx  <$08 Mark
         clr  ,x these strings
         ldx  <$0A to be
         clr  ,x empty.
         ldx  <$10 Zero out from here
LOOP1    clr  ,x+ to
         cmpx ENDATPTR end of
         bls  LOOP1 data area.
         ldb  IFLAG Want keyboard input prompt?
         beq  HEART If not, proceed normally.
         dec  PASSNMBR Else indicate pass 0,
         bra  PASS2 build input file from term.
*
HEART    bsr  INTOLOOP Do pass 1.
         lbsr RESETPTR Go to beg. of input file.
         inc  PASSNMBR Flag: pass 2
PASS2    bsr  INTOLOOP Now do pass 2.
         lbra FINSHUP Tidy up and exit.
*
INTOLOOP bsr  LOOPINIT Set various variables.
LINELOOP lbsr READLINE Get a line of source code.
         bcc  SKIP2 If no error, proceed.
         rts Else return.   
SKIP2    bsr  PROCSLIN Process this line and
         bra  LINELOOP loop for next one.
*
LOOPINIT clra Initialize
         clrb variables
         std  ERRORCNT for
         std  WARNGCNT this run.
         std  DBYTCNT
         std  CDBYTCNT
         std  <$40
         std  <$42
         stb  <$3F
         stb  <$55
         stb  <$54
         incb 
         std  PAGENMBR
         std  <$38
         ldd  CODBFPTR Start of code buffer
         std  CODEFNGR is where to write.
         lbsr STARTCRC Initialize CRC bytes.
         lbsr L141A Write header (if pass 2).
         rts   
*
PROCSLIN clra  
         clrb 
         std  <$4A
         std  <$61
         std  <$63
         sta  <$65
         sta  <$46
         sta  <$2A
         sta  <$21
         sta  <$4C
         sta  <$2C
         sta  <$4F
         sta  <$4E
         sta  <$4D
         lda  #$35
         sta  <$2B
         ldd  <$40
         std  <$44
         ldx  INBUFPTR
         lda  ,X
         cmpa #$0D
         beq  L0136
         cmpa #$2A A '*' (comment line)?
         beq  L0136
         cmpa #$20 A space?
         beq  L0125
         ldb  <$2B
         orb  #$08
         stb  <$2B
         lbsr L0368
         bcc  L0119
         ldb  #$01
         lbsr PRINTERR
         bra  L0125
L0119    tst  <$54
         bne  L0125
         lbsr L0F4A
         bcc  L0125
         lbsr PRINTERR
L0125    lbsr SKIPSPAC
         cmpa #$0D
         bne  L0141
         lda  <$2B
         bita #$08
         beq  L0136
         lda  #$09
         bra  L0138
L0136    lda  #$80
L0138    sta  <$2B
         lda  <$54
         bne  L018E
         lbra L01F2
L0141    stx  <$2F
L0143    lda  ,X+
         cmpa #$0D
         beq  L0150
         cmpa #$20
         bne  L0143
         lbsr SKIPSPAC
L0150    stx  <$31
         ldx  <$2F
         ldb  #$74
         leay INSTTABL,pcr Point to instruct'n table.
         lbsr L0344
         bcc  L0172
L015F    ldb  #$02
         lbsr PRINTERR
         ldb  #$03
         stb  <$46
         lda  <$2B
         anda #$DF
         sta  <$2B
         ldx  <$31
         bra  L01C4
L0172    lda  <$54
         beq  L0195
         ldb  $01,Y
         andb #$0F
         cmpb #$0D
         bne  L0181
         inca 
         bra  L018C
L0181    cmpb #$0E
         bne  L018E
         deca 
         beq  L0195
         ldb  ,Y
         bne  L018E
L018C    sta  <$54
L018E    inc  <$39
         bne  L0194
         inc  <$38
L0194    rts   
*
L0195    ldd  ,Y
         sta  <$62
         stb  <$47
         lda  #$10
         bitb #$10
         bne  L01A7
         lda  #$11
         bitb #$20
         beq  L01AB
L01A7    sta  <$61
         inc  <$46
L01AB    leay VECTTABL,pcr Point to vector table.
         andb #$0F Mask upper nibble,
         aslb *2 to get vector offset,
         ldd  b,y pick up desired vector.
         jsr  d,y Go do that procedure.
         lda  <$2B
         bita #$20
         beq  L01C4
         lda  ,X
         clr  ,X+
         cmpa #$0D
         beq  L01D3
L01C4    lbsr SKIPSPAC
         cmpa #$0D
         beq  L01D3
         ldb  <$2B
         beq  L01D3
         orb  #$40
         stb  <$2B
L01D3    ldb  IFLAG
         beq  L01DB
         ldb  <$21
         bne  L01F2
L01DB    ldd  <$40
         addb <$46
         adca #$00
         std  <$40
         bra  L01F2
*
L01E5    ldd  #$2084 A space and a counter
         ldx  OUTSTPTR Point to beginning of string,
LOOP2    sta  ,x+ put a space
         decb into $84 = 132 bytes.
         bne  LOOP2 Loop until finished.
L01EF    ldx  OUTSTPTR Reset pointer to beginning,
         rts return.
*
L01F2    ldb  PASSNMBR
         beq  L01EF
         ldb  <$2B
         beq  L01EF
         bsr  L01E5
         tst  NFLAG
         bne  L0205
         ldd  <$38
         lbsr BINTODEC
L0205    ldb  <$2B
         bitb #$80
         beq  L0213
         ldb  #$0D
         ldy  INBUFPTR
         lbra L02AB
L0213    bitb #$01
         beq  L0240
         lda  #$45
         ldb  <$21
         bne  L022F
         lda  #$44
         ldb  <$2C
         bne  L022F
         lda  #$57
         ldb  <$4F
         beq  L0236
         inc  WARNGCNT+1
         bne  L022F
         inc  WARNGCNT
L022F    ldb  #$06
         lbsr L02E2
         sta  ,X
L0236    ldb  #$08
         lbsr L02E2
         ldd  <$44
         lbsr L1057
L0240    ldb  <$2B
         bitb #$04
         beq  L0272
         ldb  <$46
         beq  L0272
         ldb  #$61
         tfr  DP,A
         tfr  D,U
         ldb  ,U+
         bne  L0256
L0254    ldb  ,U+
L0256    pshs B
         lbsr L106B
         puls A
         ldb  IFLAG
         beq  L0265
         ldb  <$21
         bne  L026E
L0265    lbsr L130D
         inc  CDBYTCNT+1
         bne  L026E
         inc  CDBYTCNT
L026E    dec  <$46
         bne  L0254
L0272    ldy  INBUFPTR
         ldb  <$2B
         bitb #$08
         beq  L0281
         ldb  #$18
         bsr  L02E2
         bsr  L02C9
L0281    ldb  <$2B
         bitb #$10
         beq  L028F
         ldb  #$21
         bsr  L02E2
         bsr  L02C9
         leay $01,Y
L028F    ldb  <$2B
         bitb #$20
         beq  L02A3
         ldb  #$27
         bsr  L02E2
         ldy  <$31
         lbsr L11BD
         lda  #$20
         sta  ,X+
L02A3    ldb  <$2B
         bitb #$40
         beq  L02B7
         ldb  #$32
L02AB    bsr  L02E2
*
L02AD    lda  ,y+ Get a byte;
         cmpa #$0D A C.R.?
         beq  L02B7 Exit loop if so.
         sta  ,x+ Else transfer the byte
         bra  L02AD and loop to repeat.
*
L02B7    ldb  <$2B
         andb #$BF
         cmpb #$04
         beq  L02C8
         lbsr L1370
         inc  <$39
         bne  L02C8
         inc  <$38
L02C8    rts   
*
L02C9    lda  ,Y+
         cmpa #$20
         beq  L02C9
L02CF    cmpa #$0D
         beq  L02DF
         cmpx USTKTPTR
         bcc  L02D9
         sta  ,X+
L02D9    lda  ,Y+
         cmpa #$20
         bne  L02CF
L02DF    leay -$01,Y
         rts   
*
L02E2    pshs U
         tst  NFLAG
         beq  L02EC
         leax $01,X
         bra  L02F8
L02EC    ldu  OUTSTPTR
         leau B,U
         pshs U
         cmpx ,S++
         bcc  L02F8
         tfr  U,X
L02F8    puls PC,U
*
PRINTERR    pshs u,y,x,b,a Save registers.
         tst  EFLAG Print error messages?
         beq  L0325 If not, skip.
         leay ERRNOTC,pcr Point to '***** Error:'.
         ldx  OUTSTPTR and to beg. of outstring.
         lbsr L11BD Copy alert over.
         clra   Now calculate the
         decb  offset into the
         aslb  error message chart.
         leay ERRCHART,pcr Point to start of it,
         ldd  d,y get loc. of correct message.
         leay d,y Point to it,
         lbsr L11BD copy the message over.
         ldb  $01,s Retrieve orig. error #.
         cmpb #$18 Does it need a filename?
         bne  L0322 If not, skip.
         ldy  $02,s Else retrieve pointer to
         bsr  L033D name, append it to outstring.
L0322    lbsr L1368 Write it if flags say to.
L0325    inc  <$21
         inc  ERRORCNT+1 Tally error in LSB,
         bne  L032D if necessary
         inc  ERRORCNT increase MSB.
L032D    puls a,b,x,y,u,pc Restore regs. and return.
*
         lbsr L01E5 No label here??
         ldb  #$18
         bsr  L02E2
         ldy  INBUFPTR
         bra  L033D
L033B    sta  ,X+
L033D    lda  ,Y+
         cmpa #$0D
         bne  L033B
         rts   
*
L0344    pshs X,B
L0346    lda  ,Y+
         bmi  L035E
         eora ,X+
         anda #$DF
         beq  L0346
L0350    lda  ,Y+
         bpl  L0350
L0354    leay $02,Y
         ldx  $01,S
         decb 
         bne  L0346
         comb 
         puls PC,X,B
*
L035E    eora ,X+
         anda #$5F
         bne  L0354
         leas $03,S
         clrb 
         rts   
*
L0368    lbsr SKIPSPAC
         bsr  L03A0
         bcs  L03B7
         pshs U,Y
         ldu  <$16
         ldb  #$08
         leax $01,X
         bra  L0393
*
L0379    lda  ,X+
         bsr  L03A0
         bcc  L0393
         cmpa #$39
         bhi  L039A
         cmpa #$30
         bcc  L0393
         cmpa #$2E
         beq  L0393
         cmpa #$24
         beq  L0393
         cmpa #$5F
         bne  L039A
L0393    sta  ,U+
         decb 
         bne  L0379
         bra  L039C
L039A    leax -$01,X
L039C    clr  ,U+
         puls PC,U,Y
*
L03A0    cmpa #$41
         bcs  L03B5
         cmpa #$5A
         bhi  L03AD
L03A8    anda #$5F
         andcc #$FE
         rts   
L03AD    cmpa #$61
         bcs  L03B5
         cmpa #$7A
         bls  L03A8
L03B5    orcc #$01
L03B7    rts   
*
INSTTABL fcs  /ORG/
         fdb  $000C
         fcs  /ENDC/
         fdb  $000E
         fcs  /LBRA/
         fdb  $1600
         fcs  /LBSR/
         fdb  $1700
         fcs  /ORCC/
         fdb  $1A01
         fcs  /ANDCC/
         fdb  $1C01
         fcs  /CWAI/
         fdb  $3C01
         fcs  /ADDD/
         fdb  $C302
         fcs  /SUBD/
         fdb  $8302
         fcs  /LDD/
         fdb  $CC02
         fcs  /LDX/
         fdb  $8E02
         fcs  /LDU/
         fdb  $CE02
         fcs  /CMPX/
         fdb  $8C02
         fcs  /JSR/
         fdb  $8D42
         fcs  /STD/
         fdb  $CD42
         fcs  /STX/
         fdb  $8F42
         fcs  /STU/
         fdb  $CF42
         fcs  /CMPU/
         fdb  $8322
         fcs  /CMPS/
         fdb  $8C22
         fcs  /CMPD/
         fdb  $8312
         fcs  /CMPY/
         fdb  $8C12
         fcs  /LDY/
         fdb  $8E12
         fcs  /LDS/
         fdb  $CE12
         fcs  /STY/
         fdb  $8F52
         fcs  /STS/
         fdb  $CF52
         fcs  /ADD/
         fdb  $8B03
         fcs  /CMP/
         fdb  $8103
         fcs  /SUB/
         fdb  $8003
         fcs  /SBC/
         fdb  $8203
         fcs  /AND/
         fdb  $8403
         fcs  /BIT/
         fdb  $8503
         fcs  /LD/
         fdb  $8603
         fcs  /ST/
         fdb  $8743
         fcs  /EOR/
         fdb  $8803
         fcs  /ADC/
         fdb  $8903
         fcs  /OR/
         fdb  $8A03
         fcs  /NEG/
         fdb  $0004
         fcs  /COM/
         fdb  $0304
         fcs  /LSR/
         fdb  $0404
         fcs  /ROR/
         fdb  $0604
         fcs  /ASR/
         fdb  $0704
         fcs  /LSL/
         fdb  $0804
         fcs  /ASL/
         fdb  $0804
         fcs  /ROL/
         fdb  $0904
         fcs  /DEC/
         fdb  $0A04
         fcs  /INC/
         fdb  $0C04
         fcs  /TST/
         fdb  $0D04
         fcs  /JMP/
         fdb  $0E44
         fcs  /CLR/
         fdb  $0F04
         fcs  /RTS/
         fdb  $3905
         fcs  /MUL/
         fdb  $3D05
         fcs  /NOP/
         fdb  $1205
         fcs  /SYNC/
         fdb  $1305
         fcs  /DAA/
         fdb  $1905
         fcs  /SEX/
         fdb  $1D05
         fcs  /ABX/
         fdb  $3A05
         fcs  /RTI/
         fdb  $3B05
         fcs  /SWI2/
         fdb  $3F15
         fcs  /SWI3/
         fdb  $3F25
         fcs  /SWI/
         fdb  $3F05
         fcs  /LEAX/
         fdb  $3006
         fcs  /LEAY/
         fdb  $3106
         fcs  /LEAS/
         fdb  $3206
         fcs  /LEAU/
         fdb  $3306
         fcs  /TFR/
         fdb  $1F07
         fcs  /EXG/
         fdb  $1E07
         fcs  /PSHS/
         fdb  $3408
         fcs  /PULS/
         fdb  $3508
         fcs  /PSHU/
         fdb  $3608
         fcs  /PULU/
         fdb  $3708
         fcs  /LB/
         fdb  $0019
*
BRANTABL fcs  /BSR/
         fdb  $8D0A
         fcs  /BRA/
         fdb  $200A
         fcs  /BRN/
         fdb  $210A
         fcs  /BHI/
         fdb  $220A
         fcs  /BLS/
         fdb  $230A
         fcs  /BHS/
         fdb  $240A
         fcs  /BCC/
         fdb  $240A
         fcs  /BLO/
         fdb  $250A
         fcs  /BCS/
         fdb  $250A
         fcs  /BNE/
         fdb  $260A
         fcs  /BEQ/
         fdb  $270A
         fcs  /BVC/
         fdb  $280A
         fcs  /BVS/
         fdb  $290A
         fcs  /BPL/
         fdb  $2A0A
         fcs  /BMI/
         fdb  $2B0A
         fcs  /BGE/
         fdb  $2C0A
         fcs  /BLT/
         fdb  $2D0A
         fcs  /BGT/
         fdb  $2E0A
         fcs  /BLE/
         fdb  $2F0A
         fcs  /RMB/
         fdb  $000B
         fcs  /FCC/
         fdb  $010B
         fcs  /FDB/
         fdb  $020B
         fcs  /FCS/
         fdb  $030B
         fcs  /FCB/
         fdb  $040B
         fcs  /EQU/
         fdb  $050B
         fcs  /MOD/
         fdb  $060B
         fcs  /EMOD/
         fdb  $070B
         fcs  /SETDP/
         fdb  $070C
         fcs  /SET/
         fdb  $080B
         fcs  /OS9/
         fdb  $090B
         fcs  /END/
         fdb  $010C
         fcs  /NAM/
         fdb  $020C
         fcs  /OPT/
         fdb  $030C
         fcs  /TTL/
         fdb  $040C
         fcs  /PAG/
         fdb  $050C
         fcs  /SPC/
         fdb  $060C
         fcs  /USE/
         fdb  $080C
         fcs  /IFEQ/
         fdb  $000D
         fcs  /IFNE/
         fdb  $010D
         fcs  /IFLT/
         fdb  $020D
         fcs  /IFLE/
         fdb  $030D
         fcs  /IFGE/
         fdb  $040D
         fcs  /IFGT/
         fdb  $050D
         fcs  /IFP1/
         fdb  $060D
         fcs  /ELSE/
         fdb  $010E
*
ERRNOTC  fcc  /***** Error: /
         fcb  $00
*
ERRCHART fdb  $0035
         fdb  $003F
         fdb  $0049
         fdb  $0053
         fdb  $005C
         fdb  $005E
         fdb  $006A
         fdb  $0071
         fdb  $0080
         fdb  $008F
         fdb  $0097
         fdb  $00A9
         fdb  $00B6
         fdb  $00C3
         fdb  $00CE
         fdb  $00D7
         fdb  $00E1
         fdb  $00EC
         fdb  $00F8
         fdb  $0102
         fdb  $010C
         fdb  $0118
         fdb  $0121
         fdb  $012B
         fdb  $0137
         fdb  $0149
         fcb  $00
         fcc  /bad label/
         fcb  $00
         fcc  /bad instr/
         fcb  $00
         fcc  /in number/
         fcb  $00
         fcc  /div by 0/
         fcb  $00
         fcc  / /
         fcb  $00
         fcc  /expr syntax/
         fcb  $00
         fcc  /parens/
         fcb  $00
         fcc  /redefined name/
         fcb  $00
         fcc  /undefined name/
         fcb  $00
         fcc  /phasing/
         fcb  $00
         fcc  /symbol table full/
         fcb  $00
         fcc  /address mode/
         fcb  $00
         fcc  /out of range/
         fcb  $00
         fcc  /result>255/
         fcb  $00
         fcc  /reg name/
         fcb  $00
         fcc  /reg sizes/
         fcb  $00
         fcc  /input path/
         fcb  $00
         fcc  /object path/
         fcb  $00
         fcc  /index reg/
         fcb  $00
         fcc  /] missing/
         fcb  $00
         fcc  /needs label/
         fcb  $00
         fcc  /opt list/
         fcb  $00
         fcc  /const def/
         fcb  $00
         fcc  /can't open /
         fcb  $00
         fcc  /label not allowed/
         fcb  $00
         fcc  /cond nesting/
         fcb  $00
*
VECTTABL fdb  $001E
         fdb  $0025
         fdb  $0039
         fdb  $004E
         fdb  $0073
         fdb  $00A6
         fdb  $00AF
         fdb  $00C6
         fdb  $0104
         fdb  $011D
         fdb  $013A
         fdb  $015C
         fdb  $0161
         fdb  $0179
         fdb  $07A9
*
         lda  #$03
         sta  <$46
         lbra L0951
         lbsr L0932
         bcc  L07AF
         ldb  #$0C
         lbsr PRINTERR
L07AF    lbsr L12F7
         stb  <$63
         lda  #$02
         sta  <$46
         rts   
*
         inc  <$46
         lbsr L0932
         lbcs L09C6
         lbsr L12F1
         std  <$63
         inc  <$46
         inc  <$46
         lbra L0941
         inc  <$46
         lda  ,X+
         anda #$5F
         cmpa #$41
         beq  L07E7
         cmpa #$42
         beq  L07E1
         leas $02,S
         lbra L015F
L07E1    ldb  #$40
         orb  <$62
         stb  <$62
L07E7    lbsr L0932
         lbcs L09C6
         lbsr L0941
         bra  L07AF
         inc  <$46
         lda  <$62
         cmpa #$0E
         beq  L080B
         lda  ,X
         anda #$5F
         ldb  #$40
         cmpa #$41
         beq  L0819
         ldb  #$50
         cmpa #$42
         beq  L0819
L080B    lbsr L09C6
         ldb  <$62
         bitb #$F0
         beq  L0825
         orb  #$40
         stb  <$62
         rts   
*
L0819    orb  <$62
         stb  <$62
         leax $01,X
         ldb  #$DF
         andb <$2B
         stb  <$2B
L0825    rts   
*
         inc  <$46
         ldb  <$2B
         andb #$DF
         stb  <$2B
         rts   
*
         inc  <$46
         lbsr L09C6
         lda  <$4E
         bne  L0825
         ldd  #$1212
         std  <$62
         ldb  #$02
         stb  <$46
         ldb  #$0C
         lbra PRINTERR
         ldb  #$02
         stb  <$46
         lbsr SKIPSPAC
         lbsr L096B
         bcc  L0857
L0852    ldb  #$0F
         lbra PRINTERR
L0857    lda  ,X+
         cmpa #$2C
         bne  L0852
         pshs B
         lbsr L096B
         puls A
         bcs  L0852
         pshs B,A
         anda #$08
         andb #$08
         pshs B
         eora ,S+
         beq  L0879
         ldb  #$10
         leas $02,S
         lbra PRINTERR
L0879    puls A
         asla 
         asla 
         asla 
         asla 
         ora  ,S+
         sta  <$63
         rts   
*
         ldb  #$02
         stb  <$46
         lbsr SKIPSPAC
L088B    lbsr L096B
         bcs  L0852
         ora  <$63
         sta  <$63
         lda  ,X+
         cmpa #$2C
         beq  L088B
         leax -$01,X
         rts   
*
         lda  #$04
         sta  <$46
         leax -$01,X
         ldb  #$13
         leay BRANTABL,pcr
         lbsr L0344
         bcc  L08B3
         leas $02,S
         lbra L015F
L08B3    lda  ,Y
         sta  <$62
         lbra L0951
         lda  #$02
         sta  <$46
         lbsr L12F1
         subd <$40
         subd #$0002
         cmpd #$007F
         bgt  L08D2
         cmpd #$FF80
         bge  L08D9
L08D2    ldb  #$0D
         lbsr PRINTERR
         ldb  #$FE
L08D9    stb  <$63
         rts   
*
         leau <L08FE,pcr
         bra  L08EF
*
         ldb  <$2B
         bitb #$08
         beq  L08EC
         ldb  #$19
         lbsr PRINTERR
L08EC    leau <L0912,pcr
L08EF    lbsr SKIPSPAC
         ldb  <$62
         aslb 
         ldd  B,U
         jmp  D,U
*
         leau <L0924,pcr
         bra  L08EF
*
L08FE    fdb  $02A8
         fdb  $0349
         fdb  $03C1
         fdb  $036D
         fdb  $03AF
         fdb  $0329
         fdb  $0462
         fdb  $0442
         fdb  $032D
         fdb  $0453
L0912    fdb  $04A7
         fdb  $04AF
         fdb  $04C2
         fdb  $051A
         fdb  $04EB
         fdb  $04F1
         fdb  $04F7
         fdb  $05A1
         fdb  $05B2
L0924    fdb  $05BF
         fdb  $05C4
         fdb  $05C9
         fdb  $05CE
         fdb  $05D3
         fdb  $05D8
         fdb  $05DD
*
L0932    lbsr SKIPSPAC
         cmpa #$23
         bne  L093E
         leax $01,X
         andcc #$FE
         rts   
*
L093E    orcc #$01
         rts   
*
L0941    ldb  <$47
         bitb #$40
         bne  L0948
         rts   
*
L0948    ldb  #$03
         stb  <$46
         ldb  #$0C
         lbra PRINTERR
L0951    lbsr L12F1
         subd <$40
         subb <$46
         sbca #$00
         std  <$63
         cmpd #$007F
         bgt  L096A
         cmpd #$FF80
         blt  L096A
         inc  <$4F
L096A    rts   
*
L096B    leay L09A2,pcr
         pshs X
         ldb  #$0C
L0973    lda  ,Y
         beq  L098F
         cmpa ,X+
         beq  L0981
         adda #$20
         cmpa -$01,X
         bne  L098F
L0981    lda  $01,Y
         beq  L099A
         cmpa ,X+
         beq  L099A
         adda #$20
         cmpa -$01,X
         beq  L099A
L098F    ldx  ,S
         leay $03,Y
         decb 
         bne  L0973
         orcc #$01
         puls PC,X
*
L099A    decb 
         leas $02,S
         lda  $02,Y
         andcc #$FE
         rts   
*
L09A2    fcb  $44,$50,$08
         fcb  $43,$43,$01
         fcb  $42,$00,$04
         fcb  $41,$00,$02
         fcb  $00,$00,$00
         fcb  $00,$00,$00
         fcb  $50,$43,$80
         fcb  $53,$00,$40
         fcb  $55,$00,$40
         fcb  $59,$00,$20
         fcb  $58,$00,$10
         fcb  $44,$00,$06
*
L09C6    lbsr SKIPSPAC
         bsr  L0A14
         cmpa #$5B
         bne  L09D7
         inc  <$4D
         leax $01,X
         lda  ,X
         bsr  L0A14
L09D7    cmpa #$2C
         lbeq L0A64
         ldb  $01,X
         cmpb #$2C
         bne  L09F1
         anda #$DF
         cmpa #$41
         beq  L0A27
         cmpa #$42
         beq  L0A2B
         cmpa #$44
         beq  L0A2F
L09F1    lbsr L12F1
         bcc  L09F8
         clra  
         clrb 
L09F8    std  <$4A
         lda  ,X
         cmpa #$2C
         lbeq L0B18
         ldb  <$4D
         bne  L0A35
         ldb  <$4C
         bmi  L0A35
         bne  L0A53
         lda  <$4A
         cmpa <$3F
         beq  L0A53
         bra  L0A35
*
L0A14    ldb  #$FF
         cmpa #$3E
         beq  L0A20
         cmpa #$3C
         bne  L0A26
         ldb  #$01
L0A20    stb  <$4C
         leax $01,X
         lda  ,X
L0A26    rts   
*
L0A27    ldb  #$86
         bra  L0A31
L0A2B    ldb  #$85
         bra  L0A31
L0A2F    ldb  #$8B
L0A31    leax $01,X
         bra  L0A97
L0A35    ldd  <$4A
         inc  <$46
         inc  <$46
         inc  <$4F
         tst  <$4D
         bne  L0A4A
         std  <$63
         ldb  #$30
         orb  <$62
         stb  <$62
         rts   
*
L0A4A    std  <$64
         ldb  #$9F
         stb  <$63
         lbra L0AEA
*
L0A53    inc  <$46
         ldb  <$4B
         stb  <$63
         ldb  <$62
         bitb #$F0
         beq  L0A63
         orb  #$10
         stb  <$62
L0A63    rts   
*
L0A64    leax $01,X
         clr  <$4A
         clr  <$4B
         ldd  ,X
         cmpd #$2D2D
         beq  L0A8D
         cmpa #$2D
         beq  L0A93
         bsr  L0AC7
         lbcs L0B68
         stb  <$63
         ldd  ,X
         cmpd #$2B2B
         beq  L0AAB
         cmpa #$2B
         beq  L0AB1
         lbra L0B22
*
L0A8D    leax $01,X
         ldb  #$83
         bra  L0A97
L0A93    bsr  L0ABD
         ldb  #$82
L0A97    stb  <$63
         leax $01,X
         bsr  L0AC7
         bcc  L0AA5
L0A9F    ldb  #$13
         lbsr PRINTERR
         clrb 
L0AA5    orb  <$63
         stb  <$63
         bra  L0AEA
*
L0AAB    ldb  #$81
         leax $01,X
         bra  L0AB5
L0AB1    bsr  L0ABD
         ldb  #$80
L0AB5    leax $01,X
         orb  <$63
         stb  <$63
         bra  L0AEA
*
L0ABD    tst  <$4D
         beq  L0AC6
         ldb  #$0C
         lbsr PRINTERR
L0AC6    rts   
*
L0AC7    lda  ,X+
         anda #$5F
         clrb 
         cmpa #$58
         beq  L0AE2
         ldb  #$20
         cmpa #$59
         beq  L0AE2
         ldb  #$40
         cmpa #$55
         beq  L0AE2
         ldb  #$60
         cmpa #$53
         bne  L0AE5
L0AE2    andcc #$FE
         rts   
*
L0AE5    leax -$01,X
         orcc #$01
         rts   
*
L0AEA    ldb  #$20
         orb  <$62
         stb  <$62
         inc  <$46
         inc  <$4E
         tst  <$4D
         beq  L0B08
         ldb  #$10
         orb  <$63
         stb  <$63
         lda  ,X+
         cmpa #$5D
         beq  L0B08
         ldb  #$14
         bra  L0B14
L0B08    lda  ,X
         cmpa #$20
         beq  L0B17
         cmpa #$0D
         beq  L0B17
         ldb  #$0C
L0B14    lbsr PRINTERR
L0B17    rts   
*
L0B18    leax $01,X
         bsr  L0AC7
         bcs  L0B68
         orb  <$63
         stb  <$63
L0B22    ldd  <$4A
         tst  <$4C
         bmi  L0B5A
         bne  L0B52
         ldd  <$4A
         bne  L0B32
         ldb  #$84
         bra  L0B62
L0B32    tst  <$4D
         bne  L0B46
         cmpd #$000F
         bgt  L0B46
         cmpd #$FFF0
         blt  L0B46
         andb #$1F
         bra  L0B62
L0B46    cmpd #$007F
         bgt  L0B5A
         cmpd #$FF80
         blt  L0B5A
L0B52    stb  <$64
         inc  <$46
         ldb  #$88
         bra  L0B62
L0B5A    std  <$64
         inc  <$46
         inc  <$46
         ldb  #$89
L0B62    orb  <$63
         stb  <$63
         bra  L0AEA
*
L0B68    ldd  ,X
         anda #$5F
         andb #$5F
         cmpd #$5043
         lbne L0A9F
         leax $02,X
         lda  ,X
         anda #$5F
         cmpa #$52
         bne  L0B82
         leax $01,X
L0B82    inc  <$46
         ldd  <$4A
         subd <$40
         subb <$46
         sbca #$00
         subd #$0001
         tst  <$4C
         bmi  L0B9B
         beq  L0B9B
         stb  <$64
         ldb  #$8C
         bra  L0B62
L0B9B    subd #$0001
         inc  <$46
         std  <$64
         ldb  #$8D
         bra  L0B62
*
         bsr  L0BE4
         pshs B,A
         addd DBYTCNT
         std  DBYTCNT
         bsr  L0BEF
         beq  L0BB6
         lda  #$04
         bsr  L0BF7
L0BB6    bsr  L0BD8
         bsr  L0BEF
         beq  L0BBE
         bsr  L0C0A
L0BBE    addd ,S++
L0BC0    pshs A
         lda  <$2B
         anda #$08
         ora  #$31
         sta  <$2B
         puls A
         tst  MFLAG
         beq  L0BD3
         std  <$40
         rts   
*
L0BD3    std  <$42
         inc  <$2C
         rts   
*
L0BD8    tst  MFLAG
         beq  L0BDF
         ldd  <$40
         rts   
*
L0BDF    ldd  <$42
         std  <$44
         rts   
*
L0BE4    lbsr L11C2
         bcc  L0BEE
         lbsr PRINTERR
         clra  
         clrb 
L0BEE    rts   
*
L0BEF    pshs A
         lda  <$2B
         bita #$08
         puls PC,A
*
L0BF7    ldu  <$2D
         ldb  $08,U
         bmi  L0C09
         cmpb #$02
         bne  L0C07
         cmpa #$02
         beq  L0C07
         ora  #$80
L0C07    sta  $08,U
L0C09    rts   
*
L0C0A    tst  PASSNMBR
         ble  L0C24
         cmpd $09,U
         beq  L0C26
         pshs B,A
         lda  $08,U
         bmi  L0C22
         cmpa #$02
         beq  L0C22
         ldb  #$0A
         lbsr PRINTERR
L0C22    puls B,A
L0C24    std  $09,U
L0C26    rts   
*
         lda  #$03
         bra  L0C2D
         lda  #$02
L0C2D    bsr  L0BEF
         bne  L0C38
         ldb  #$15
         lbsr PRINTERR
         bra  L0C46
L0C38    bsr  L0BF7
         bsr  L0BE4
         ldu  <$2D
         bsr  L0C0A
         std  <$44
         ldb  #$39
         stb  <$2B
L0C46    rts   
*
         lda  ,X+
         pshs A
         cmpa #$0D
         beq  L0C64
         cmpa #$2F
         bhi  L0C64
         bsr  L0C8D
L0C55    lda  ,X+
         cmpa ,S
         beq  L0C69
         cmpa #$0D
         beq  L0C64
         lbsr L0CEC
         bra  L0C55
*
L0C64    ldb  #$17
         lbsr PRINTERR
L0C69    puls PC,A
*
         lda  ,X+
         pshs A
         cmpa #$0D
         beq  L0C64
         cmpa #$2F
         bhi  L0C64
         bsr  L0C8D
L0C79    ldd  ,X+
         cmpa #$0D
         beq  L0C64
         cmpa ,S
         beq  L0C69
         cmpb ,S
         bne  L0C89
         ora  #$80
L0C89    bsr  L0CEC
         bra  L0C79
*
L0C8D    pshs X,A
         leax -$01,X
L0C91    leax $01,X
         lda  ,X
         cmpa #$0D
         beq  L0CA1
         cmpa ,S
         bne  L0C91
         leax $01,X
         lda  ,X
L0CA1    clr  ,X+
         stx  <$33
         cmpa #$0D
         bne  L0CAB
         sta  ,X
L0CAB    puls PC,X,A
*
         bsr  L0CD5
L0CAF    lbsr L12F7
         tfr  B,A
         bsr  L0CEC
         lda  ,X+
         cmpa #$2C
         beq  L0CAF
         leax -$01,X
         rts   
*
         bsr  L0CD5
L0CC1    lbsr L12F1
         pshs B
         bsr  L0CEC
         puls A
         bsr  L0CEC
         lda  ,X+
         cmpa #$2C
         beq  L0CC1
         leax -$01,X
         rts   
*
L0CD5    pshs X
L0CD7    lbsr L12F1
         lda  ,X+
         cmpa #$2C
         beq  L0CD7
         clr  -$01,X
         stx  <$33
         cmpa #$0D
         bne  L0CEA
         sta  ,X
L0CEA    puls PC,X
*
L0CEC    ldb  <$46
         cmpb #$04
         bcs  L0CF4
         bsr  L0D03
L0CF4    pshs B,A
         tfr  DP,A
         ldb  #$62
         tfr  D,U
         puls B,A
         sta  B,U
         inc  <$46
         rts   
*
L0D03    pshs X,B,A
         ldb  <$2A
         bne  L0D14
         ldx  <$33
         lbsr L01C4
         tst  GFLAG
         beq  L0D27
         bra  L0D30
L0D14    tst  GFLAG
         bne  L0D2D
         lda  L1FLAG
         pshs A
         clr  L1FLAG
         com  L1FLAG
         lbsr L01D3
         puls A
         sta  L1FLAG
L0D27    ldb  #$04
         stb  <$2B
         bra  L0D34
L0D2D    lbsr L01D3
L0D30    ldb  #$05
         stb  <$2B
L0D34    ldd  <$40
         std  <$44
         clr  <$46
         inc  <$2A
         clr  $01,S
         puls PC,X,B,A
*
         ldd  CRC
         coma 
         comb 
         std  <$62
         ldb  CRC+2
         comb 
         lda  <$2B
         anda #$DF
         sta  <$2B
         bra  L0D59
         ldd  #$103F
         std  <$62
         lbsr L12F7
L0D59    stb  <$64
         ldb  #$03
         stb  <$46
         rts   
*
         clra  
         clrb 
         stb  <$50
         std  <$40
         std  <$44
         std  <$42
         lbsr STARTCRC
         lbsr L0CD5
         ldd  #$87CD
         bsr  L0D93
         bsr  L0D90
         bsr  L0D8E
         bsr  L0DA9
         bsr  L0DA4
         bsr  L0DA9
         bsr  L0DA4
         lda  <$50
         coma 
         bsr  L0DA1
         lda  ,X
         cmpa #$2C
         bne  L0DB8
         bsr  L0D8E
L0D8E    bsr  L0DA9
L0D90    lbsr L12F1
L0D93    pshs B
         tfr  A,B
         bsr  L0D9B
         puls B
L0D9B    tfr  B,A
         eorb <$50
         stb  <$50
L0DA1    lbra L0CEC
*
L0DA4    lbsr L12F7
         bra  L0D9B
*
L0DA9    lda  ,X+
         cmpa #$2C
         beq  L0DB8
         leax -$01,X
         ldb  #$17
         lbsr PRINTERR
         leas $02,S
L0DB8    rts   
*
         lbsr L0BE4
         std  <$44
         lbra L0BC0
         ldb  <$2B
         andb #$08
         orb  #$10
         stb  <$2B
         lbsr L01F2
         lbsr L156C
         bcc  L0DD3
         leas $04,S
L0DD3    rts   
*
         ldb  #$27
         ldu  <$0A
L0DD8    lbsr SKIPSPAC
         lda  PASSNMBR
         bne  L0DE3
         lda  ,U
         bne  L0DFC
L0DE3    lda  ,X+
         cmpa #$0D
         beq  L0DF4
         sta  ,U+
         decb 
         bne  L0DE3
         lda  #$0D
L0DF0    cmpa ,X+
         bne  L0DF0
L0DF4    clr  ,U
         leax -$01,X
         ldb  #$30
         stb  <$2B
L0DFC    rts   
*
         ldb  #$4F
         ldu  <$08
         bra  L0DD8
*
         lbsr L1408
L0E06    leas $02,S
         rts   
*
         bsr  NUMBEVAL
         bcc  L0E12
         ldb  #$30
         stb  <$2B
         rts   
*
L0E12    stb  ,-S
         beq  L0E1D
L0E16    lbsr L149A
         dec  ,S
         bne  L0E16
L0E1D    leas $01,S
         bra  L0E06
*
NUMBEVAL lbsr NUMEVAL2 Get digits and evaluate.
         bcc  L0E2B Return if no error.
         lbsr PRINTERR Else print the error msg,
         orcc #$01 and set an error flag.
L0E2B    rts   
*
L0E2C    ldb  #$30
         stb  <$2B
         lbsr SKIPSPAC Skip any leading spaces.
L0E33    clr  ,-s Set 'not' flag to zero.
         lda  ,x+ Get a character;
         cmpa #$2D a '-'?
         bne  L0E3F If not, skip.
         com  ,s Else set 'not' flag,
         lda  ,x+ get next byte.
L0E3F    leau <SWTCHTBL,pcr Table of accepted switches
         ldb  #$08 Eight entries
         cmpa #$61 Is it lowercase?
         bcs  L0E4A If not, proceed.
         suba #$20 Else change to uppercase.
L0E4A    cmpa ,U++ Compare to table entry.
         beq  L0E68 If a match, exit loop.
         decb  Else tally attempt,
         bne  L0E4A loop if more to check.
         puls b Retrieve 'not' flag.
         cmpa #$44 Is switch a 'D'?
         beq  SETLNGTH If so, get number and record.
         cmpa #$57 Is it a 'W'?
         beq  SETWIDTH Then get and record number.
         cmpa #$4C An 'L'?
         beq  SETLFLAG Set flag appropriately.
         cmpa #$4E An 'N'?
         beq  SETNFLAG Set that flag.
L0E63    ldb  #$16 Else an error;  set code,
         lbra PRINTERR print out error message.
*
L0E68    ldb  -$01,u Get ptr. from switch table;
         tfr  dp,a MSB of pointer is DP.
         tfr  d,u Put pointer into u.
         puls a Get 'not' flag,
         coma  change to 'yes' flag.
         sta  ,u Store at correct location.
L0E73    lda  ,x+ Look at next character.
         cmpa #$2C If it's ',' then
         beq  L0E33 loop for more switches.
         cmpa #$20 If it's a space,
         beq  L0E2C reset ? and loop.
         leax -$01,x Else back pointer up
         rts and return.
*
SETWIDTH bsr  NUMBEVAL Evaluate number string.
         bcs  L0E63 If error, take exit.
         stb  PAGWIDTH Else record result.
         bra  L0E73 Back to loop.
*
SETLNGTH bsr  NUMBEVAL Evaluate number string.
         bcs  L0E63 Exit on error.
         stb  LINPRPAG Else record result.
         bra  L0E73 Back to parsing.
*
SETLFLAG tstb  Was there a '-' in front?
         beq  L0E97 If not, skip.
         dec  L1FLAG Else change flag.
         bra  L0E73 Back to parsing.
L0E97    inc  L1FLAG Adjust flag.
         bra  L0E73 Back to parsing.
*
SETNFLAG inc  NFLAG For narrow display,
         lda  #$1F 31 columns will be
         sta  PAGWIDTH the page width.
         bra  L0E97 Back to parsing.
*
SWTCHTBL fdb  $435F
         fdb  $4659
         fdb  $4D5A
         fdb  $475B
         fdb  $455C
         fdb  $535E
         fdb  $495D
         fdb  $4F58
*
         lbsr L12F7
         bcs  L0EBA
         stb  <$3F
L0EBA    clra  
         std  <$44
         ldb  #$31
         stb  <$2B
         inc  <$2C
         rts
*
         lbsr SKIPSPAC
         lbsr L15FB
         bra  L0ECE
*
L0ECC    leax -$01,X
L0ECE    ldb  -$01,X
         cmpb #$20
         beq  L0ECC
         ldu  USTKTPTR
         ldb  INPATHNO
         PSHU  B
         stu  USTKTPTR
         sta  INPATHNO
         ldb  #$30
         stb  <$2B
         rts   
*
         bsr  L0F0F
         bne  L0F0C
         rts   
*
         bsr  L0F0F
         beq  L0F0C
         rts   
*
         bsr  L0F0F
         bge  L0F0C
         rts   
*
         bsr  L0F0F
         bgt  L0F0C
         rts   
*
         bsr  L0F0F
         blt  L0F0C
         rts   
*
         bsr  L0F0F
         ble  L0F0C
         rts   
*
         inc  <$55
         ldb  #$10
         bsr  L0F21
         lda  PASSNMBR
         bne  L0F0C
         rts   
*
L0F0C    inc  <$54
         rts   
*
L0F0F    inc  <$55
         ldb  #$30
         bsr  L0F21
         lbsr L12F1
         bcc  L0F1C
         puls PC,B,A
*
L0F1C    cmpd #$0000
         rts   
*
L0F21    tst  CFLAG
         bne  L0F26
         clrb 
L0F26    stb  <$2B
         rts   
*
         ldb  #$10
         bsr  L0F21
         lda  <$55
         beq  L0F42
         lda  <$62
         bne  L0F3B
         dec  <$55
         lda  <$54
         beq  L0F41
L0F3B    lda  <$54
         beq  L0F0C
         dec  <$54
L0F41    rts   
*
L0F42    ldb  #$1A
         lbsr PRINTERR
         clr  <$54
         rts   
*
L0F4A    pshs U,Y,X
         bsr  L0FC3
         stx  <$2D
         ldb  PASSNMBR
         bgt  L0F7D
         bcc  L0F63
         lda  #$01
         ldu  <$40
         lbsr L100B
         stx  <$2D
         bcc  L0F9E
         bra  L0F9A
L0F63    cmpa #$00
         bne  L0F71
         lda  #$01
         ldu  <$40
         sta  $08,X
         stu  $09,X
         bra  L0F9E
L0F71    cmpa #$02
         beq  L0F9E
         ora  #$80
         sta  $08,X
L0F79    ldb  #$08
         bra  L0F9A
L0F7D    bcc  L0F83
L0F7F    ldb  #$09
         bra  L0F9A
L0F83    cmpa #$00
         beq  L0F7F
         bita #$80
         bne  L0F79
         cmpa #$01
         bne  L0F9E
         ldd  <$40
         cmpd $09,X
         beq  L0F9E
         std  $09,X
         ldb  #$0A
L0F9A    orcc #$01
         puls PC,U,Y,X
*
L0F9E    andcc #$FE
         puls PC,U,Y,X
*
L0FA2    pshs U,Y,X
         bsr  L0FC3
         ldb  PASSNMBR
         bne  L0FBB
         bcc  L0FB7
         lda  #$00
         ldu  #$0000
         bsr  L100B
         bcs  L0F9A
         bra  L0F9E
*
L0FB7    ldd  $09,X
         bra  L0F9E
*
L0FBB    lda  $08,X
         cmpa #$00
         bne  L0FB7
         bra  L0F7F
*
L0FC3    bsr  L0FFA
         ldx  ,X
         bne  L0FCD
         leay ,X
         bra  L0FF7
L0FCD    pshs X
         ldy  <$16
         ldb  #$08
L0FD4    lda  ,Y+
         beq  L0FE5
         cmpa ,X+
         bne  L0FE9
         decb 
         bne  L0FD4
L0FDF    puls X
         lda  $08,X
         clrb 
         rts   
*
L0FE5    cmpa ,X+
         beq  L0FDF
L0FE9    puls Y
         bhi  L0FF3
         ldx  $0B,Y
         bne  L0FCD
         bra  L0FF7
*
L0FF3    ldx  $0D,Y
         bne  L0FCD
L0FF7    orcc #$01
         rts   
*
L0FFA    ldx  <$16
         ldb  ,X
         ldx  <$10
         subb #$41
         cmpb #$20
         bcs  L1008
         subb #$06
L1008    aslb 
         abx  
         rts   
*
L100B    ldx  STABLPTR
         pshs X,A
         leax $0F,X
         cmpx ENDATPTR
         bcs  L1023
         ldb  #$0B
L1017    clr  L1FLAG
         lda  #$01
         sta  PASSNMBR
         lbsr PRINTERR
         lbra L15E9 Close I/O paths and exit.
L1023    stx  STABLPTR
         STY   ,--S
         bne  L1032
         leas $02,S
         bsr  L0FFA
         leay -$0B,X
         bra  L1040
L1032    ldx  <$16
L1034    lda  ,X+
         cmpa ,Y+
         beq  L1034
         puls Y
         bcs  L1040
         leay $02,Y
L1040    ldx  $01,S
         stx  $0B,Y
         ldy  <$16
         lda  ,Y+
L1049    sta  ,X+
         lda  ,Y+
         bne  L1049
         puls X,A
         sta  $08,X
         stu  $09,X
         clrb 
         rts   
*
L1057    bsr  BINTOHEX Write out number in hex.
         bra  APNDSPAC Add a space and return.
         bsr  L106B No label here?
APNDSPAC    pshs A Save a momentarily,
         lda  #$20 get a space,
         sta  ,x+ put it on the string
         puls a,pc and return.
*
* Following sub converts binary double-byte to 4 hex ASCII digits.
*
BINTOHEX exg  A,B Look at MSB first.
         bsr  L106B Convert to 2 hex bytes.
         tfr  A,B Now the LSB.
L106B    pshs B Save the byte for later.
         andb #$F0 Mask out lower nibble,
         lsrb Divide
         lsrb by
         lsrb 16
         lsrb 
         bsr  L1079 Convert to a hex digit.
         puls b Retrieve the binary byte,
         andb #$0F mask all but lower nibble.
L1079    cmpb #$09 '9' or less?
         bls  L107F Then skip.
         addb #$07 Else convert to 'A-F'.
L107F    addb #$30 Now convert to ASCII,
         stb  ,x+ write digit out
         rts and return.
*
* Following sub converts binary integer to 5 decimal ASCII digits.
*
BINTODEC pshs u,y,b Save registers,
         leau TENTHOU,pcr point to 10,000 binary.
         ldy  #$0005 Create this many dec. digits.
L108E    clr  ,s Start with digit = 0,
L1090    subd ,u dec. bin by this place value.
         bcs  L1098 If past 0, exit loop.
         inc  ,s Else increase digit,
         bra  L1090 loop back.
L1098    addd ,u++ Rest. bin to +, get next
         pshs b place value.  Save b,
         ldb  $01,s get decimal digit,
         addb #$30 convert to ASCII,
         stb  ,x+ add it to outstring,
         puls b then restore b.
         leay -$01,y Count down one digit,
         bne  L108E loop if more to do.
         puls b,y,u,pc Else restore regs and return.
*
TENTHOU  fdb  $2710 equals 10,000
         fdb  $03E8 equals 1,000
         fdb  $0064 equals 100
         fdb  $000A equals 10
         fdb  $0001 equals 1
*
NUMEVAL2 lbsr SKIPSPAC Pass over any spaces.
         leax $01,x Look at next byte.
         cmpa #$25 A '%' (binary)?
         beq  BINTOBIN If so, branch.
         cmpa #$24 A '$' (hexadecimal)?
         beq  HEXTOBIN Branch appropriately.
         leax -$01,X Else move pointer back,
         bra  DECTOBIN do decimal conversion.
*
* Following sub converts presumed hexadecimal strings to binary
*
HEXTOBIN leas -$04,s Make room for 4 bytes,
         bsr  L1134 zero them to start.
L10C9    bsr  DECDIGIT Get a digit;
         bcc  L10DD if 0 - 9, skip ahead.
         cmpb #$61 If less than 'a',
         bcs  L10D3 skip.
         subb #$20 Else change to uppercase.
L10D3    cmpb #$41 'A' or more?
         bcs  L114D Branch if not.
         cmpb #$46 'F' or less?
         bhi  L114D Branch if not.
         subb #$37 Else change to binary,
L10DD    stb  ,s store on stack.
         ldd  $02,s Get result of prior digits,
         bita #$F0 check for overflow ahead.
         bne  L1160 Branch if so.
         aslb Else
         rola multiply
         aslb previous
         rola result
         aslb by 16,
         rola 
         aslb 
         rola 
         addb ,s add in new amount.
         adca #$00 Carry if necessary,
         std  $02,s store the result.
         inc  $01,s Count digit converted,
         bra  L10C9 loop for next one.
*
* Following sub converts presumed decimal strings to binary
*
DECTOBIN leas -$04,s Make space on stack,
         bsr  L1134 fill it with zeros.
L10FB    bsr  DECDIGIT Convert a digit.
         bcs  L114D Problem?  Take exit.
         stb  ,s Else save latest,
         ldd  $02,s get prior total.
         aslb Multiply
         rola by 2,
         std  $02,s store the result.
         aslb Now it's
         rola multiplied by 4.
         aslb Now
         rola by 8.
         bcs  L1160 Problem?  Exit.
         addd $02,s Add x2 gives x10.
         bcs  L1160 Exit on overflow.
         addb ,s Add in most recent digit,
         adca #$00 carry if necessary.
         bcs  L1160 Overflow?  Exit.
         std  $02,s Else save result,
         inc  $01,s count digit,
         bra  L10FB loop back for more.
*
* following sub converts ASCII binary to real binary
*
BINTOBIN leas -$04,s Create space on stack,
         bsr  L1134 fill it with zeros.
L1121    ldb  ,x+ Get a digit,
         subb #$30 convert from ASCII to binary.
         bcs  L114D Out of bounds?  Exit.
         lsrb Greater than 1?
         bne  L114D Then exit.
         rol  $03,S ?
         rol  $02,s Double previous result,
         bcs  L1160 exit on overflow.
         inc  $01,s Tally digit,
         bra  L1121 Loop for next digit.
*
L1134    clra Clear 4 bytes on
         clrb the stack (past this
         std  $02,s subroutine's return
         std  $04,S address), then
         rts   return.
*
DECDIGIT ldb  ,x+ Look at next character.
         cmpb #$30 '0' or more?
         bcs  L1145 If not, flag & exit.
         cmpb #$39 '9' or less?
         bls  L1148 If so, proceed.
L1145    orcc #$01 Set flag:  not a digit,
         rts return
L1148    subb #$30 Convert to binary,
         andcc #$FE set flag:  a digit.
         rts   
*
L114D    leax -$01,x Back up to last character.
         tst  $01,s Any digits converted yet?
         beq  L1159 If not, set flags and exit.
         ldd  $02,s Else put result in d,
         andcc #$FE clear flag,
         bra  L115D free stack and return.
L1159    orcc #$04 Set 'zero' flag.
L115B    orcc #$01 Set 'carry' flag.
L115D    leas $04,s Free up stack space,
         rts   return
*
L1160    andcc #$FB Clear 'zero' flag.
         bra  L115B Set carry, adj stack, return.
*
SKIPSPAC lda  ,x+ Look at a byte.
         cmpa #$20 A space?
         beq  SKIPSPAC If so get next one.
         leax -$01,x Else move pointer back
         rts and return.
*
L116D    pshs X,B,A
         lda  $03,S
         mul  
         pshs B,A
         lda  $02,S
         ldb  $05,S
         mul  
         addb ,S
         stb  ,S
         lda  $03,S
         ldb  $04,S
         mul  
         addb ,S
         stb  ,S
         ldd  ,S
         ldx  #$0000
         leas $06,S
         rts   
*
L118E    pshs Y,X,B,A
         ldd  ,S
         bne  L1198
         orcc #$01
         bra  L11B8
L1198    ldd  #$0010
         stb  $04,S
         clrb 
L119E    ASL   $03,S
         rol  $02,S
         rolb 
         rola 
         subd ,S
         bmi  L11AC
         inc  $03,S
         bra  L11AE
L11AC    addd ,S
L11AE    dec  $04,S
         bne  L119E
         tfr  D,X
         ldd  $02,S
         andcc #$FE
L11B8    leas $06,S
         rts   
*
L11BB    sta  ,x+ Copy a null-terminated
L11BD    lda  ,y+ string from y-pointer
         bne  L11BB to x-pointer.
         rts   
*
L11C2    pshs U,Y
         leau ,S
         bsr  SKIPSPAC
         bsr  L11D0
         andcc #$FE
         puls PC,U,Y
*
L11CE    leax $01,X
L11D0    bsr  L1211
         pshs B,A
L11D4    lda  ,X
         cmpa #$2D
         bne  L11E2
         bsr  L120F
         nega 
         negb 
         sbca #$00
         bra  L11E8
L11E2    cmpa #$2B
         bne  L11EE
         bsr  L120F
L11E8    addd ,S
         std  ,S
         bra  L11D4
L11EE    tsta 
         beq  L120D
         cmpa #$0D
         beq  L120D
         cmpa #$20
         beq  L120D
         cmpa #$2C
         beq  L120D
         cmpa #$29
         beq  L120D
         cmpa #$5D
         beq  L120D
L1205    ldb  #$06
L1207    leas ,U
         orcc #$01
         puls PC,U,Y
*
L120D    puls PC,B,A
*
L120F    leax $01,X
L1211    bsr  L123F
         pshs B,A
L1215    lda  ,X
         cmpa #$2F
         bne  L122A
         bsr  L123D
         pshs X
         ldx  $02,S
         lbsr L118E
         bcc  L1237
         ldb  #$04
         bra  L1207
L122A    cmpa #$2A
         bne  L120D
         bsr  L123D
         pshs X
         ldx  $02,S
         lbsr L116D
L1237    puls X
         std  ,S
         bra  L1215
*
L123D    leax $01,X
L123F    bsr  L126D
         pshs B,A
L1243    lda  ,X
         cmpa #$26
         bne  L1251
         bsr  L126B
         andb $01,S
         anda ,S
         bra  L1267
L1251    cmpa #$21
         bne  L125D
         bsr  L126B
         orb  $01,S
         ora  ,S
         bra  L1267
L125D    cmpa #$3F
         bne  L120D
         bsr  L126B
         eorb $01,S
         eora ,S
L1267    std  ,S
         bra  L1243
*
L126B    leax $01,X
L126D    lda  ,X
         cmpa #$5E
         bne  L1279
         bsr  L1284
         comb 
         coma 
         bra  L1283
*
L1279    cmpa #$2D
         bne  L1286
         bsr  L1284
         nega 
         negb 
         sbca #$00
L1283    rts   
*
L1284    leax $01,X
L1286    lda  ,X
         cmpa #$28
         bne  L12A2
         lbsr L11CE
         pshs B,A
         lda  ,X
         cmpa #$29
         puls B,A
         beq  L12B6
         ldb  <$07
         bra  L129D
L129D    leas $02,S
L129F    lbra L1207
*
L12A2    cmpa #$2A
         bne  L12AA
         ldd  <$40
         bra  L12B6
L12AA    tst  MFLAG
         bne  L12B9
         cmpa #$2E
         bne  L12B9
         ldd  <$42
         inc  <$2C
L12B6    leax $01,X
         rts   
*
L12B9    cmpa #$27
         bne  L12C5
         ldd  ,X++
         cmpb #$0D
         beq  L12D6
         clra  
         rts   
*
L12C5    cmpa #$22
         bne  L12D9
         leax $01,X
         ldd  ,X++
         cmpa #$0D
         beq  L12D6
         cmpb #$0D
         beq  L12D6
         rts   
*
L12D6    lbra L1205
L12D9    lbsr NUMEVAL2
         bcc  L12EE
         beq  L12E4
         ldb  #$03
         bra  L129F
*
L12E4    lbsr L0368
         bcs  L12D6
         lbsr L0FA2
         bcs  L129F
L12EE    andcc #$FE
         rts   
*
L12F1    lbsr L11C2
         bcs  L1304
L12F6    rts   
*
L12F7    lbsr L11C2
         bcs  L1304
         tsta 
         beq  L12F6
         inca 
         beq  L12F6
         ldb  #$0E
L1304    lbsr PRINTERR
         ldd  #$FFFF
         orcc #$01
         rts   
*
L130D    bsr  UPDATCRC
         pshs X,B,A Save registers.
         ldx  CODEFNGR Get current loc. in buffer.
         sta  ,x+ Put this code byte there.
         stx  CODEFNGR Record updated pointer.
         cmpx <$10 Buffer full yet?
         bcs  L1321 If not, return.
         bsr  L1323 Else write out contents,
         ldx  CODBFPTR reset pointer
         stx  CODEFNGR to beginning of it.
L1321    puls a,b,x,pc Restore regs and return.
*
L1323    pshs y,x,b,a Save registers.
         lda  OFLAG Creating code module?
         beq  L1340 If not, exit.
         lda  PASSNMBR Is this pass 2?
         beq  L1340 If not, exit.
         ldd  CODEFNGR Where are we in the buffer?
         subd CODBFPTR At the beginning?
         beq  L1340 Then exit.
         tfr  d,y Else put byte count in y,
         ldx  CODBFPTR x points to the beginning,
         lda  EOTPTHNO a has the path number.
         beq  L1340 (If = 0, no output)
         OS9  I$Write Write it out.
         bcs  L1342 Problem?
L1340    puls a,b,x,y,pc No, restore regs and return.
*
L1342    OS9  F$PErr Yes, have OS9 print number.
         ldb  #$12 Then print out
         lbsr PRINTERR local error message
         lbra L15A2 and take exit.
*
UPDATCRC pshs u,y,x,b,a Save registers.
         leax ,s Point to new code byte.
         ldy  #$0001 Just one byte.
         tfr  dp,a MSB of pointer is DP.
         ldb  #CRC LSB is this.
         tfr  d,u Put pointer into u.
         OS9  F$CRC Have OS9 update the numbers.
         puls a,b,x,y,u,pc Restore regs and return.
*
STARTCRC ldd  #$FFFF CRC bytes must
         std  CRC be $FF to begin with.
         stb  CRC+2 (All three.)
         rts   
*
L1368    lda  L2FLAG
         beq  L139A
         lda  L1FLAG
         bmi  L139A
L1370    lda  LINSLEFT Any space left, this page?
         bne  L137B If so, skip.
         pshs x Else finish page and
         lbsr L1408 write header for next one.
         puls x Restore x,
L137B    bsr  L138A append CR, write string out.
         lda  PASSNMBR Pass 2?
         beq  L1387 If not, skip.
         lda  L1FLAG Listing?
         bmi  L1387 If not, skip.
         dec  LINSLEFT Else reduce count, set
L1387    ldx  OUTSTPTR pointer back to start,
         rts return.
*
L138A    lda  L2FLAG
         beq  L1392
         lda  L1FLAG
         bpl  L139A
L1392    lda  EFLAG
         beq  L1387
         lda  <$21
         beq  L1387
L139A    lda  PASSNMBR
         beq  L1387
         pshs Y,A
         bsr  L13B8 Add a CR to outstring.
         clra Get maximum
         ldb  PAGWIDTH length of outstring,
         ldx  OUTSTPTR add to location of
         leax d,x first byte.
         bsr  L13B8 Put a C.R. at the end.
         ldx  OUTSTPTR Point to beginning again,
         ldy  #$0085 max. length = 133,
         lda  LOTPTHNO get output path number;
         OS9 I$WritLn write line out.
         puls a,y,pc Restore regs and return.
*
L13B8    lda  #$0D A C.R.
         sta  ,x+ Add it to string.
         rts   
*
DATETIME leas -$06,s Make room on stack for data.
         pshs x Save register,
         leax $02,s point to storage space.
         OS9  F$Time Get data packet from OS9.
         puls x Restore register,
         bcs  L13F0 branch on error.
         lda  $01,s Get month byte,
         bsr  BINTDEC2 process, write 2 digits.
         ldb  #$2F Add a '/'
         stb  ,x+ to the string.
         lda  $02,s Get day byte,
         bsr  BINTDEC2 process and write.
         stb  ,x+ Add another '/'.
         lda  ,s Get year byte,
         lbsr YEAR process, write 4 digits.
         bsr  L13F2 Add a space.
         lda  $03,s Get hour.
         bsr  BINTDEC2 process and write.
         ldb  #$3A Add a ':'
         stb  ,x+ to the string.
         lda  $04,s Get minutes,
         bsr  BINTDEC2 write them,
         stb  ,x+ add another ':'.
         lda  $05,S Finally, get seconds,
         bsr  BINTDEC2 write 2 digits.
L13F0    leas $06,S Reset stack pointer,
L13F2    lda  #$20 add another space,
         sta  ,x+ write it
         rts and return.
*
BINTDEC2 pshs b Save register,
         ldb  #$2F start with ASC(0)-1.
L13FB    incb  Count ASCII up,
         suba #$0A binary down by 10,
         bcc  L13FB loop until past zero.
         stb  ,x+ Write 10's digit,
         adda #$3A convert remainder to ASCII,
         sta  ,x+ write it.
         puls b,pc Restore b and return.
*
L1408    lda  L1FLAG
         bmi  L1476
         lda  FFLAG
         beq  L1414
         bsr  L147D Write out a $0C (maybe).
         bra  L141A
L1414    ldb  LINSLEFT Get lines-left count,
         addb #$03 add 3 normally blank,
         bsr  L1471 write CR's and reset outstr.
L141A    ldx  OUTSTPTR Save this pointer
         pshs x on the stack temporarily.
         ldx  HDOUTPTR Replace it with header
         stx  OUTSTPTR string pointer.
         ldb  LINPRPAG Get 'max lines' count.
         subb #$04 Subtract for blanks, header.
         stb  LINSLEFT Reset lines-left counter.
         lbsr L01E5
         leay <HEADING,pcr Point to 'Microware OS9...'
         lbsr L11BD Transfer to outstring.
         bsr  DATETIME Write date and time.
         ldx  OUTSTPTR Calculate
         clra location of
         ldb  PAGWIDTH character
         subb #$06 5th from end
         leax d,x of line, for page #.
         ldd  PAGENMBR Get the number (binary),
         lbsr BINTODEC convert, add to string.
         inc  PAGENMBR+1 Tally page (LSB),
         bne  L1447 and if necessary
         inc  PAGENMBR increase MSB.
L1447    leax -$08,x Back up in outstring,
         leay <PAGE,pcr point to 'Page ',
         lbsr L11BD transfer (wiping out 2 #
         leax $03,x digits;  then back to end.
         lbsr L1370 Append CR and write line.
*
         ldy  <$0A
         lbsr L11BD
         bsr  L13F2
         lda  #$2D
         sta  ,X+
         bsr  L13F2
         ldy  <$08
         lbsr L11BD
         lbsr L1370
         puls X
         stx  OUTSTPTR
         ldb  #$01
L1471    bsr  L1479 Write out $0D (maybe),
         decb tally,
         bne  L1471 loop if necessary.
L1476    ldx  OUTSTPTR Restore outstring pointer,
         rts return.
*
L1479    lda  #$0D
         bra  L147F
L147D    lda  #$0C
L147F    pshs Y,X,B,A
         lda  PASSNMBR
         beq  L1498
         lda  L2FLAG
         beq  L1498
         lda  L1FLAG
         bmi  L1498
         lda  LOTPTHNO Get listing output path #.
         tfr  s,x Point to stored $0D or $0C.
         ldy  #$0001 Write only one byte
         OS9 I$WritLn via OS9.
L1498    puls a,b,x,y,pc Restore and return.
*
L149A    ldx  OUTSTPTR
         lbra L1370
*
PAGE     fcc  /Page /
         fcb  $00
HEADING    fcc  /Microware OS-9 Assembler /
         fcc  /RS Version 01.00.00    /
         fcb  $00
ERRORS    fcc  / error(s)/
         fcb  $00
WARNINGS    fcc  / warning(s)/
         fcb  $00
PROGBYTS    fcc  / program bytes generated/
         fcb  $00
DATABYTS    fcc  / data bytes allocated/
         fcb  $00
SYMBOLS  fcc  / bytes used for symbols/
         fcb  $00
L1533    fcc  /ASM:/
*
READLINE pshs u,y,x,b,a Save registers.
         lda  IFLAG Keyboard input prompt?
         beq  L1549 If no, skip.
         leax <L1533,pcr Point to 'ASM:',
         ldy  #$0004 (4 characters)
         lda  LOTPTHNO get listing output path #,
         OS9  I$Write write it out.
L1549    ldx  INBUFPTR Point to input buffer.
         ldy  #$0078 Read max. 120 bytes.
         lda  INPATHNO Input path number
L1551    OS9  I$ReadLn Read a line in.
         bcc  L156A Exit if no error.
         cmpb #$D3 Is error EOF?
         bne  L1560 If not, print error msgs.
         bsr  L156C Supplemental input file?
         bcc  L1549 Return to previous and retry.
L155E    bra  L156A Else return.
L1560    OS9  F$PErr Print OS9 error number.
         ldb  #$11 Local error msg number -
         lbsr PRINTERR print local error message.
         bsr  L156C Close 1 input file (if poss.)
L156A    puls a,b,x,y,u,pc Else return.
*
L156C    ldu  USTKTPTR Are there open
         cmpu USTAKPTR input files still?
         bne  L1576 If so, branch.
         orcc #$01 Else reset carry bit,
         rts return.
L1576    lda  INPATHNO Get input pathno. to close.
         pulu b Get prior input path #.
         stu  USTKTPTR Record new stack top.
         stb  INPATHNO Replace input path number.
         OS9  I$Close Close other one.
         bcc  L1586 Exit if successful.
         OS9  F$PErr Else print error #,
L1586    rts then exit.
*
L1587    pshs b,a Save binary number on stack.
         lda  #$24 Write '$'
         sta  ,x+ to outstring.
         ldd  ,s Retrieve number,
         lbsr L1057 write 4 hex digits + space.
         puls a,b Retrieve number again,
L1594    lbsr BINTODEC write 5 decimal digits.
         tfr  u,y Put text pointer where nec.
         lbsr L11BD Transfer text to outstring.
         lbra L1368 Write line, tally, return.
*
FINSHUP  lbsr L1323 Empty code buffer.
L15A2    lbsr L149A Write a blank line.
         ldd  ERRORCNT
         leau ERRORS,pcr Point to ' error(s)',
         bsr  L1594 write line of digits+string.
         ldd  WARNGCNT Get warning count,
         leau WARNINGS,pcr point to ' warning(s)',
         bsr  L1594 write decimal digits+string.
         ldd  CDBYTCNT Get code byte count,
         leau PROGBYTS,pcr point to ' program bytes',
         bsr  L1587 write hex, dec, and string.
         ldd  DBYTCNT Get data byte count,
         leau DATABYTS,pcr point to ' data bytes',
         bsr  L1587 write hex, dec, and string.
         ldd  STABLPTR Find end of symbol table,
         subd <$10 subtract beginning of it.
         leau SYMBOLS,pcr Point to 'bytes...symbols',
         bsr  L1587 write hex, dec, and string.
         lda  SFLAG Print out symbol table?
         beq  L15D5 If no, skip.
         bsr  L1612 Else go do it.
L15D5    lda  IFLAG Keyboard input?
         bne  L15E9 If so, skip page-end steps.
         lda  FFLAG Use form feeds?
         beq  L15E2 If no, skip ahead.
         lbsr L147D Else write one FF,
         bra  L15E9 close paths and exit.
L15E2    ldb  LINSLEFT Get lines-left count,
         addb #$03 add 3 always blank,
         lbsr L1471 write them to finish page.
L15E9    ldu  USTKTPTR Any input paths
L15EB    cmpu USTAKPTR still open?
         beq  L15F7 If not, skip.
         pulu A Else get path number,
         OS9  I$Close close it,
         bra  L15EB loop and check again.
L15F7    clrb Indicate no error,
         OS9  F$Exit exit program.
*
L15FB    lda  #$01 Access mode = 'read'.
         OS9  I$Open Open input file.
         ldb  #$18 Error code (just in case).
         lbcs L1017 Branch on error.
         rts Else return O.K.
*
RESETPTR lda  INPATHNO
         ldu  #$0000
         tfr  U,X
         OS9   I$Seek   
         rts   
*
L1612    ldb  PAGWIDTH
         clra  
         tfr  D,X
         ldb  #$10
         lbsr L118E
         stb  <$3D
         stb  <$3C
         lbsr L149A
         ldu  <$10
         ldb  #$1A
         pshs B
L1629    ldy  ,U++
         beq  L1656
L162E    pshs U,Y
         bra  L1644
L1632    leau ,Y
         tfr  D,Y
L1636    ldd  $0B,Y
         bne  L1632
         bsr  L165F
         ldy  $0D,Y
         sty  $0B,U
         bne  L1636
L1644    ldu  ,S
         ldy  $0B,U
         bne  L1636
         leay ,U
         bsr  L165F
         puls U,Y
         ldy  $0D,Y
         bne  L162E
L1656    dec  ,S
         bne  L1629
         leas $01,S
         lbra L1370
*
L165F    pshs U,Y
         ldd  $09,Y
         lbsr L1057
         lda  $08,Y
         leau <L1691,pcr
         lda  A,U
         ldb  #$20
         std  ,X++
         ldb  #$08
L1673    lda  ,Y+
         bne  L1679
         lda  #$20
L1679    sta  ,X+
         decb 
         bne  L1673
         dec  <$3C
         beq  L1688
         lda  #$20
         sta  ,X+
         bra  L168F
L1688    lbsr L1370
         ldb  <$3D
         stb  <$3C
L168F    puls PC,U,Y
*
L1691    fcc  /ULSED/
L1696    pshs y,x Save registers.
         lbsr L15FB Open input file.
         sta  INPATHNO Save path number.
L169D    lbsr SKIPSPAC Get next parameter byte.
         cmpa #$0D A C.R.?
         beq  L16CF Yes, restore and return.
         lbsr L0E33 No;  resume parsing params.
         lda  OFLAG Making executable file?
         beq  L16CF No;  restore and return.
         lda  -$01,x Retrieve previous byte.
         anda #$5F Mask sign & lowercase bits.
         cmpa #$0D A C.R.?
         beq  L16C7 Then use infilename for out.
         ldb  ,x Append current byte to d.
         cmpd #$4F3D Are they 'O='?
         bne  L16C7 No, use default filename.
         ldb  #$16 Possible error code.
         lda  EOTPTHNO If this is already nonzero,
         bne  L16D1 something is wrong.
         leax $01,x Move pointer to pathname,
         bsr  L16D4 create the file.
         bra  L169D Resume parsing parameters.
*
L16C7    lda  EOTPTHNO Output file already opened?
         bne  L16CF Then exit.
         ldx  ,s Else point to input pathname,
         bsr  L16D4 create outfile w. same name.
L16CF    puls x,y,pc Restore and return.
*
L16D1    lbra L1017 Take error exit.
*
L16D4    lda  #$06 Access mode = "-----ew-".
         ldb  #$2F Attributes = "--pe-prewr".
         OS9  I$Create Create the file.
         ldb  #$18 Error code (in case).
         bcs  L16D1 Branch on error.
         sta  EOTPTHNO Else store path number,
         rts return.
*
YEAR     ldb  #18 Start with 1800,
CENTLOOP incb count centuries up,
         suba #100 years down by 100,
         bcc  CENTLOOP until we pass 0.
         adda #100 Restore year to non-negative,
         pshs a save it for a bit.
         tfr  b,a Look at century count,
         lbsr BINTDEC2 write those 2 digits.
         puls a Retrieve year count,
         lbra BINTDEC2 write 2 more and return.
*
         emod
CSIZE      equ   *
