* SCSISYS Defined Offsets
*
* IT.STP (offset $14)
*  Bit Meaning
*  --- ---------------------------------------------------------------
*  7-2 Partition: 0 = no partition, 1-63 partition number
*  1-0 Slot:       Multipak slot number (0-3 => 1-4)
* 
* IT.TYP (offset $15)
*  Bit Meaning
*  --- ---------------------------------------------------------------
*  7   Hard Disk:  1 = hard disk, 0 = floppy disk (set to 1)
*  6   Fudge LSN0: 0 = OS-9 disk, 1 = non-OS-9 disk #
*  3-5 Clusters:   Cluster Size (0-7 => 1,2,4,8,16,32,64,128)
*  2   6309 Stack: 0 = None / Power Boost, 1 = NitrOS9
*  0-1 Sect Sizes: 0 = 256/512, 1 = 1024/2048, 3 = 4096/8192, 3=2336 #
* 
* IT.DNS (offset $16)
*  Bit Meaning
*  --- ---------------------------------------------------------------
*  7   512 Flag:   0 = 256 byte blocks, 1 = 512 byte blocks
*  5-6 LUN:        SCSI Logical Unit Number of drive (0-3)
*  4   Error Type: 0 = OS9 error, 1 = SCSI extended sense code
*  3   No Cache:   0 = cache this device, 1 = do not cache *
*  2   No Turbo:   0 = use accelerated handshaking, 1 = standard *
*  0-1 SCSI ID:    SCSI ID of the drive or controller (0-3)
*
* Notes on this descriptor:
*
*    - 6309 flag is OFF
*    - caching is disabled
*    - SCSI ID is 0
*    - 512 byte flag is ON


* Interface Address
         ifne  TC3
ADDR     equ   $FF76
         endc

         ifne  Kenton
ADDR     equ   $FF74
         endc

* SCSISYS specific fields
ITSTP    equ   $00
ITTYP    equ   $80
ITDNS    equ   $88

* Geometry
Sides    equ   $07
Cyls     equ   $0386
SectTrk  equ   $0034
SectTrk0 equ   $0034
Interlv  equ   $0001
SASiz    equ   $08

         nam   H0
         ttl   SCSISYS descriptor

         ifp1
         use   defsfile
         endc

tylg     set   Devic+Objct   
atrv     set   ReEnt+rev
rev      set   $09

         mod   eom,name,tylg,atrv,mgrnam,drvnam

         fcb   $FF mode byte
         fcb   $07 extended controller address
         fdb   ADDR physical controller address
         fcb   initsize-*-1  initilization table size
         fcb   $01 device type:0=scf,1=rbf,2=pipe,3=scf
         fcb   $00 drive number
         fcb   ITSTP step rate
         fcb   ITTYP drive device type
         fcb   ITDNS media density
         fdb   Cyls number of cylinders (tracks)
         fcb   Sides number of sides
         fcb   $00 verify disk writes:0=on
         fdb   SectTrk # of sectors per track
         fdb   SectTrk0 # of sectors per track (track 0)
         fcb   Interlv sector interleave factor
         fcb   SASiz minimum size of sector allocation
initsize equ   *

name     fcs   /H0/
mgrnam   fcs   /RBF/
drvnam   fcs   /SCSISYS/

         emod
eom      equ   *
         end
