
* ClkAddr  by Bruce Isted
*          based on "DMode", a program by Kevin K. Darling
*
* The ClkAddr utility is used to set the base hardware address in the fake
* M$Mem minimum memory requirement of some real time clock modules.
*
* Released to the Public Domain 89/06/22.

 ifp1
 use os9defs.l2v3
 use scfdefs
 endc

BuffSize equ 10 max. CHAR string length
Edtn equ 1
MaxSize equ $0400 maximum module size
Vrsn equ 1

 org 0
Count rmb 1 number of option bytes
DataPtr rmb 2 current option ptr
HexIn rmb 2 2 byte hex number
ModAddr rmb 2 module address
ModSize rmb 2 module size
ParmPtr rmb 2 next name DataPtr
PathNmbr rmb 1 file path
TxtPtr rmb 2 option name ptr
Buffer rmb BuffSize miscellaneous output buffer
ModBuff rmb MaxSize module work copy buffer
      rmb $0200 stack and parameter space
MemSize equ .

 mod Size,Name,Prgrm+Objct,ReEnt+Vrsn,Entry,MemSize

Name fcs "ClkAddr"
 fcb Edtn edition number

OptTable
 fcc " nam" option name
 fcb Sign+M$Name,0 offset to string offset, no changes allowed
 fcc " hpa"
 fcb M$Mem,2 fake memory requirement is really RTC base address
TablOpts equ (*-OptTable)/6 number of table entries
 fcb $80 end of option table

UseMsg
 fcb C$LF
 fcc "Usage:  ClkAddr [/<module> || -<pathlist>] [option] [option] [...]"
 fcb C$LF,C$LF
 fcc "Purpose:  To report or alter the current option settings of real time"
 fcb C$LF
 fcc "          clock modules in memory or on disk in single module files."
 fcb C$LF,C$LF
 fcc "Options:  nam = Real time clock module name.  Can't be altered."
 fcb C$LF
 fcc "          hpa = Base hardware port address in fake M$Mem requirement."
 fcb C$LF,C$LF
 fcc "Examples:  clkaddr /clock"
 fcb C$LF
 fcc "               Prints the current option settings of the Clock module"
 fcb C$LF
 fcc "               in memory."
 fcb C$LF
 fcc "           clkaddr -modules/clock.rtc hpa=ff6c"
 fcb C$LF
 fcc "               Sets the base hardware address of the real time clock"
 fcb C$LF
 fcc "               module in the MODULES/Clock.rtc file to $FF6C."
 fcb C$CR
UseLen equ *-UseMsg

Equal fcc "="

TypeMsg
 fcb C$LF
 fcc "Not a Clock module!"
CR fcb C$CR
TypeLen equ *-TypeMsg

Sizemsg
 fcb C$LF
 fcc "Module size out of range!"
 fcb C$CR
Sizelen equ *-Sizemsg

SynMsg
 fcb C$LF
 fcc "Syntax error:  "
SynLen equ *-SynMsg

****************
* miscellaneous error and help routines

BadSize
 leax Sizemsg,pc
 ldy #Sizelen
 bra AddHelp

BadType
 leax TypeMsg,pc
 ldy #TypeLen
AddHelp
 lda #2
 os9 I$WritLn
Help
 leax UseMsg,pc
 ldy #UseLen
Helpprnt
 lda #2
 os9 I$WritLn
 lbra OkayEnd2

****************
Entry
 ldd #0
 std <ModAddr zero mod flag
 sta <PathNmbr zero file flag
 ldd ,x+ check for device name
 cmpa #'- file option?
 bne Link
* Use Filename to Get Desc:
 lda #Updat. open path to module file
 os9 I$Open
 bcs Help
 stx <ParmPtr
 sta <PathNmbr save path number
 ldy #MaxSize max size
 leax ModBuff,u module buff
 os9 I$Read get it
 lbcs Error
 ldd M$Size,x get module size
 cmpd #MaxSize module size OK?
 bhi BadSize no, go return error...
 std <ModSize
 bra GotIt

Link
 cmpa #'/ else must be /<modulename>
 bne Help
 pshs u
 lda #Systm
 os9 F$Link link to module
 bcs Help
 stx <ParmPtr update after name
 tfr u,x
 puls u
 stx <ModAddr
 ldd M$Size,x get module size
 cmpd #MaxSize module size OK?
 bhi BadSize no, go report error...
 std <ModSize
 tfr d,y copy module size...
 pshs u save data area pointer
 leau ModBuff,u

GetModLp
 lda ,x+
 sta ,u+
 leay -1,y
 bne GetModLp
 puls u recover data area pointer

GotIt
 leax ModBuff,u
 ldb M$Type,x get module type
 cmpb #Systm+Objct system (hopefully clock!) module?
 lbne BadType
 ldx <ParmPtr point to input parms
 lbsr SkipSpac go skip leading spaces...
 cmpa #C$CR no options?
 lbeq Info ..yes, give info
 leax -1,x

****************
* X=ParmPtr
* Find and Set Options:

FindLp10
 lbsr SkipSpac get next input param
 stx <ParmPtr save for syntax error use
 cmpa #C$CR end?
 lbeq Verify ..yes, update module CRC
 leay OptTable-6,pc ready option table ptr
 pshs u
 ldu ,x++ get next two chars
 ora #$20 convert 1st param char to lower case
 exg d,u move [U] where we can convert param chars
 ora #$20 convert 2nd param char...
 orb #$20 convert 3rd...
 exg d,u move back again

FindLp20
 leay 6,y next option entry
 tst ,y last entry?
 bmi Syntax ..yes, bad option
 cmpa 1,y
 bne FindLp20 same name?
 cmpu 2,y
 bne FindLp20 ..no, loop
* Found Option
 puls u
 sty <TxtPtr
 ldd ,x+ must be followed by "=", leave [X] pointing at char after "="
 cmpa #'=
 bne Syntax
 cmpb #C$CR rest of option missing?
 beq Syntax yes, go report error
 cmpb #C$SPAC rest of option missing?
 beq Syntax yes, go report error
 ldb 5,y get # of bytes
 beq Syntax 0 bytes, not allowed to change this option
 stb <Count
 ldb 4,y get option offset or offset to option offset
 bpl NumOpt option offset, go set hexadecimal option
* Get CHAR input and set option:
 andb #^Sign clear sign bit of offset to string offset
 clra [D] = offset to string offset within module
 cmpd <ModSize is it OK?
 bhs Syntax no, go report error...
 leay ModBuff,u point to module
 ldd b,y get offset to string
 cmpd <ModSize is it OK?
 bhs Syntax no, go report error...
 leay d,y point to option
 pshs y save option pointer
 os9 F$PrsNam valid OS-9 name?
 puls y recover option pointer (end of name pointer lost)
 bcs Syntax no, go report error
 cmpa #C$SPAC space delimiter char?
 beq ChkLen yes, go check name length...
 cmpa #C$CR <CR> delimiter char?
 bne Syntax no, go report error

ChkLen
 cmpb <Count name length OK?
 bhi Syntax no, go report error...

SetChrLp
 lda ,x+ get character
 sta ,y+ save it to module copy
 decb done yet?
 bne SetChrLp no, go copy another char...
 lda -1,y get last char
 ora #Sign set sign bit
 sta -1,y save last char
 lbra FindLp10 go do next...

* Syntax Error:
Syntax
 leax SynMsg,pc
 ldy #SynLen
 lda #2
 os9 I$Write
 ldx <ParmPtr
 leax -1,x
 pshs x
 ldy #0

CntLoop
 leay 1,y
 lda ,x+
 cmpa #C$CR
 beq SynSay
 cmpa #C$SPAC
 bne CntLoop

SynSay
 puls x
 lda #2
 os9 I$Write output err
 lbra OkayEnd

* Get Hex Input and Set Option:
NumOpt
 clra [D] = option offset
 cmpd <ModSize is it OK?
 bhs Syntax no, go report error...
 clr <HexIn zero hex input bytes
 clr <HexIn+1

SetNumLp
 lda ,x+ get next #
 cmpa #C$SPAC end of number?
 beq SetNum2 ..yes, set option
 cmpa #C$CR end of line?
 beq SetNum1 ..yes, set option
* Convert ASCII Hex-->Byte:
 suba #$30 make number from ASCII
 bmi Syntax
 cmpa #10 is it number?
 bcs Num
 anda #$5F make uppercase
 suba #$11-$0A make hex $A-$F
 cmpa #$0A
 bcs Syntax
 cmpa #$10 not hex char?
 bcc Syntax

Num
 ldb #16 fancy asl *4
 mul
 pshs b save top 4 bits
 ldd <HexIn
 rol ,s
 rolb
 rola
 rol ,s
 rolb
 rola
 rol ,s
 rolb
 rola
 rol ,s
 rolb
 rola
 std <HexIn
 puls b drop temp
 bra SetNumLp ..loop

SetNum1
 leax -1,x reset so can find <CR>

SetNum2
 ldb 4,y get option offset
 leay ModBuff,u point to module
 leay b,y point to option
 ldd <HexIn pick up hex input
 dec <Count
 beq SetOne
 std ,y set two byte option
 lbra FindLp10

SetOne
 tsta
 lbne Syntax
 stb ,y set one byte option

SetNDone
 lbra FindLp10

* --------------
* Skip Spaces:
SkipSpac
 lda ,x+
 cmpa #C$SPAC
 beq SkipSpac
 rts

* --------------
* Update Module CRC:
Verify
 pshs u save data ptr
 leau ModBuff,u
 tfr u,x X is mod address
 ldy M$Size,x Y is mod size
 leay -3,y beginning of chksum
 tfr y,d Y is byte count
 leau d,u set U to chksum
 lda #$FF init chksum
 sta ,u
 sta 1,u
 sta 2,u
 pshs u
 os9 F$CRC calc new crc
 puls u
 com ,u+ fix it up right
 com ,u+
 com ,u
 lda <PathNmbr was it file?
 beq MemMod ..no, in memory
 ldx #0
 tfr x,u
 os9 I$Seek go back to file begin
 bcs Error
 puls u
 leax ModBuff,u
 ldy <ModSize
 os9 I$Write update module file
 bra OkayEnd

MemMod
 ldu ,s get data area pointer
 leax ModBuff,u
 ldy <ModSize
 ldu <ModAddr

PutModLp
 lda ,x+
 sta ,u+
 leay -1,y
 bne PutModLp
 puls u recover data area pointer
 bra OkayEnd2

OkayEnd
 bsr OutCR

OkayEnd2
 clrb okay

Error
 pshs b,cc
 ldu <ModAddr
 beq Bye
 os9 F$UnLink

Bye
 puls b,cc
 os9 F$Exit we're done...

* --------------
* Print a <CR>:
OutCR
 leax CR,pc
 ldy #1
 lda #1
 os9 I$WritLn
 rts

****************
* Output Current Desc Info:
Info
 bsr OutCR do a <CR>
 ldb #TablOpts number of table entries
 pshs b save counter
 leax OptTable,pc point to text table
 stx <TxtPtr

InfoLoop
 ldx <TxtPtr
 ldy #4
 lbsr OutPut print option name
 leax Equal,pc
 ldy #1
 lbsr OutPut print =
 ldx <TxtPtr
 ldb 4,x get offset to HEX option;  if minus, offset to option offset
 bpl PrintHex go do simple offset to HEX option
 andb #^Sign clear sign bit
 clra [D] = offset to string offset within module
 cmpd <ModSize is it OK?
 bhs MovePtr no, skip this option...
 leay ModBuff,u point [Y] to module work copy
 ldd b,y get string offset within module
 cmpd <ModSize is string offset OK?
 bhs MovePtr no, skip this option...
 leay d,y point [Y] to CHAR string
 lda #BuffSize get max. chars to print
 leax Buffer,u point [X] to CHAR string buffer
 clr <Count init counter

CharCopy ldb ,y+ get char
 bpl NotLast sign bit clear so not last, go on...
 andb #^Sign clear sign bit
 lda #1 set up as last char

NotLast stb ,x+
 inc <Count count chars in string
 deca done yet?
 bne CharCopy no, go do another char...
 ldb <Count get chars in string ([A]=0, so [D]=char count)
 tfr d,y module name length into [Y]
 leax Buffer,u point [X] to CHAR string copy
 bsr OutPut print CHAR string
 bra MovePtr skip HEX output routine

* Print Hex Option Values:
PrintHex
 ldx <TxtPtr
 ldb 5,x get # of digits
 stb <Count
 ldb 4,x get option offset in module
 clra [D] = option offset within module
 cmpd <ModSize is option offset OK?
 bhs MovePtr no, skip this option...
 leax ModBuff,u point [X] to module work copy
 abx point [X] to option
 stx <DataPtr

* Print One Byte:
NumLoop
 ldx <DataPtr
 lda ,x+
 stx <DataPtr
 pshs a
 lsra
 lsra
 lsra
 lsra
 bsr OutOne
 puls a
 anda #$0F
 bsr OutOne
 dec <Count
 bne NumLoop

MovePtr
 ldx <TxtPtr
 leax 6,x
 stx <TxtPtr
 dec ,s
 lbeq OkayEnd done...
 ldb ,s
 bitb #$07 # of options remaining evenly divisible by eight?
 lbne InfoLoop no, go print next option on same line
 lbsr OutCR <CR> after every 8th option
 lbra InfoLoop ..loop

* --------------
* Print 1/2 Byte Hex Char:
OutOne
 cmpa #10
 bcs Number
 adda #$11-10 make alpha

Number
 adda #$30 make ASCII
 sta <Buffer
 leax Buffer,u
 ldy #1

OutPut
 lda #1 std out
 os9 I$Write
 lbcs Error
 rts

 emod
Size equ *
 end

