/*
   These routines handle lower level disk accesses.

   Currently, this doesn't allow the disk to have different number of
   sectors per track.  Traditional/classic OS9 let's track 0 be in single
   density and have fewer tracks than the rest of the disk.

   Does OS9 allow for sectors other than 256 bytes?  If so, I need to
   change a few things!

   I might want to try and access the disk with a different function.
   I could use Turob C's ABSREAD(), but it uses int 25h/26h, and those
   are supposed to be obsolete and avoided.  I could use BIOSDISK() or
   BIOS_DSK(), which are wrappers for how I'm doing it already.  I don't
   know if these work with hard drives or not.
   
   I could also use DOS int 440d 41h & 61h which are supposed to be able
   read floppies & hard drives by sectors.
*/


/* The sector cache */
long cachedlsn=-1L;
unsigned char sectbuf[1024];
/* Should only need 256, but allow for 1024 just in case. */

int ReadTheDisk(long lsn,unsigned char *buffer)
/* 
   Read sector LSN
   This will be changed to fit MS-DOS's absolute sector I/O rather than
   OS9's byte offset access to disk
   This is the only function that actually physically reads the disk.

   You really shouldn't call this directly since little error checking
   is done and no retries are performed.

   This is level 0 of the disk input routine.  All it knows how to do
   is low level sectior input.

*/
{int sect,track,head;
union REGS inreg;
union REGS outreg;
struct SREGS sreg;
void far *ptr;
int lenread;
int failed;

if (lsn==cachedlsn) {memcpy(buffer,sectbuf,256);return TRUE;}


if (options.virtdisk)
  {failed=fseek(options.pcvirtfile,lsn*256L,SEEK_SET);
   if (failed)
     {
      if (options.debug)
        {
         fprintf(stderr,"Unable to seek to %lu\n",lsn*256L);
        }
      return FALSE;
     }
   if (options.debug > 2) printf("ReadTheDisk LSN=%lu\n",lsn);
   lenread=fread(sectbuf,1,256,options.pcvirtfile);
   if (lenread == 256) cachedlsn=lsn;
   else {cachedlsn=-1;return FALSE;}
  }
else {
      track= (int) (lsn / diskinfo.cylsectors);
      sect=((int) (lsn % diskinfo.cylsectors));  /* 0 based */
      head=sect / diskinfo.sectors;
      sect=(sect % diskinfo.sectors) + 1;  /* cvt to 1 based */


      if (options.debug > 2)
        {printf("ReadTheDisk LSN=%lu\n",lsn);
         printf("Track=%d Sect=%d Head=%d\n",track,sect,head);
        }

      ptr=&sectbuf[0];
      inreg.h.ah=2;       /* int 13h, fcn 2, read sector */
      inreg.h.al=1;       /* 1 sector */
      inreg.x.bx=FP_OFF(ptr);
      inreg.h.ch=track;   /* track */
      inreg.h.cl=sect;    /* sector # */
      inreg.h.dh=head;    /* head/side */
      inreg.h.dl=options.drivenum;
      sreg.es=FP_SEG(ptr);
      sreg.ds=FP_SEG(ptr);
      int86x(0x13,&inreg,&outreg,&sreg);

      if (outreg.x.cflag!=0)
        {
         if (options.debug > 1)
            {fprintf(stderr,"Unable to read sector.  ah=$%x al=$%x\n",
                 outreg.h.ah,outreg.h.al);
             fprintf(stderr,"drive: %d\n",options.drivenum);
            }
         cachedlsn=-1;
         return(FALSE);
        }
      cachedlsn=lsn;
     }
memcpy(buffer,sectbuf,256);
return(TRUE);
}

int WriteTheDisk(long lsn,unsigned char *buffer)
/* 
   Write sector LSN
   This will be changed to fit MS-DOS's absolute sector I/O rather than
   OS9's byte offset access to disk
   This is the only function that actually physically writes the disk.

   It does not cache write sectors.  However, it will invalidate the
   cache if you write the same LSN as is in the cache.

   You really shouldn't call this directly since little error checking
   is done and no retries are performed.

   This is level 0 of the disk output routine.  All it knows how to do
   is low level sectior output.

*/
{int sect,track,head;
union REGS inreg;
union REGS outreg;
struct SREGS sreg;
void far *ptr;
int lenwrote;
int failed;

/*
  Invalidate the cache.  We could copy it to the cache, but I prefer
  to do it this way in case we want to read the sector for verification.
*/
if (lsn==cachedlsn) {cachedlsn=-1L;}


if (options.virtdisk)
  {failed=fseek(options.pcvirtfile,lsn*256L,SEEK_SET);
   if (failed)
     {
      if (options.debug) fprintf(stderr,"Unable to seek to %lu\n",lsn*256L);
      return FALSE;
     }
   if (options.debug > 2) printf("WriteTheDisk LSN=%lu\n",lsn);
   lenwrote=fwrite(buffer,1,256,options.pcvirtfile);
   fflush(options.pcvirtfile);
   if (lenwrote != 256) return FALSE;
  }
else {
      track= (int) (lsn / diskinfo.cylsectors);
      sect=((int) (lsn % diskinfo.cylsectors));  /* 0 based */
      head=sect / diskinfo.sectors;
      sect=(sect % diskinfo.sectors) + 1;  /* cvt to 1 based */

      if (options.debug > 2)
        {printf("WriteTheDisk LSN=%lu\n",lsn);
         printf("Track=%d Sect=%d Head=%d\n",track,sect,head);
        }


      ptr=&buffer[0];
      inreg.h.ah=3;       /* int 13h, fcn 3, write sector */
      inreg.h.al=1;       /* 1 sector */
      inreg.x.bx=FP_OFF(ptr);
      inreg.h.ch=track;   /* track */
      inreg.h.cl=sect;    /* sector # */
      inreg.h.dh=head;    /* head/side */
      inreg.h.dl=options.drivenum;
      sreg.es=FP_SEG(ptr);
      sreg.ds=FP_SEG(ptr);
      int86x(0x13,&inreg,&outreg,&sreg);

      if (outreg.x.cflag!=0)
        {
         if (options.debug > 1)
            {fprintf(stderr,"Unable to write sector.  ah=$%x al=$%x\n",
                 outreg.h.ah,outreg.h.al);
             fprintf(stderr,"drive: %d\n",options.drivenum);
            }
         return(FALSE);
        }
     }
return(TRUE);
}

void ResetDisk(void)
/*
  Tell the disk circuitry to reset itself
*/
{union REGS reg;struct SREGS sreg;

if (options.virtdisk)
   {
    if (options.pcvirtfile != NULL) rewind(options.pcvirtfile);
   }

if (options.drivenum != -1)
   {reg.h.ah=00;
    reg.h.dl=00;
    int86x(0x13,&reg,&reg,&sreg);
    if (reg.x.cflag!=0)
      {fprintf(stderr,"Error reseting disk %d\n",reg.h.ah);
       QuitProgram(EFAULT);
      }
   }
}

void FinishedDisk( void )
/*
  This has to be done or you won't be able to access the
  drive from MS-DOS
*/
{char far *(far *vect78h);char far * bpsvec;

if (options.virtdisk)
  {
   if (options.pcvirtfile != NULL) fclose(options.pcvirtfile);
  }

if (options.drivenum != -1)
     {
      vect78h=(char far *(far *))(0x78);
      bpsvec=3 + *vect78h;
      *bpsvec=(char) 2;
     }
}

void PrepOS9Disk(void)
/*
  do what you need to be able to read the disk by sectors
  Tell MS-DOS that we are using 256 byte sectors instead of 512
  0=128, 1=256, 2=512, 3=1024
*/
{char far *(far *vect78h);char far * bpsvec;char *op;

if (options.virtdisk) /* r+b varies from compiler to compiler */
   {if (options.put) op="r+b"; else op="rb"; /* for protection */
    options.pcvirtfile=fopen(options.vdiskname,op);
    if (options.pcvirtfile == NULL)
      {fprintf(stderr,"Unable to open virtual disk: %s\n",options.vdiskname);
       QuitProgram(ENOFILE);
      }
   }

if (options.drivenum != -1)
     {
      vect78h=(char far *(far *))(0x78);
      bpsvec=3 + *vect78h;
      *bpsvec=(char) 1;
     }
}

