char buffer[16384];


void DoPut(OS9FILE dir)
/*
  Write a file to an OS9 disk.
  
  Note that I do direct WriteBytes() I/O to write the new directory
  entry, it's fdesc, and the updated directory fdesc.
*/
{OS9FILE fd;struct s_filedesc fdOS9;
 struct DirEntry direntry;struct s_dirent direntryOS9;
/* struct s_filedesc dirOS9; */
 
 struct tm ftm;
 time_t ftm0;
 unsigned long fdlsn;
 unsigned long dirpos;
 int x;
 int buflen;

OpenSourceFile(options.pcfilename);


if (SearchDir(dir,options.filename,&direntry))
  {fprintf(stderr,"File %s already exists\n",options.filename);
   fprintf(stderr,"I can not yet overwrite it\n");
   QuitProgram(ENOFILE);
  }

/*
  Look for an unused directory entry.  Notice, I'm passing "" as the
  filename.  This is a null string and will match on the null string
  in an unused directory entry.

  If there isn't an unused one, make one
*/
dirpos=SearchDir(dir,"",&direntry);
if (dirpos==0L)  /* Nope, no unused entry.  Have to extend directory */
  {if (!ExtendFile(&dir,sizeof (direntryOS9)))
     {fprintf(stderr,"Unable to extend file\n");
      QuitProgram(0);
     }
   dirpos=dir.curpos;
  }

if (options.debug) printf("Dir entry POS=%lu\n",dirpos);

/* Get the file date & time */
ftm0=time(0);
ftm=*localtime(&ftm0);

/* create a new file descriptor */
fd.fd_att=0x3f;  /* full private & public access */
fd.fd_own=0;     /* User 0 owns the file */
fd.fd_date[0]=ftm.tm_year;
fd.fd_date[1]=ftm.tm_mon;
fd.fd_date[2]=ftm.tm_mday;
fd.fd_date[3]=ftm.tm_hour;
fd.fd_date[4]=ftm.tm_min;
fd.fd_link=1;
fd.fd_fsize=0L;  /* we'll extend it later. */
fd.fd_dcr[0]=fd.fd_date[0];
fd.fd_dcr[1]=fd.fd_date[1];
fd.fd_dcr[2]=fd.fd_date[2];
for (x=0;x<48;x++)
  {fd.fd_seg[x].baddr=0L;fd.fd_seg[x].saddr=0L;
   fd.fd_seg[x].bsize=0L;fd.fd_seg[x].ssize=0L;
  }
fd.activeseg=0;
fd.curpos=0L;
fd.segbytes=0L;
fd.bytesleft=0L;
fdlsn=AllocateSector()*256L;
fd.homeptr=fdlsn;

if (fdlsn == 0) {printf("Disk full\n"); QuitProgram(EFAULT); }

/* set up a new directory entry */
strncpy(direntry.dir_name,options.filename,30);
direntry.dir_addr=fdlsn;

/* Convert the PC structures to OS9 structures */
fdOS9=CvtFDesc2OS9(&fd);
direntryOS9=CvtDirEntry2OS9(&direntry);
/* dirOS9=CvtFDesc2OS9(&dir); */

/* Okay now, write to the disk */
if (options.debug)
  {
   printf("We are writing the new dir entry and fdesc\n");
   printf("New entry at %lu and it's fdesc at %lu\n",dirpos,fdlsn);
   printf("Directory fdesc itself at %lu\n",dir.homeptr);
  }
WriteBytes(fdlsn,&fdOS9,sizeof(fdOS9));
WriteBytes(dirpos,&direntryOS9,sizeof(direntryOS9));

/* okay, we now have everything set up on the OS9 disk.  Copy file */
OS9FSeek(&fd,0L);  /* start at the beginning */
while ((buflen=fread(buffer,1,16384,options.pcfile)) !=0)
  {if (options.ascii) buflen=CvtAsc2Bin(buffer,buflen);
   if (buflen != OS9FWrite(&fd,buffer,buflen))
      {fprintf(stderr,"Error occured during writing OS9 file\n");
       QuitProgram(0);
      }
  }

/* we stopped reading.  Why? */
if (ferror(options.pcfile))
  {fprintf(stderr,"An error occured while reading the PC file\n");
   QuitProgram(errno);
  }

/* We've written the file, now we have to save it's updated fdesc */
fdOS9=CvtFDesc2OS9(&fd);
WriteBytes(fdlsn,&fdOS9,sizeof(fdOS9));
/* and DAM */
WriteDAM();
}

void OpenSourceFile(char *filename)
{
options.pcfile=fopen(filename,"rb");
if (options.pcfile==NULL)
  {
   fprintf(stderr,"Unable to open %s for reading\n",filename);
   QuitProgram(errno);
  }
}

int CvtAsc2Bin(char *buf,unsigned int bufsize)
/*
  Remove CR/LF pairs.
  Normally, I'd check for actual pairs, but since CoCo OS9 doesn't even
  recognize LF (ascii 10), there isn't any point to leaving any LF's in.
*/
{char *t,*f;int count;
t=f=buf;
count=0;
while (bufsize--) if (*f == 10) f++;
                  else {*t++=*f++;count++;}
return count;
}


