
void DoGet(OS9FILE dir)
/*
  Copy a file from OS9 to PC
*/
{OS9FILE fd;struct DirEntry direntry;
 unsigned int bytesread;
 unsigned int byteswritten;
 char buffer[512];   /* buffer needs to be twice size we are reading */
                     /* because of possible cr->cr/lf translation */

if (options.debug)
  {printf("Opening %s for binary write\n",options.filename);}

/* We're in the directory, now find the file. */

if (!SearchDir(dir,options.filename,&direntry))
  {fprintf(stderr,"File %s not found on OS9 disk\n",options.filename);
   QuitProgram(ENOFILE);
  }

fd=OS9FOpen(direntry.dir_addr);

OpenDestFile(options.pcfilename);

while (TRUE)
   {bytesread=OS9FRead(&fd,buffer,256);
if (options.debug) {printf("Bytes Read in DOGET: %d\n",bytesread);}

    if (bytesread == 0) break;
    if (options.ascii) bytesread=CvtBin2Asc(buffer,bytesread);
    byteswritten=fwrite(buffer,1,bytesread,options.pcfile);
    if (byteswritten != bytesread)
       {fprintf(stderr,"Write to PC file failed\n");
        QuitProgram(errno);
       }
   }

fclose(options.pcfile);
options.pcfile=NULL;

}

void OpenDestFile(char *filename)
/*
  I may need to do a little file name conversion, but I'm not going
  to worry about that right now.
*/
{
options.pcfile=fopen(filename,"wb");
if (options.pcfile==NULL)
  {fprintf(stderr,"Unable to open %s for writing\n",filename);
   QuitProgram(errno);
  }
}

int CvtBin2Asc(char *buf, unsigned int bufsize)
/*
  Convert CR into CR/LF
  I don't like the way this routine is written
*/
{unsigned int x,y;char buff2[512];

for (y=x=0;x<bufsize;x++)
  {buff2[y++]=buf[x];
   if (buf[x] == 0x0d) buff2[y++]=0x0a;
  }
memcpy(buf,buff2,y);
return y;
}

