#include "oscom.h"
#include <process.h>
#include <cglob.h>

void setup(void)
{
	char *p, cpath[41];
	u_int32 len;

	len = sizeof(kbuf);
	_os_gs_popt(0, &len, &kbuf);
	len = sizeof(okbuf);
	_os_gs_popt(0, &len, &okbuf);

	if ((p = getenv(PORTVAR)) == NULL) {
		strcpy(mparam.modemport, DEFAULTPORT);
	} else {
		strcpy(mparam.modemport, p);
	}
	
	if ((p = getenv(CONFIGVAR)) != NULL) {
		strcpy(cpath, p);
	} else {
		strcpy(cpath, DEFAULTCON);
	}

	strcat(cpath, "/");
	strcat(cpath, INITFILE);
	strcpy(initfile, cpath);
	
	Introduce();

	if (_os_open(mparam.modemport, FAM_WRITE | FAM_READ, &modem) != 0) {
		cleanup("cannot open modem port");
	}

	len = sizeof(mbuf);
	_os_gs_popt(modem, &len, &mbuf);
	len = sizeof(ombuf);
	_os_gs_popt(modem, &len, &ombuf);
	keyraw(0, &kbuf);
	modemraw(modem, &mbuf);
	ReadInit();
	ShowParams();
}


void ReadInit(void)
{
	FILE *fp;
	char line[256], *p;
	
	/* Attempt to open the init file and read */
	if (ParseOptions() == SUCCESS) {
		SetModem();
	} else { /* attempt to open was not successful, create it */
		/* Set default options */
		mparam.baud = BAUD9600;	/* 9600 baud */
		mparam.wordsize = WORDSIZE8;
		mparam.parity = NOPARITY;
		mparam.stopbits = ONESTOP;
		strcpy(mparam.modeminit, "ATZ");
		WriteOptions();
		SetModem();
	}
	return;
}


void SetModem(void)
{
	u_int32 len;
	scf_lu_opts optpak;

	len = sizeof(optpak);
	_os_gs_luopt(modem, &len, &optpak);
	optpak.v_baud = mparam.baud;
	optpak.v_parity = mparam.parity;
	optpak.v_wordsize = mparam.wordsize;
	optpak.v_stopbits = mparam.stopbits;
	_os_ss_luopt(modem, len, &optpak);

	return;
}


void Introduce(void)
{
	printf("%c OSCom 1.0\n", DELIM_CHAR);
	printf("%c Type <^%c><?> for Help\n", DELIM_CHAR, 64+metachar);
	CR();

	return;
}


void ShowParams(void)
{
	printf("%c Modem Port : %s\n", DELIM_CHAR, mparam.modemport);
	printf("%c Baud Rate  : %s\n", DELIM_CHAR, CodeToBaud(mparam.baud));
	printf("%c Word Length: %s\n", DELIM_CHAR, CodeToWordSize(mparam.wordsize));
	printf("%c Parity     : %s\n", DELIM_CHAR, CodeToParity(mparam.parity));
	printf("%c Stop Bits  : %s\n", DELIM_CHAR, CodeToStopBits(mparam.stopbits));
	printf("%c Echo       : %s\n", DELIM_CHAR, SwitchLogic(mparam.echo));
	printf("%c Linefeeds  : %s\n", DELIM_CHAR, SwitchLogic(mparam.linefeeds));
	CR();
	return;
}


int ParseOptions(void)
{
	FILE *fp;
	char line[256], *p, *e;
	
	if ((fp = fopen(initfile, "r")) != NULL) {
		while ((p = fgets(line, 255, fp)) != NULL) {
			if ((e = strchr(line, '\n')) != NULL) {
				*e = '\0';

				/* strip trailing spaces */
				while (isspace(*(e-1))) {
					e--;
					*e = '\0';
				}
			}
			if ((e = strchr(line, '=')) != NULL) {
				e++;
				while (isspace(*e)) {
					e++;
				}

				while (isspace(*p)) {
					p++;
				}

				if (struncmp("PORT", p, 5) == 0) {
					strcpy(mparam.modemport, e);
				} else if (struncmp("BAUD", p, 4) == 0) {
					mparam.baud = BaudToCode(e);
				} else if (struncmp("WORDLENGTH", p, 10) == 0) {
					mparam.wordsize = WordSizeToCode(e);
				} else if (struncmp("PARITY", p, 6) == 0) {
					mparam.parity = ParityToCode(e);
				} else if (struncmp("STOPBITS", p, 8) == 0) {
					mparam.stopbits = StopBitsToCode(e);
				} else if (struncmp("ECHO", p, 4) == 0) {
					mparam.echo = atoi(e);
				} else if (struncmp("LINEFEEDS", p, 9) == 0) {
					mparam.linefeeds = atoi(e);
				} else if (struncmp("MODEMINIT", p, 9) == 0) {
					strcpy(mparam.modeminit, e);
				}
			}
		}
		fclose(fp);
		return(SUCCESS);
	}
	return(FAILURE);
}


int WriteOptions(void)
{
	FILE *fp;
	char line[256], *p, *e;
	
	if ((fp = fopen(initfile, "w")) != NULL) {
		fprintf(fp, "PORT = %s\n", mparam.modemport);
		fprintf(fp, "BAUD = %s\n", CodeToBaud(mparam.baud));
		fprintf(fp, "WORDLENGTH = %s\n", CodeToWordSize(mparam.wordsize));
		fprintf(fp, "PARITY = %s\n", CodeToParity(mparam.parity));
		fprintf(fp, "STOPBITS = %s\n", CodeToStopBits(mparam.stopbits));
		fprintf(fp, "MODEMINIT = %s\n", mparam.modeminit);
		fprintf(fp, "ECHO = %d\n", mparam.echo);
		fprintf(fp, "LINEFEEDS = %d\n", mparam.linefeeds);
		fclose(fp);
		return(SUCCESS);
	}
	return(FAILURE);
}


void ForkShell(void)
{
	char *sh, shellname[12], *farg[2];
	process_id id;
	status_code status;

	if ((sh = getenv("SHELL")) == NULL) {
		strcpy(shellname, "SHELL");
		sh = shellname;
	}
	farg[0] = sh;
	farg[1] = NULL;

	printf("Forking %s...\n", sh);

	_os_ss_popt(0, sizeof(okbuf), &okbuf);
	_os_exec(_os_fork, 0, 3, farg[0], farg, _environ, 0, &id, 0, 0);
	_os_wait(&id, &status);
	_os_ss_popt(0, sizeof(kbuf), &kbuf);

	printf("%c Returning to OSCom...\n", DELIM_CHAR);

	return;
}
