/* slave.c */
/* This program is written by Dharmini Kumarasingham is part of the
   Individual project called The Local Area Network Job Sharer.It
   is called the "SLAVE" because this program waits for a master to
   login and accepts tasks from the master and completes them.To do
   this heaps of messages are passed to and from the slave.Comments
   are provided for the coding done below.
*/

/* builds a list of users and thier connection numbers into an array
   called userlist */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>
#include <process.h>

#include "spawno.h"     /* Use Ralf Brown's spawn to disk */

#define TRUE	1
#define FALSE	0

char *MASTER_LOGIN = "FRANK_V";

/* Netware specific prototypes */

#define BYTE  unsigned char
#define WORD  unsigned short
#define OT_USER                         0x01  /* The object is a "user"      */

extern int   ScanBinderyObject(char *, WORD, long *, char *, WORD *, char *, char *, char *);
extern int   GetBinderyObjectID(char *, WORD, long *);

extern int	 GetPersonalMessage(char *, WORD *);
extern int	 OpenMessagePipe(WORD *, BYTE *, WORD);
extern int	 SendPersonalMessage(char *, WORD *, BYTE *, WORD);
extern int	 CloseMessagePipe(WORD *, BYTE *, WORD);
extern int	 CheckPipeStatus( WORD *, BYTE *, WORD );

extern int   GetConnectionInformation(WORD, char *, WORD *, long *, BYTE *);
extern int   GetObjectConnectionNumbers(char *, WORD, WORD *, WORD *, WORD);
extern WORD   GetConnectionNumber(void);

#define MAXUSERS        100
#define MAXWAIT         10000

#define COMPLETE  3

struct User_Def {
    char name[48];
    long id;
    WORD connectionnumbers;
    WORD connectionlist[100];
};

static struct User_Def  userlist[MAXUSERS];     /* list of users on server       */

int     index_of_master;

/* To get the names and connection numbers of all users logged in */
/*=======================================================================*/
void getuserlist(void)
{
    char errormsg[50];
int     loop, numberofusers;
char    searchobjectname[48];
WORD    searchobjecttype;
char    objecthasproperties;
char    objectflag;
char    objectsecurity;
char    objectname[48];
WORD    objecttype;
long    objectid;
int     errorcode;

    strcpy( errormsg, "getuserlist:");
    numberofusers = 0;
    strcpy( searchobjectname, "*" );
    searchobjecttype = OT_USER;
    objectid = -1;
    errorcode = ScanBinderyObject( searchobjectname, searchobjecttype, &objectid,
        objectname, &objecttype, &objecthasproperties, &objectflag, &objectsecurity );
    if( errorcode != 0 ) {
        printf("\ngetuserlist: Cannot read user-list");
        return;
    }
    while( errorcode == 0 ) {
        strcpy( userlist[numberofusers].name, objectname );
        errorcode = GetBinderyObjectID( objectname, objecttype, &objectid );
        if( errorcode == 0x96 )
            strcat( errormsg, " Server out of memory");
        else if( errorcode == 0xef )
            strcat( errormsg, " invalid group name" );
        else if( errorcode == 0xf0 )
            strcat( errormsg, " wildcard not allowed" );
        else if( errorcode == 0xfc )
            strcat( errormsg, " no such object" );
        else if( errorcode == 0xfe )
            strcat( errormsg, " server bindery locked" );
        else if( errorcode == 0xff )
            strcat( errormsg, " bindery failure" );
        if( errorcode  != 0 ) {
            printf("\n%s\n", errormsg );
            return;
        }
        userlist[numberofusers].id = objectid;
        numberofusers++;
        if( numberofusers >= ( MAXUSERS - 1 ) ) {
            printf("\ngetuserlist: MAXUSERS exceeded");
            return;
        }
        errorcode = ScanBinderyObject( searchobjectname, searchobjecttype,
            &objectid, objectname, &objecttype, &objecthasproperties,
            &objectflag, &objectsecurity );
    }
    userlist[numberofusers].name[0] = NULL;
    userlist[numberofusers].id = 0x0l;

    /* now use users[] to obtain their connection numbers */
    for( loop = 0; loop < numberofusers; loop++ )
    {
       errorcode = GetObjectConnectionNumbers( userlist[loop].name, OT_USER,
	   &userlist[loop].connectionnumbers, userlist[loop].connectionlist, 1);
    }
}
/*=======================================================================*/

/*Get master information */
/*=======================================================================*/
int getmaster(char *mastername)
{
   int loopcount;
   getuserlist();
   for(loopcount = 0; loopcount < MAXUSERS; loopcount++)
       if(strcmp(mastername, userlist[loopcount].name)==0)
          return loopcount;
   return -1;
}
/*======================================================================*/

/*This function waits for a message from the master and does the task */
/*=======================================================================*/
void do_tasks(void)
{
  BYTE result;
  int  return_status;
  char msg_buff[127];
  WORD conn_id;
  char *start;
  int i;
  char *argv[20];

  while (TRUE) {
        /* wait for message from master */
    printf("Waiting for message...");
    do {
       conn_id = userlist[index_of_master].connectionlist[0];
       GetPersonalMessage(msg_buff, &conn_id);
       if (kbhit()) if (getch() == 0x1b) {
          printf("Aborted\n");
          exit(1);
       }
   } while (conn_id == 0);

   printf("Received message: %s\n", msg_buff);

   if (strncmp(msg_buff, "TASK TO DO", 10) == 0)
   {
     argv[0] = start = &msg_buff[10];
     for (i = 1; i < 20; i++) {
         start = strpbrk(start + 1, " \n");
         if (start != NULL) {
            *start = '\0';
            argv[i] = start + 1;
         } else {
            argv[i] = argv[i-1] = NULL;
            break;
         }
     }
     printf("\nExecuting %s\n", &msg_buff[10]);

     return_status = spawnvpo(".", &msg_buff[10], argv);

     /*if task completed*/
     if (return_status == 0 || return_status == -1)
     {
      if (return_status == -1) {
            perror("Program could not be run");
      }
      SendPersonalMessage("TASK_FINISHED", &userlist[index_of_master].connectionlist[0],&result,1);
     }
     /*if slave wants to logout*/
     else
     {
      SendPersonalMessage("Task_Interrupted",&userlist[index_of_master].connectionlist[0],&result,1);
      break;
     }
   }
   else if(strncmp(msg_buff, "JOB_COMPLETED", 13) == 0)
   {
     break;
  }
   }
   CloseMessagePipe(&userlist[index_of_master].connectionlist[0],&result,1);
}
/*=======================================================================*/



void main(int argc, char *argv[])
{
	BYTE result;
	long timetowait;
WORD    myconnectionid;     /* connection id of logged in user    */
long    myobjectid;         /* object id of user                  */
char    myobjectname[48];   /* my object user name                */
WORD    myobjecttype;
BYTE    logintime[7];

   if (argc >= 2)       MASTER_LOGIN 	= argv[1];

    myconnectionid = GetConnectionNumber();    /* getmy connection number */

    /* get my username */
	 GetConnectionInformation( myconnectionid, myobjectname, &myobjecttype,
				 &myobjectid, logintime );
    printf("My username = %s, My connection number = %d\n", myobjectname,
       myconnectionid );

    /* now get all users on server into Users[] */
    getuserlist();

	index_of_master = getmaster(MASTER_LOGIN);
	if( index_of_master == -1 ) {
		printf("Master name %s is unkown by this server.\n", MASTER_LOGIN);
		exit(0);
	}

	timetowait = 0;
	while( (userlist[index_of_master].connectionnumbers == 0) && (timetowait < MAXWAIT) )
	{
		GetObjectConnectionNumbers( userlist[index_of_master].name, OT_USER,
	   &userlist[index_of_master].connectionnumbers, userlist[index_of_master].connectionlist, 1);
	   timetowait++;
    }
     /* the user is logged in, or timetowait has expired */
	  if( timetowait == MAXWAIT ) {
       printf("Waited but master %s, but did not login\n", MASTER_LOGIN);
       exit(0);
     }
     /* opening a pipe */
     printf("%s has logged in\n", MASTER_LOGIN);
     OpenMessagePipe(&userlist[index_of_master].connectionlist[0],&result,1);
     printf("Waiting for Master to open pipe...");
     do {
          CheckPipeStatus(&userlist[index_of_master].connectionlist[0],&result,1);
     } while (result != 0);
     printf("done.\n");

     SendPersonalMessage("Ready to start",&userlist[index_of_master].connectionlist[0],&result,1);
   do_tasks();
}
