/* MASTER.C */

/* This program written by Dharmini Kumarasingham is a part of the Individual
   project called The Local Area Network Job Sharer.It is called the "MASTER"
   because this program when run on a PC has control over the other PC's
   which act as slaves.That is this program when run gets the connection
   information about itself and other logged in users and then assigns tasks
   to the other pcs which accept to do the specified tasks.The tasks could
   be programs which take hours to run or could be programs which do simple
   things such as running the seven segment display, the leds etc.So mostly
   the larger programs are divided into small parts and the various slaves
   work on(or run) different parts of the program and once their specified
   job has been accomplished they get back to the master which assembles the
   whole program and displays it on screen.To accomplish this sort of a
   system there is a heap of messages passed to and from the master.This is
   a broad view of what the master program is all about.
*/
/* Builds a list of users and their connection numbers into an array
   called userlist to get the connection information */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>

#define TRUE	1
#define FALSE	0

/* Netware specific prototypes */

#define BYTE  unsigned char
#define WORD  unsigned short
#define OT_USER                         0x01  /* The object is a "user"      */

extern int   ScanBinderyObject(char *, WORD, long *, char *, WORD *, char *, char *, char *);
extern int   GetBinderyObjectID(char *, WORD, long *);

extern int	 GetPersonalMessage(char *, WORD *);
extern int	 OpenMessagePipe(WORD *, BYTE *, WORD);
extern int	 SendPersonalMessage(char *, WORD *, BYTE *, WORD);
extern int	 CloseMessagePipe(WORD *, BYTE *, WORD);
extern int	 CheckPipeStatus( WORD *, BYTE *, WORD );

extern int   GetConnectionInformation(WORD, char *, WORD *, long *, BYTE *);
extern int   GetObjectConnectionNumbers(char *, WORD, WORD *, WORD *, WORD);
extern WORD   GetConnectionNumber(void);

#define MAXUSERS 100     /* Maximum users allowed in this system */
#define MAXWAIT  10000   /* Delay time */
#define MAXTASKS 100
#define FREE 0           /* When the slave has nothing to do */
#define BUSY 1           /* When the slave is handling a task */
#define NOT_STARTED 2
#define COMPLETE 3
#define NOT_THERE 4
#define NOT_DONE 5
#define PENDING 6
#define CMD_LEN 100

char *SLAVE_LOGIN  = "GUEST";
char *MASTER_LOGIN = "FRANK_V";

struct TASK{
       char cmd[CMD_LEN];
       char status;
       char task_table[10];  /* table of tasks available */
};

struct SLAVE{
       WORD connectionid;
       char status;
       char task;
};

struct User_Def {
       char name[48];
       long id;
       WORD connectionid;
       WORD connectionlist[50];
};

struct User_Def userlist[MAXUSERS]; /* list of users on server */

WORD myconnectionid; /* connection id of logged in user */
long myobjectid;
char myobjectname[48];
WORD myobjecttype;
char objectname[48];
WORD objecttype;
long objectid;
char searchobjectname[48];
WORD searchobjecttype;
char objecthasproperties;
char objectflag;
char objectsecurity;
int numberofusers;
int numberoftasks;
int errorcode;
BYTE logintime[7];

/* Builds a list of slaves or users who are currently logged in on the
   system into an array */
struct SLAVE slave_table[30]; /* There could be any number of salves as long
                               as it is less than 100*/
int numberofslaves = 0;
struct TASK task_table[10];

/* To get the names and connection numbers of all users logged in */
/*========================================================================*/
void getuserlist(void)
{
  char errormsg[50];
  strcpy( errormsg, "getuserlist: ");
  numberofusers = 0;
  strcpy( searchobjectname, "*" );
  searchobjecttype = OT_USER;
  objectid = -1;
  errorcode = ScanBinderyObject( searchobjectname, searchobjecttype,&objectid,
              objectname,&objecttype,&objecthasproperties,&objectflag,
              &objectsecurity);
  if( errorcode != 0)  {
      printf("\ngetuserlist: Cannot read user-list");
      return;
  }
  while( errorcode == 0) {
       strcpy( userlist[numberofusers].name, objectname );
       errorcode = GetBinderyObjectID( objectname, objecttype, &objectid);
       if(errorcode == 0x96 )
           strcat( errormsg, "Server out of memory ");
       else if( errorcode == 0xef )
           strcat( errormsg, "invalid group name" );
       else if( errorcode == 0xf0 )
           strcat( errormsg, "wildcard not allowed");
       else if( errorcode == 0xfc )
           strcat( errormsg, " no such object ");
       else if( errorcode == 0xfe )
           strcat( errormsg, "server bindery locked");
       else if( errorcode == 0xff )
           strcat( errormsg, "bindery failure");
       if( errorcode != 0 ) {
           printf("\n%s\n", errormsg );
           return;
       }
       userlist[numberofusers].id=objectid;
       numberofusers++;
       if( numberofusers >= (MAXUSERS - 1 )) {
         printf("\ngetuserlist: MAXUSERS exceeded");
         return;
       }
       errorcode = ScanBinderyObject( searchobjectname,searchobjecttype,
                   &objectid, objectname, &objecttype,&objecthasproperties,
                   &objectflag, &objectsecurity );
  }
  userlist[numberofusers].name[0]=NULL;
  userlist[numberofusers].id = 0x01;
}
/*========================================================================*/

/*If other masters exist then press ESC key to logout*/
/*========================================================================*/
void check_for_other_masters(void)
{
 int loop;
 return;                /*****************/
 for(loop = 0; loop < numberofusers; loop++)
 {
   if((strcmp(MASTER_LOGIN, userlist[loop].name) ==0) && (userlist[loop].connectionlist[1] != 0))
   {
     printf("Press ESC key to logout");
     while(getch() != 0x1b);
     exit(1);
   }
 }
}

/*=======================================================================*/

/*=======================================================================*/
void add_slave_to_table(WORD conn_id)
{
 WORD temp[3] = {0,0,0};
 BYTE result[3] = {0,0,0};

  slave_table[numberofslaves].connectionid = conn_id;
  temp[0] = conn_id;
  if (OpenMessagePipe(temp, result,1) == 0xfe) return;
  printf("Opened pipe to %d\n", conn_id);
  slave_table[numberofslaves].status = PENDING;
  numberofslaves++;
}
/*=======================================================================*/

/*=======================================================================*/
void build_task_table(char *fname)
{
  int t;
  FILE *input_file; /* declares pointers to an input file, and the
                                fopen function */
  input_file = fopen(fname, "rt");
  if (input_file == NULL) {
     printf("Couldn't open %s.\n", fname);
     exit(1);
  }
  /* While all tasks not done */
  t=0;
  while ((! feof(input_file)) && t<10)
  {
   fgets(task_table[t].cmd, CMD_LEN, input_file);
   task_table[t].status = NOT_STARTED;
   t++;
  }
  fclose (input_file);
  numberoftasks = t;
}
/*========================================================================*/

/*========================================================================*/
int find_next_task(void)
{
 int t;
 for (t = 0; t < numberoftasks; t++)
    if(task_table[t].status == NOT_STARTED)
         return t;
 return -1;
}
/*========================================================================*/
int findsource(WORD source)
{
  int i;
  for(i=0; i<numberofslaves; i++)
	 if(slave_table[i].connectionid == source)
			 return i;
	return -1;
}

/* Check for new slaves */
/*========================================================================*/
void check_for_new_slaves(void)
{
  int i;
  int j;
  int found;
  WORD conn_list[30];
  WORD num_connect;

  /* Getlist of users called GUEST */
  GetObjectConnectionNumbers(SLAVE_LOGIN, OT_USER, &num_connect, conn_list, 30);
  getuserlist();

  /* For each GUEST not in table */
  for (i = 0; i < num_connect; i++)
  {
    found = FALSE;
    for(j = 0; j < numberofslaves; j++)
    {
		if(slave_table[j].connectionid == conn_list[i])
      {
        found = TRUE;
        break;
      }
    }
    if (!found) add_slave_to_table(conn_list[i]);
  }
}
/*=======================================================================*/

/*This routine checks for free slaves and assigns tasks for all */
/*======================================================================*/
void check_for_free_slaves(void)
{
  int task_number;
  int i;
  BYTE result;
  char msg_buff[127];

  for (i=0; i < numberofslaves; i++)
  {
	 if(slave_table[i].status == FREE)
    {
      /*Assign task to slave */
      task_number = find_next_task();
      if(task_number != -1)
      {
      strcpy(msg_buff, "TASK TO DO");
      strcat(msg_buff, task_table[task_number].cmd);
		 printf("Sending message '%s' to %d\n", msg_buff, slave_table[i].connectionid);
       SendPersonalMessage(msg_buff, &slave_table[i].connectionid,&result,1);
       /* error checking */
       if (result == 0) {
       /* mark slave as working */
       slave_table[i].status = BUSY;
       slave_table[i].task = task_number;
       /* mark stating task is in progress */
       task_table[task_number].status=BUSY;
       }
      }
    }
  }
}
/*========================================================================*/

/*This function receives messages from slaves */
/*========================================================================*/
void receive_messages(void)
{
 int i;
 BYTE result;
 char msg_buff[127];
 WORD source;

	printf(".");
 /* for each message received */
	GetPersonalMessage(msg_buff, &source);
	while (source != 0)
	{
		printf("Received message '%s' from %d\n", msg_buff, source);
		i = findsource(source);
		if(strcmp(msg_buff, "Ready to start") == 0)
		{
			slave_table[i].status = FREE;
		}
		else if (strcmp(msg_buff, "TASK_FINISHED") == 0)
      {
  /*mark slave as free */
			slave_table[i].status=FREE;
  /* mark task as done */
			task_table[slave_table[i].task].status = COMPLETE;
		}
		else if (strcmp(msg_buff,"Interrupted") == 0)
		{
  /* remove slave from slave table */
			slave_table[i].status = NOT_THERE;
  /* mark task as not started */
			task_table[slave_table[i].task].status = NOT_DONE;
  /*close message pipe to slave */
			CloseMessagePipe(&slave_table[i].connectionid,&result,1);
		}
		GetPersonalMessage(msg_buff, &source);
	 }
}
/*========================================================================*/


void main(int argc, char *argv[])
{
 WORD maxconnections = 100;
   int loop, i;
   BYTE result;
   WORD num_connect;
   char *task_file_name = "TASK.BAT";

   if (argc >= 2)       task_file_name 	= argv[1];
   if (argc >= 3)       MASTER_LOGIN 	= argv[2];
   if (argc >= 4)       SLAVE_LOGIN 	= argv[3];

 myconnectionid = GetConnectionNumber();	/* getmy connection number */

 /* get my username */
 errorcode = GetConnectionInformation( myconnectionid, myobjectname,
             &myobjecttype, &myobjectid, logintime );
 printf("My username = %s, My connection number = %d\n", myobjectname,
         myconnectionid );
 /* get all users on server into users[] */
 getuserlist();

 /* use users[] to obtain their connection numbers */
 for (loop = 0; loop < numberofusers; loop ++)
 {
   errorcode = GetObjectConnectionNumbers( userlist[loop].name, OT_USER,
   &num_connect, userlist[loop].connectionlist,
   maxconnections );
 }
 check_for_other_masters();
 build_task_table(task_file_name);

	while (!kbhit()) {
		check_for_new_slaves();
		check_for_free_slaves();
		receive_messages();

  /* If all tasks completed */
	if (task_table[numberoftasks - 1].status == COMPLETE)
   /* for each slave */
   {
		for (i=0; i< numberofslaves; i++)
		{
			SendPersonalMessage("JOB_COMPLETED", &slave_table[i].connectionid,
                         &result, 1);
			CloseMessagePipe(&slave_table[i].connectionid, &result, 1);
		}
		exit(0);
	}
	}
}