#!/usr/local/etc/pagsh
#
# RCSID: $Header: /afs/andrew.cmu.edu/system/src/local/novstat/001/andrew/RCS/novstat-fetch-report,v 1.15 1993/10/07 22:05:12 ms5u Exp $
#
# Script to:
#    1) FTP file from Novell Server
#    2) Mail it to a bboard
#
# Revision History:
# $Log: novstat-fetch-report,v $
# Revision 1.15  1993/10/07  22:05:12  ms5u
# Change ftp.script to ftp.script.$$ for concurrency.
#
# Revision 1.14  1993/10/07  21:57:46  ms5u
# Changed /usr/local/bin/ftp to /bin/ftp.
#
# Revision 1.13  1993/10/07  21:52:16  ms5u
# Functions don't work on pmax sh...changed to a use of awk.
#
# Revision 1.12  1993/10/07  21:43:21  ms5u
# The ${1:?"text text text"} doesn't work on the pmax, so I replaced it
# with an if...then...fi block.
#
# Revision 1.11  1993/10/07  18:59:47  ms5u
# Modified to use faevery check and not loop internally.
#
# Revision 1.10  1993/10/07  17:59:14  ms5u
# Change from /usr/tmp to $workdir as specified in the configuration.
# (Can then use this directory for state information -- see next release.)
#
# Revision 1.9  1993/10/07  17:56:07  ms5u
# Renamed file to novstat-fetch-report from get-and-mail.
#
# Revision 1.8  1993/10/04  17:14:57  ms5u
# Changed /usr/user/novstat to /usr/tmp.
#
# Revision 1.7  1993/09/07  14:58:48  ms5u
# Changed print-to-atk from system/src to system/dest.
#
# Revision 1.6  1993/09/07  14:50:42  ms5u
# Update for configuration options specified with a configuration file.
# This file is specified on the commandline for get-and-mail.
# Also updated to move ireport.{cur,old} into ireport.{cur,old}-foo.bar.baz
# (the hostname) to allow multiple occurrences to run concurrently.
#
# Revision 1.5  1993/08/31  16:35:06  ms5u
# If "ireport.old" doesn't exist, touch one.
#
# Revision 1.4  1993/08/31  16:22:15  ms5u
# Added configuration variables (see initial part of shell script).
# Added retries with limits.
# Now compares current file with last file (to see if there's any
# difference).
#
# Revision 1.3  1993/08/28  18:53:17  ms5u
# Update to add RCS history information.
#
#
# Load configuration from script parameter
if [ x$1 = "x" ]
then
    echo "$0: no configuration file specified"
    exit 1
fi
. $1
#
#
# Start off in the right place
cd $workdir

# Check to see if we should run now...
runstat=`/usr/local/etc/ezfax2/bin/faevery read week stat.$hostname`
isok=`echo $runstat | awk '{ print $3 }'`
if [ $isok = "ok" ]
then
    /usr/local/bin/klog $authuser `cat $scriptpassfile`

    mv ireport.cur-$hostname ireport.old-$hostname

# Make sure there is something for diff to look at.
    if [ ! -f ireport.old-$hostname ]
    then
        touch ireport.old-$hostname
    fi
#
# At this point, the ireport.cur does not exist.  If the FTP fails, we'll
# be able to detect that by diff returning an error code of 2.  (We want
# diff to return a 1 which means that the files are indeed different.)
#
    echo "user novstat `cat $passfile`" > ftp.script.$$
    echo "cd /sys/novstat" >> ftp.script.$$
    echo "get ireport.cur ireport.cur-$hostname" >> ftp.script.$$
    echo "quit" >> ftp.script.$$

    /bin/ftp -n $hostname < ftp.script.$$
    rm -f ftp.script.$$
#
# If the FTP failed, we'll have no ireport.cur.  On the other hand, if it
# succeeded but we didn't get a new file (we got the same), we'll be able
# to detect that with diff.

    diff ireport.old-$hostname ireport.cur-$hostname > /dev/null
    if [ $? -eq 1 ]
    then
#
# Report is new, so send the mail.  First, prepare headers
# and other pre-report settings...
#
        echo -n "Date: " > message.$$
        date | awk '{ print $1", "$3" "$2" "$6" "$4" "$5 }' >> message.$$
        echo "From: Novell Statistics Daemon <$authuser+@ANDREW.CMU.EDU>" >> message.$$
        echo "Subject: `head -1 ireport.cur-$hostname`" >> message.$$
        echo "To: $recipient" >> message.$$
        echo "Content-Type: X-BE2; 12" >> message.$$
        echo "" >> message.$$

	/usr/local/etc/novstat-print-to-atk < ireport.cur-$hostname >> message.$$

#
# And mail the report...
#
        /usr/local/etc/queuemail -f message.$$ $recipient && rm message.$$

	succ=`/usr/local/etc/ezfax2/bin/faevery write week stat.$hostname`
    fi
fi
